/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.map;

import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapDef;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTableCursor;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb;

public class SqlJetMapTableCursor
extends SqlJetBtreeTable
implements ISqlJetMapTableCursor {
    private static final String KEY_MUST_BE_MORE_THAN_ZERO = "Key must be more than zero: ";
    private final SqlJetMapDb mapDb;

    public SqlJetMapTableCursor(SqlJetMapDb mapDb, ISqlJetBtree btree, SqlJetMapDef mapDef, boolean writable) throws SqlJetException {
        super(btree, mapDef.getVirtualTableDef().getPage(), writable, false);
        if (!mapDb.isInTransaction()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Cursor requires active transaction");
        }
        this.mapDb = mapDb;
    }

    @Override
    public long getKey() throws SqlJetException {
        return this.getKeySize();
    }

    @Override
    public Object[] getValue() throws SqlJetException {
        return this.getValues();
    }

    @Override
    public boolean goToKey(long key) throws SqlJetException {
        if (key > 0L) {
            int moveTo = this.moveTo(null, key, false);
            if (moveTo < 0 && !this.next()) {
                return false;
            }
            return moveTo == 0 || key == this.getKeySize();
        }
        throw new SqlJetException(String.format(KEY_MUST_BE_MORE_THAN_ZERO, key));
    }

    @Override
    public long put(long key, Object ... values) throws SqlJetException {
        if (values != null) {
            SqlJetEncoding encoding = this.mapDb.getOptions().getEncoding();
            ISqlJetBtreeRecord record = SqlJetBtreeRecord.getRecord(encoding, values);
            ISqlJetMemoryPointer pData = record.getRawRecord();
            key = key > 0L ? key : this.newRowId();
            this.insert(null, key, pData, pData.remaining(), 0, true);
            return key;
        }
        if (this.goToKey(key)) {
            this.delete();
            return key;
        }
        return 0L;
    }
}

