/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.memory;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetAbstractMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetDirectByteBuffer;

public class SqlJetByteBuffer
extends SqlJetAbstractMemoryBuffer
implements ISqlJetMemoryBuffer {
    protected final ByteBuffer buffer;

    public SqlJetByteBuffer(int size) {
        this(ByteBuffer.allocate(size));
    }

    public SqlJetByteBuffer(byte[] bytes) {
        this(ByteBuffer.wrap(bytes));
    }

    public SqlJetByteBuffer(ByteBuffer b) {
        assert (b != null);
        this.buffer = b;
    }

    @Override
    public int getSize() {
        return this.buffer.capacity();
    }

    @Override
    public byte getByte(int pointer) {
        assert (pointer >= 0);
        assert (pointer < this.buffer.capacity());
        return this.buffer.get(pointer);
    }

    @Override
    public int getInt(int pointer) {
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 4);
        return this.buffer.getInt(pointer);
    }

    @Override
    public long getLong(int pointer) {
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 8);
        return this.buffer.getLong(pointer);
    }

    @Override
    public short getShort(int pointer) {
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 2);
        return this.buffer.getShort(pointer);
    }

    @Override
    public void putByte(int pointer, byte value) {
        assert (pointer >= 0);
        assert (pointer < this.buffer.capacity());
        this.buffer.put(pointer, value);
    }

    @Override
    public void putInt(int pointer, int value) {
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 4);
        this.buffer.putInt(pointer, value);
    }

    @Override
    public void putLong(int pointer, long value) {
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 8);
        this.buffer.putLong(pointer, value);
    }

    @Override
    public void putShort(int pointer, short value) {
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 2);
        this.buffer.putShort(pointer, value);
    }

    @Override
    public int readFromFile(int pointer, RandomAccessFile file, FileChannel channel, long position, int count) throws IOException {
        assert (pointer >= 0);
        assert (pointer < this.buffer.capacity());
        assert (file != null);
        assert (channel != null);
        assert (position >= 0L);
        assert (count > 0);
        this.buffer.limit(pointer + count).position(pointer);
        try {
            int n = channel.read(this.buffer, position);
            return n;
        }
        finally {
            this.buffer.clear();
        }
    }

    @Override
    public int writeToFile(int pointer, RandomAccessFile file, FileChannel channel, long position, int count) throws IOException {
        assert (pointer >= 0);
        assert (pointer < this.buffer.capacity());
        assert (file != null);
        assert (channel != null);
        assert (position >= 0L);
        assert (count > 0);
        this.buffer.limit(pointer + count).position(pointer);
        try {
            int n = channel.write(this.buffer, position);
            return n;
        }
        finally {
            this.buffer.clear();
        }
    }

    @Override
    public byte[] asArray() {
        return this.buffer.array();
    }

    @Override
    public void copyFrom(int dstPos, ISqlJetMemoryBuffer src, int srcPos, int count) {
        if (src instanceof SqlJetByteBuffer && !(src instanceof SqlJetDirectByteBuffer)) {
            SqlJetByteBuffer srcBuf = (SqlJetByteBuffer)src;
            System.arraycopy(srcBuf.buffer.array(), srcPos, this.buffer.array(), dstPos, count);
        } else {
            byte[] b = new byte[count];
            src.getBytes(srcPos, b, 0, count);
            this.putBytes(dstPos, b, 0, count);
        }
    }

    @Override
    public void fill(int from, int count, byte value) {
        Arrays.fill(this.buffer.array(), from, from + count, value);
    }

    @Override
    public void getBytes(int pointer, byte[] bytes, int to, int count) {
        System.arraycopy(this.buffer.array(), pointer, bytes, to, count);
    }

    @Override
    public void putBytes(int pointer, byte[] bytes, int from, int count) {
        System.arraycopy(bytes, from, this.buffer.array(), pointer, count);
    }

    @Override
    public int compareTo(int pointer, ISqlJetMemoryBuffer buffer, int bufferPointer) {
        int bufferCount;
        int thisCount = this.getSize() - pointer;
        if (thisCount != (bufferCount = buffer.getSize() - bufferPointer)) {
            if (thisCount > bufferCount) {
                return 1;
            }
            return -1;
        }
        if (buffer instanceof SqlJetByteBuffer && !(buffer instanceof SqlJetDirectByteBuffer)) {
            SqlJetByteBuffer b = (SqlJetByteBuffer)buffer;
            return SqlJetUtility.memcmp(this.buffer.array(), pointer, b.buffer.array(), bufferPointer, thisCount);
        }
        byte[] b = new byte[thisCount];
        buffer.getBytes(bufferPointer, b, 0, thisCount);
        return SqlJetUtility.memcmp(this.buffer.array(), pointer, b, bufferPointer, thisCount);
    }
}

