/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.memory;

public class SqlJetBytesUtility {
    private static final int BYTE_UNSIGNED_MASK = 255;
    private static final long BYTE_UNSIGNED_MASK_L = 255L;
    private static final int SHORT_UNSIGNED_MASK = 65535;
    private static final long INT_UNSIGNED_MASK = 0xFFFFFFFFL;

    public static int toUnsignedByte(int value) {
        return 0xFF & value;
    }

    public static int toUnsignedShort(int value) {
        return 0xFFFF & value;
    }

    public static long toUnsignedInt(long value) {
        return 0xFFFFFFFFL & value;
    }

    static short getShort(byte[] b, int off) {
        return (short)(b[off + 1] & 0xFF | (b[off] & 0xFF) << 8);
    }

    static int getInt(byte[] b, int off) {
        return b[off + 3] & 0xFF | (b[off + 2] & 0xFF) << 8 | (b[off + 1] & 0xFF) << 16 | (b[off] & 0xFF) << 24;
    }

    static long getLong(byte[] b, int off) {
        return (long)b[off + 7] & 0xFFL | ((long)b[off + 6] & 0xFFL) << 8 | (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) | ((long)b[off + 3] & 0xFFL) << 32 | (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) | ((long)b[off] & 0xFFL) << 56;
    }

    static void putShort(byte[] b, int off, short val) {
        b[off + 1] = (byte)val;
        b[off] = (byte)(val >>> 8);
    }

    static void putInt(byte[] b, int off, int val) {
        b[off + 3] = (byte)val;
        b[off + 2] = (byte)(val >>> 8);
        b[off + 1] = (byte)(val >>> 16);
        b[off] = (byte)(val >>> 24);
    }

    static void putLong(byte[] b, int off, long val) {
        b[off + 7] = (byte)val;
        b[off + 6] = (byte)(val >>> 8);
        b[off + 5] = (byte)(val >>> 16);
        b[off + 4] = (byte)(val >>> 24);
        b[off + 3] = (byte)(val >>> 32);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 1] = (byte)(val >>> 48);
        b[off] = (byte)(val >>> 56);
    }
}

