/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.pager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetPageCache;
import org.tmatesoft.sqljet.core.internal.ISqlJetPageCallback;
import org.tmatesoft.sqljet.core.internal.SqlJetPageFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPage;

public class SqlJetPageCache
implements ISqlJetPageCache {
    private static final String SQLJET_PAGE_CACHE_SIZE = "SQLJET.PAGE_CACHE_SIZE";
    public static final int PAGE_CACHE_SIZE_DEFAULT = 2000;
    private static final int PAGE_CACHE_SIZE = SqlJetUtility.getIntSysProp("SQLJET.PAGE_CACHE_SIZE", 2000);
    public static final int PAGE_CACHE_SIZE_MINIMUM = 10;
    protected final List<ISqlJetPage> dirtyList = new LinkedList<ISqlJetPage>();
    protected int nRef;
    private int nMax = 2000;
    private int szPage;
    final boolean bPurgeable;
    private final ISqlJetPageCallback xStress;
    final PCache pCache = new PCache();

    public SqlJetPageCache(int szPage, boolean purgeable, ISqlJetPageCallback stress) {
        if (PAGE_CACHE_SIZE >= 10) {
            this.nMax = PAGE_CACHE_SIZE;
        }
        this.szPage = szPage;
        this.bPurgeable = purgeable;
        this.xStress = stress;
    }

    @Override
    public void setPageSize(int pageSize) {
        assert (this.nRef == 0 && this.dirtyList.isEmpty());
        this.pCache.clear();
        this.szPage = pageSize;
    }

    @Override
    public ISqlJetPage fetch(int pgno, boolean createFlag) throws SqlJetException {
        SqlJetPage pPage = null;
        assert (pgno > 0);
        pPage = this.pCache.fetch(pgno, createFlag);
        if (pPage == null && createFlag) {
            ISqlJetPage pPg = null;
            for (ISqlJetPage p : this.dirtyList) {
                if (p.getRefCount() != 0) continue;
                pPg = p;
                if (!p.getFlags().contains((Object)SqlJetPageFlags.NEED_SYNC)) break;
            }
            if (pPg != null) {
                this.xStress.pageCallback(pPg);
            }
            this.pCache.cleanUnpinned();
            pPage = this.pCache.fetch(pgno, true);
        }
        if (pPage != null) {
            if (pPage.nRef == 0) {
                ++this.nRef;
            }
            ++pPage.nRef;
        }
        return pPage;
    }

    @Override
    public void drop(ISqlJetPage p) {
        assert (p.getRefCount() >= 1);
        if (p.getFlags().contains((Object)SqlJetPageFlags.DIRTY)) {
            p.removeFromDirtyList();
        }
        --this.nRef;
        this.pCache.unpin(p, true);
    }

    @Override
    public void cleanAll() {
        while (!this.dirtyList.isEmpty()) {
            this.dirtyList.iterator().next().makeClean();
        }
    }

    @Override
    public void clearSyncFlags() {
        for (ISqlJetPage p : this.dirtyList) {
            p.getFlags().remove((Object)SqlJetPageFlags.NEED_SYNC);
        }
    }

    @Override
    public void truncate(int pgno) {
        for (ISqlJetPage p : new ArrayList<ISqlJetPage>(this.dirtyList)) {
            if (p.getPageNumber() <= pgno) continue;
            assert (p.getFlags().contains((Object)SqlJetPageFlags.DIRTY));
            p.makeClean();
        }
        this.pCache.truncate(pgno + 1);
    }

    @Override
    public void close() {
        this.pCache.clear();
    }

    @Override
    public void clear() {
        this.truncate(0);
    }

    @Override
    public List<ISqlJetPage> getDirtyList() {
        ArrayList<ISqlJetPage> result = new ArrayList<ISqlJetPage>(this.dirtyList);
        result.sort((a, b) -> Integer.compare(a.getPageNumber(), b.getPageNumber()));
        return result;
    }

    @Override
    public int getRefCount() {
        return this.nRef;
    }

    @Override
    public int getPageCount() {
        return this.pCache.getPageCount();
    }

    @Override
    public int getCachesize() {
        return this.nMax;
    }

    @Override
    public void setCacheSize(int mxPage) {
        this.nMax = mxPage;
    }

    @Override
    public void iterate(ISqlJetPageCallback iter) throws SqlJetException {
        for (ISqlJetPage p : this.dirtyList) {
            iter.pageCallback(p);
        }
    }

    class PCache {
        private final Map<Integer, SqlJetPage> apHash = new HashMap<Integer, SqlJetPage>();
        private final Set<Integer> unpinned = new HashSet<Integer>();

        PCache() {
        }

        public synchronized int getPageCount() {
            return this.apHash.size();
        }

        public synchronized SqlJetPage fetch(int key, boolean createFlag) {
            Integer keyObj = key;
            SqlJetPage pPage = this.apHash.get(keyObj);
            if (pPage != null || !createFlag) {
                return pPage;
            }
            if (SqlJetPageCache.this.bPurgeable && this.getPageCount() == SqlJetPageCache.this.nMax) {
                return null;
            }
            pPage = new SqlJetPage(SqlJetPageCache.this.szPage, key);
            pPage.pCache = SqlJetPageCache.this;
            this.apHash.put(keyObj, pPage);
            return pPage;
        }

        public synchronized void unpin(ISqlJetPage page, boolean discard) {
            Integer pageNumber = page.getPageNumber();
            if (discard || SqlJetPageCache.this.bPurgeable && this.getPageCount() == SqlJetPageCache.this.nMax) {
                this.apHash.remove(pageNumber);
            } else {
                this.unpinned.add(pageNumber);
            }
        }

        public synchronized void rekey(SqlJetPage page, int newKey) {
            this.apHash.remove(page.getPageNumber());
            this.apHash.put(newKey, page);
            page.setPageNumber(newKey);
        }

        public synchronized void truncate(int iLimit) {
            ArrayList<Integer> l = new ArrayList<Integer>();
            for (Integer i : this.apHash.keySet()) {
                if (i < iLimit) continue;
                l.add(i);
            }
            for (Integer i : l) {
                this.apHash.remove(i);
                this.unpinned.remove(i);
            }
        }

        public synchronized void clear() {
            this.apHash.clear();
            this.unpinned.clear();
        }

        public void cleanUnpinned() {
            Iterator<Integer> i = this.unpinned.iterator();
            while (i.hasNext()) {
                Integer next = i.next();
                SqlJetPage p = this.apHash.get(next);
                if (p == null || p.getRefCount() > 0) {
                    i.remove();
                    continue;
                }
                Set<SqlJetPageFlags> flags = p.getFlags();
                if (flags.contains((Object)SqlJetPageFlags.DIRTY) || flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) continue;
                this.apHash.remove(next);
                i.remove();
                return;
            }
        }
    }
}

