/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnCheck;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnCollate;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDefault;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnForeignKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnNotNull;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnNull;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnUnique;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTypeDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTypeDef;
import org.tmatesoft.sqljet.core.schema.SqlJetTypeAffinity;

public class SqlJetColumnDef
implements ISqlJetColumnDef {
    private final String name;
    private final String quotedName;
    private final ISqlJetTypeDef type;
    private final List<ISqlJetColumnConstraint> constraints;
    private int index;

    public SqlJetColumnDef(CommonTree ast) throws SqlJetException {
        this.name = ast.getText();
        this.quotedName = SqlParser.quotedId(ast);
        CommonTree constraintsNode = (CommonTree)ast.getChild(0);
        assert ("constraints".equalsIgnoreCase(constraintsNode.getText()));
        ArrayList<ISqlJetColumnConstraint> constraints = new ArrayList<ISqlJetColumnConstraint>();
        int i = 0;
        while (i < constraintsNode.getChildCount()) {
            String constraintName;
            CommonTree constraintRootNode = (CommonTree)constraintsNode.getChild(i);
            assert ("column_constraint".equalsIgnoreCase(constraintRootNode.getText()));
            CommonTree constraintNode = (CommonTree)constraintRootNode.getChild(0);
            String constraintType = constraintNode.getText();
            String string = constraintName = constraintRootNode.getChildCount() > 1 ? constraintRootNode.getChild(1).getText() : null;
            if ("primary".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnPrimaryKey(this, constraintName, constraintNode));
            } else if ("not_null".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnNotNull(this, constraintName, constraintNode));
            } else if ("unique".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnUnique(this, constraintName, constraintNode));
            } else if ("check".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnCheck(this, constraintName, constraintNode));
            } else if ("default".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnDefault(this, constraintName, constraintNode));
            } else if ("collate".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnCollate(this, constraintName, constraintNode));
            } else if ("references".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnForeignKey(constraintName, constraintNode));
            } else if ("is_null".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnNull(this, constraintName, constraintNode));
            } else assert (false);
            ++i;
        }
        this.constraints = Collections.unmodifiableList(constraints);
        if (ast.getChildCount() > 1) {
            CommonTree typeNode = (CommonTree)ast.getChild(1);
            assert ("type".equalsIgnoreCase(typeNode.getText()));
            this.type = new SqlJetTypeDef(typeNode);
        } else {
            this.type = null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuotedName() {
        return this.quotedName;
    }

    @Override
    public ISqlJetTypeDef getType() {
        return this.type;
    }

    @Override
    public SqlJetTypeAffinity getTypeAffinity() {
        ISqlJetTypeDef type = this.getType();
        if (type == null) {
            return SqlJetTypeAffinity.NONE;
        }
        String typeNames = type.getNames().stream().reduce((a, b) -> String.valueOf(a) + ' ' + b).orElse("");
        return SqlJetTypeAffinity.decode(typeNames);
    }

    @Override
    public boolean hasExactlyIntegerType() {
        if (this.getTypeAffinity() != SqlJetTypeAffinity.INTEGER) {
            return false;
        }
        ISqlJetTypeDef type = this.getType();
        if (type == null || type.getNames() == null || type.getNames().isEmpty()) {
            return false;
        }
        return "INTEGER".equals(type.getNames().get(0).toUpperCase());
    }

    @Override
    public List<ISqlJetColumnConstraint> getConstraints() {
        return this.constraints;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getQuotedName());
        if (this.getType() != null) {
            buffer.append(' ').append(this.getType());
        }
        for (ISqlJetColumnConstraint c : this.getConstraints()) {
            buffer.append(' ').append(c);
        }
        return buffer.toString();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

