/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBetweenExpression;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBinaryExpression;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBindParameter;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBlobLiteral;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBoolLiteral;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetCaseExpression;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetCollateExpression;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnExpression;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetFloatLiteral;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetFunctionExpression;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetFunctionLiteral;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetInTableExpression;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetInValuesExpression;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetIntegerLiteral;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetIsNullExpression;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetMatchExpression;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetNullLiteral;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetRaiseExpression;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetStringLiteral;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetUnaryExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetBinaryExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetMatchExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetUnaryExpression;

public abstract class SqlJetExpression
implements ISqlJetExpression {
    public static ISqlJetExpression create(CommonTree ast) throws SqlJetException {
        String op = ast.getText().toLowerCase();
        if ("bind".equals(op) || "bind_name".equals(op)) {
            return new SqlJetBindParameter(ast);
        }
        if ("column_expression".equals(op)) {
            return new SqlJetColumnExpression(ast);
        }
        if ("null".equals(op)) {
            return new SqlJetNullLiteral(ast);
        }
        if ("blob_literal".equals(op)) {
            return new SqlJetBlobLiteral(ast);
        }
        if ("float_literal".equals(op)) {
            return new SqlJetFloatLiteral(ast);
        }
        if ("function_literal".equals(op)) {
            return new SqlJetFunctionLiteral(ast);
        }
        if ("integer_literal".equals(op)) {
            return new SqlJetIntegerLiteral(ast);
        }
        if ("string_literal".equals(op)) {
            return new SqlJetStringLiteral(ast);
        }
        if ("function_expression".equals(op)) {
            return new SqlJetFunctionExpression(ast);
        }
        if ("isnull".equals(op) || "notnull".equals(op)) {
            return new SqlJetIsNullExpression(ast);
        }
        if ("case".equals(op)) {
            return new SqlJetCaseExpression(ast);
        }
        if ("raise".equals(op)) {
            return new SqlJetRaiseExpression(ast);
        }
        if (ISqlJetMatchExpression.Operation.decode(ast.getText()) != null) {
            return new SqlJetMatchExpression(ast);
        }
        if ("in_values".equals(op)) {
            return new SqlJetInValuesExpression(ast);
        }
        if ("in_table".equals(op)) {
            return new SqlJetInTableExpression(ast);
        }
        if ("between".equals(op)) {
            return new SqlJetBetweenExpression(ast);
        }
        if (ISqlJetBinaryExpression.Operation.decode(ast.getText()) != null && ast.getChildCount() == 2) {
            return new SqlJetBinaryExpression(ast);
        }
        if (ISqlJetUnaryExpression.Operation.decode(ast.getText()) != null && ast.getChildCount() == 1) {
            return new SqlJetUnaryExpression(ast);
        }
        if ("collate".equals(op)) {
            return new SqlJetCollateExpression(ast);
        }
        if ("true".equals(op) || "false".equals(op)) {
            return new SqlJetBoolLiteral(ast);
        }
        throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid expression");
    }

    @Override
    public Object getValue() {
        return this.toString();
    }
}

