/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBaseIndexDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;

public class SqlJetIndexDef
extends SqlJetBaseIndexDef {
    private final String databaseName;
    private final boolean unique;
    private final boolean ifNotExists;
    private final List<ISqlJetIndexedColumn> columns;

    SqlJetIndexDef(String name, String tableName, int page, String databaseName, boolean unique, boolean ifNotExists, List<ISqlJetIndexedColumn> columns) {
        super(name, tableName, page);
        this.databaseName = databaseName;
        this.unique = unique;
        this.ifNotExists = ifNotExists;
        this.columns = Collections.unmodifiableList(columns);
    }

    public SqlJetIndexDef(CommonTree ast, int page) {
        super(null, null, page);
        CommonTree optionsNode = (CommonTree)ast.getChild(0);
        this.unique = this.hasOption(optionsNode, "unique");
        this.ifNotExists = this.hasOption(optionsNode, "exists");
        CommonTree nameNode = (CommonTree)ast.getChild(1);
        this.setName(nameNode.getText());
        this.databaseName = nameNode.getChildCount() > 0 ? nameNode.getChild(0).getText() : null;
        CommonTree tableNameNode = (CommonTree)ast.getChild(2);
        this.setTableName(tableNameNode.getText());
        ArrayList<SqlJetIndexedColumn> columns = new ArrayList<SqlJetIndexedColumn>();
        CommonTree defNode = (CommonTree)ast.getChild(3);
        int i = 0;
        while (i < defNode.getChildCount()) {
            columns.add(new SqlJetIndexedColumn((CommonTree)defNode.getChild(i)));
            ++i;
        }
        this.columns = Collections.unmodifiableList(columns);
    }

    private boolean hasOption(CommonTree optionsNode, String name) {
        int i = 0;
        while (i < optionsNode.getChildCount()) {
            CommonTree optionNode = (CommonTree)optionsNode.getChild(i);
            if (name.equalsIgnoreCase(optionNode.getText())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    public boolean isKeepExisting() {
        return this.ifNotExists;
    }

    @Override
    public List<ISqlJetIndexedColumn> getColumns() {
        return this.columns;
    }

    @Override
    public ISqlJetIndexedColumn getColumn(String name) {
        for (ISqlJetIndexedColumn column : this.getColumns()) {
            if (!column.getName().equalsIgnoreCase(name)) continue;
            return column;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getPage());
        buffer.append("/");
        buffer.append(this.getRowId());
        buffer.append(": ");
        buffer.append(this.toSQL());
        return buffer.toString();
    }

    @Override
    public String toSQL() {
        return this.toSQL(true);
    }

    public String toSQL(boolean schemaStrict) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CREATE ");
        if (this.isUnique()) {
            buffer.append("UNIQUE ");
        }
        buffer.append("INDEX ");
        if (!schemaStrict) {
            if (this.isKeepExisting()) {
                buffer.append("IF NOT EXISTS ");
            }
            if (this.getDatabaseName() != null) {
                buffer.append(this.getDatabaseName());
                buffer.append('.');
            }
        }
        buffer.append(this.getName());
        buffer.append(" ON ");
        buffer.append(this.getTableName());
        buffer.append(" (");
        List<ISqlJetIndexedColumn> columns = this.getColumns();
        int i = 0;
        while (i < columns.size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(columns.get(i).toString());
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    public void bindColumns(ISqlJetTableDef tableDef) {
        for (ISqlJetColumnDef tableColumn : tableDef.getColumns()) {
            for (ISqlJetIndexedColumn column : this.columns) {
                if (!column.getName().equalsIgnoreCase(tableColumn.getName())) continue;
                ((SqlJetIndexedColumn)column).setTableColumn(tableColumn);
            }
        }
    }
}

