/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetExpression;

public class SqlJetRaiseExpression
extends SqlJetExpression
implements ISqlJetExpression {
    private final Action action;
    private final String errorMessage;

    public SqlJetRaiseExpression(CommonTree ast) {
        assert ("raise".equalsIgnoreCase(ast.getText()));
        this.action = Action.decode(ast.getChild(0).getText());
        this.errorMessage = ast.getChildCount() > 1 ? ast.getChild(1).getText() : null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("RAISE (");
        buffer.append((Object)this.action);
        if (this.errorMessage != null) {
            buffer.append(' ');
            buffer.append(this.errorMessage);
        }
        buffer.append(')');
        return buffer.toString();
    }

    public static enum Action {
        IGNORE,
        ROLLBACK,
        ABORT,
        FAIL;


        public static Action decode(String s) {
            if ("ignore".equalsIgnoreCase(s)) {
                return IGNORE;
            }
            if ("rollback".equalsIgnoreCase(s)) {
                return ROLLBACK;
            }
            if ("abort".equalsIgnoreCase(s)) {
                return ABORT;
            }
            if ("fail".equalsIgnoreCase(s)) {
                return FAIL;
            }
            return null;
        }
    }
}

