/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableConstraint;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;

public abstract class SqlJetTableIndexConstraint
extends SqlJetTableConstraint {
    private final List<String> columns;
    private final SqlJetConflictAction conflictAction;
    private String indexName;

    public SqlJetTableIndexConstraint(String name, CommonTree ast) {
        super(name);
        CommonTree columnsNode = (CommonTree)ast.getChild(0);
        assert ("columns".equalsIgnoreCase(columnsNode.getText()));
        ArrayList<String> columns = new ArrayList<String>();
        int i = 0;
        while (i < columnsNode.getChildCount()) {
            CommonTree child = (CommonTree)columnsNode.getChild(i);
            columns.add(child.getText());
            ++i;
        }
        this.columns = Collections.unmodifiableList(columns);
        if (ast.getChildCount() > 1) {
            CommonTree child = (CommonTree)ast.getChild(1);
            assert ("conflict".equalsIgnoreCase(child.getText()));
            assert (child.getChildCount() == 1);
            child = (CommonTree)child.getChild(0);
            this.conflictAction = SqlJetConflictAction.decode(child.getText());
        } else {
            this.conflictAction = null;
        }
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public SqlJetConflictAction getConflictAction() {
        return this.conflictAction;
    }

    protected abstract String getConstraintName();

    public String getIndexName() {
        return this.indexName;
    }

    void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        if (buffer.length() > 0) {
            buffer.append(' ');
        }
        buffer.append(this.getConstraintName());
        buffer.append(" (");
        int i = 0;
        while (i < this.getColumns().size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getColumns().get(i));
            ++i;
        }
        buffer.append(')');
        if (this.conflictAction != null) {
            buffer.append(" ON CONFLICT ");
            buffer.append((Object)this.conflictAction);
        }
        return buffer.toString();
    }
}

