/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetViewDef;

public class SqlJetViewDef
implements ISqlJetViewDef {
    private final String name;
    private final boolean ifNotExists;
    private final String sqlStatement;
    private final long rowId;

    private SqlJetViewDef(String name, boolean ifNotExists, String sqlStatement, long rowId) {
        this.name = name;
        this.ifNotExists = ifNotExists;
        this.sqlStatement = sqlStatement;
        this.rowId = rowId;
    }

    public SqlJetViewDef(String sql, CommonTree ast) {
        CommonTree optionsNode = (CommonTree)ast.getChild(0);
        this.sqlStatement = sql;
        this.ifNotExists = SqlJetTableDef.hasOption(optionsNode, "exists");
        CommonTree nameNode = (CommonTree)ast.getChild(1);
        this.name = nameNode.getText();
        this.rowId = 0L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isKeepExisting() {
        return this.ifNotExists;
    }

    @Override
    public String toSQL() {
        return this.sqlStatement;
    }

    public String toString() {
        return this.toSQL();
    }

    @Override
    public long getRowId() {
        return this.rowId;
    }

    public ISqlJetViewDef withRowId(long rowId) {
        return new SqlJetViewDef(this.name, this.ifNotExists, this.sqlStatement, rowId);
    }
}

