/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetAssert;
import org.tmatesoft.sqljet.core.internal.SqlJetUnpackedRecordFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBaseIndexDef;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetKeyInfo;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetUnpackedRecord;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.SqlJetSortingOrder;

public class SqlJetBtreeIndexTable
extends SqlJetBtreeTable
implements ISqlJetBtreeIndexTable {
    private final ISqlJetIndexDef indexDef;
    private final int columns;

    public SqlJetBtreeIndexTable(ISqlJetBtree btree, String indexName, boolean write) throws SqlJetException {
        super(btree, ((SqlJetBaseIndexDef)btree.getSchema().getIndex(indexName)).getPage(), write, true);
        this.indexDef = btree.getSchema().getIndex(indexName);
        this.columns = -1;
        this.adjustKeyInfo();
    }

    public SqlJetBtreeIndexTable(ISqlJetBtree btree, String indexName, int columns, boolean write) throws SqlJetException {
        super(btree, ((SqlJetBaseIndexDef)btree.getSchema().getIndex(indexName)).getPage(), write, true);
        this.indexDef = btree.getSchema().getIndex(indexName);
        this.columns = columns;
        this.adjustKeyInfo();
    }

    public ISqlJetIndexDef getIndexDef() {
        return this.indexDef;
    }

    @Override
    public long lookup(Object ... values) throws SqlJetException {
        return this.lookupSafe(false, false, values);
    }

    private long lookupSafe(boolean near, boolean last, Object ... values) throws SqlJetException {
        ISqlJetBtreeRecord record;
        SqlJetEncoding encoding = this.btree.getDb().getOptions().getEncoding();
        ISqlJetBtreeRecord key = SqlJetBtreeRecord.getRecord(encoding, values);
        ISqlJetMemoryPointer k = key.getRawRecord();
        int moved = this.cursorMoveTo(k, last);
        if (moved != 0) {
            if (!last) {
                if (moved < 0) {
                    this.next();
                }
            } else if (moved > 0) {
                this.previous();
            }
        }
        if ((record = this.getRecord()) == null) {
            return 0L;
        }
        if (!near && this.keyCompare(k, record.getRawRecord()) != 0) {
            return 0L;
        }
        return this.getKeyRowId(record);
    }

    private int cursorMoveTo(ISqlJetMemoryPointer pKey, boolean last) throws SqlJetException {
        this.clearRecordCache();
        int nKey = pKey.remaining();
        if (!last) {
            return this.getCursor().moveTo(pKey, nKey, false);
        }
        assert ((long)nKey == (long)nKey);
        SqlJetUnpackedRecord pIdxKey = this.getKeyInfo().recordUnpack(nKey, pKey);
        pIdxKey.getFlags().add(SqlJetUnpackedRecordFlags.INCRKEY);
        return this.getCursor().moveToUnpacked(pIdxKey, nKey, false);
    }

    private int keyCompare(ISqlJetMemoryPointer key, ISqlJetMemoryPointer record) throws SqlJetException {
        SqlJetUnpackedRecord unpacked = this.getKeyInfo().recordUnpack(key.remaining(), key);
        Set<SqlJetUnpackedRecordFlags> flags = unpacked.getFlags();
        flags.add(SqlJetUnpackedRecordFlags.IGNORE_ROWID);
        flags.add(SqlJetUnpackedRecordFlags.PREFIX_MATCH);
        return unpacked.recordCompare(record.remaining(), record);
    }

    @Override
    public int compareKeys(Object[] firstKey, Object[] lastKey) throws SqlJetException {
        SqlJetEncoding encoding = this.btree.getDb().getOptions().getEncoding();
        ISqlJetBtreeRecord first = SqlJetBtreeRecord.getRecord(encoding, firstKey);
        ISqlJetBtreeRecord last = SqlJetBtreeRecord.getRecord(encoding, lastKey);
        ISqlJetMemoryPointer firstRec = first.getRawRecord();
        ISqlJetMemoryPointer lastRec = last.getRawRecord();
        SqlJetUnpackedRecord unpacked = this.getKeyInfo().recordUnpack(firstRec.remaining(), firstRec);
        unpacked.getFlags().add(SqlJetUnpackedRecordFlags.PREFIX_MATCH);
        return unpacked.recordCompare(lastRec.remaining(), lastRec);
    }

    @Override
    protected void adjustKeyInfo() throws SqlJetException {
        SqlJetKeyInfo keyInfo = this.getKeyInfo();
        SqlJetAssert.assertNotNull(keyInfo, SqlJetErrorCode.INTERNAL);
        if (this.indexDef != null) {
            if (this.columns >= 0) {
                keyInfo.setNField(this.columns);
            } else if (this.indexDef.getColumns() != null) {
                keyInfo.setNField(this.indexDef.getColumns().size());
                int i = 0;
                for (ISqlJetIndexedColumn column : this.indexDef.getColumns()) {
                    keyInfo.setSortOrder(i++, column.getSortingOrder() == SqlJetSortingOrder.DESC);
                }
            }
        }
    }

    @Override
    public void insert(long rowId, boolean append, Object ... key) throws SqlJetException {
        ISqlJetBtreeRecord rec = SqlJetBtreeRecord.getRecord(this.btree.getDb().getOptions().getEncoding(), SqlJetUtility.addValueToArray(key, rowId));
        ISqlJetMemoryPointer zKey = rec.getRawRecord();
        this.getCursor().insert(zKey, zKey.remaining(), SqlJetUtility.memoryManager.allocatePtr(0), 0, 0, append);
        this.clearRecordCache();
    }

    @Override
    public boolean delete(long rowId, Object ... key) throws SqlJetException {
        ISqlJetBtreeRecord rec = SqlJetBtreeRecord.getRecord(this.btree.getDb().getOptions().getEncoding(), key);
        ISqlJetMemoryPointer k = rec.getRawRecord();
        if (this.cursorMoveTo(k, false) < 0) {
            this.next();
        }
        do {
            ISqlJetBtreeRecord record;
            if ((record = this.getRecord()) == null) {
                return false;
            }
            if (this.keyCompare(k, record.getRawRecord()) != 0) {
                return false;
            }
            if (this.getKeyRowId(record) != rowId) continue;
            this.getCursor().delete();
            this.clearRecordCache();
            if (this.cursorMoveTo(k, false) < 0) {
                this.next();
            }
            return true;
        } while (this.next());
        return false;
    }

    private long getKeyRowId(ISqlJetBtreeRecord record) {
        if (record == null) {
            return 0L;
        }
        ISqlJetVdbeMem lastRawField = record.getLastRawField();
        return lastRawField == null ? 0L : lastRawField.intValue();
    }

    @Override
    public long getKeyRowId() throws SqlJetException {
        return this.getKeyRowId(this.getRecord());
    }

    public void reindex() throws SqlJetException {
        this.btree.clearTable(this.rootPage, null);
        try (SqlJetBtreeDataTable dataTable = new SqlJetBtreeDataTable(this.btree, this.indexDef.getTableName(), false);){
            dataTable.first();
            while (!dataTable.eof()) {
                Object[] key = dataTable.getKeyForIndex(dataTable.getValues(), this.indexDef);
                this.insert(dataTable.getRowId(), true, key);
                dataTable.next();
            }
        }
    }

    @Override
    public int compareKey(Object[] key) throws SqlJetException {
        if (this.eof()) {
            return 1;
        }
        ISqlJetBtreeRecord rec = SqlJetBtreeRecord.getRecord(this.btree.getDb().getOptions().getEncoding(), key);
        ISqlJetMemoryPointer keyRecord = rec.getRawRecord();
        return this.keyCompare(keyRecord, this.getRecord().getRawRecord());
    }

    @Override
    public long lookupNear(Object[] key) throws SqlJetException {
        return this.lookupSafe(true, false, key);
    }

    @Override
    public long lookupLastNear(Object[] key) throws SqlJetException {
        return this.lookupSafe(true, true, key);
    }
}

