/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetReverseOrderCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public abstract class SqlJetCursor
implements ISqlJetCursor {
    protected final ISqlJetBtreeTable btreeTable;
    protected final SqlJetDb db;

    protected SqlJetCursor(ISqlJetBtreeTable table, SqlJetDb db) throws SqlJetException {
        if (!db.isInTransaction()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Cursor requires active transaction");
        }
        this.btreeTable = table;
        this.db = db;
    }

    @Override
    public void close() throws SqlJetException {
        this.db.read().asVoid(db -> this.btreeTable.close());
    }

    @Override
    public boolean eof() throws SqlJetException {
        return this.db.read().asBool(db -> this.btreeTable.eof());
    }

    @Override
    public boolean first() throws SqlJetException {
        return this.db.read().asBool(db -> this.btreeTable.first());
    }

    @Override
    public boolean last() throws SqlJetException {
        return this.db.read().asBool(db -> this.btreeTable.last());
    }

    @Override
    public boolean next() throws SqlJetException {
        return this.db.read().asBool(db -> this.btreeTable.next());
    }

    @Override
    public boolean previous() throws SqlJetException {
        return this.db.read().asBool(db -> this.btreeTable.previous());
    }

    @Override
    public int getFieldsCount() throws SqlJetException {
        return this.db.read().asInt(db -> this.btreeTable.getFieldsCount());
    }

    @Override
    public SqlJetValueType getFieldType(int field) throws SqlJetException {
        return this.db.read().as(db -> this.btreeTable.getFieldType(field));
    }

    @Override
    public boolean isNull(int field) throws SqlJetException {
        return this.db.read().asBool(db -> this.btreeTable.isNull(field));
    }

    @Override
    public String getString(int field) throws SqlJetException {
        return this.db.read().as(db -> this.btreeTable.getString(field));
    }

    @Override
    public long getInteger(int field) throws SqlJetException {
        return this.db.read().asLong(db -> this.btreeTable.getInteger(field));
    }

    @Override
    public double getFloat(int field) throws SqlJetException {
        return this.db.read().asDouble(db -> this.btreeTable.getFloat(field));
    }

    @Override
    public Optional<byte[]> getBlobAsArray(int field) throws SqlJetException {
        return this.db.read().as(db -> this.btreeTable.getBlob(field).map(ISqlJetMemoryPointer::getBytes));
    }

    @Override
    public Optional<InputStream> getBlobAsStream(int field) throws SqlJetException {
        return this.db.read().as(db -> this.btreeTable.getBlob(field).map(buffer -> new ByteArrayInputStream(buffer.getBytes())));
    }

    @Override
    public Object getValue(int field) throws SqlJetException {
        return this.db.read().as(db -> {
            Object value = this.btreeTable.getValue(field);
            if (value instanceof ISqlJetMemoryPointer) {
                return new ByteArrayInputStream(((ISqlJetMemoryPointer)value).getBytes());
            }
            return value;
        });
    }

    @Override
    public boolean getBoolean(int field) throws SqlJetException {
        return this.db.read().asBool(db -> this.btreeTable.getInteger(field) != 0L);
    }

    @Override
    public ISqlJetCursor reverse() throws SqlJetException {
        return new SqlJetReverseOrderCursor(this);
    }
}

