/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTableDataCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public class SqlJetIndexOrderCursor
extends SqlJetTableDataCursor
implements ISqlJetCursor {
    protected final ISqlJetBtreeIndexTable indexTable;

    public SqlJetIndexOrderCursor(ISqlJetBtreeDataTable table, SqlJetDb db, String indexName) throws SqlJetException {
        super(table, db);
        String newIndexName = indexName != null ? indexName : table.getPrimaryKeyIndex();
        this.indexTable = newIndexName != null ? table.getIndexesTables().get(newIndexName) : null;
        this.first();
    }

    @Override
    public boolean first() throws SqlJetException {
        return this.db.read().asBool(db -> {
            if (this.indexTable == null) {
                return SqlJetIndexOrderCursor.super.first();
            }
            if (this.indexTable.first()) {
                return this.firstRowNum(this.goTo(this.indexTable.getKeyRowId()));
            }
            return false;
        });
    }

    @Override
    public boolean next() throws SqlJetException {
        return this.db.read().asBool(db -> {
            if (this.indexTable == null) {
                return SqlJetIndexOrderCursor.super.next();
            }
            if (this.indexTable.next()) {
                return this.nextRowNum(this.goTo(this.indexTable.getKeyRowId()));
            }
            return false;
        });
    }

    @Override
    public boolean eof() throws SqlJetException {
        return this.db.read().asBool(db -> {
            if (this.indexTable == null) {
                return SqlJetIndexOrderCursor.super.eof();
            }
            return this.indexTable.eof();
        });
    }

    @Override
    public boolean last() throws SqlJetException {
        return this.db.read().asBool(db -> {
            if (this.indexTable == null) {
                return SqlJetIndexOrderCursor.super.last();
            }
            if (this.indexTable.last()) {
                return this.lastRowNum(this.goTo(this.indexTable.getKeyRowId()));
            }
            return false;
        });
    }

    @Override
    public boolean previous() throws SqlJetException {
        return this.db.read().asBool(db -> {
            if (this.indexTable == null) {
                return SqlJetIndexOrderCursor.super.previous();
            }
            if (this.indexTable.previous()) {
                return this.previousRowNum(this.goTo(this.indexTable.getKeyRowId()));
            }
            return false;
        });
    }

    @Override
    public void delete() throws SqlJetException {
        if (this.indexTable != null) {
            this.goTo(this.indexTable.getKeyRowId());
        }
        super.delete();
        if (this.indexTable != null) {
            this.goTo(this.indexTable.getKeyRowId());
        }
    }

    @Override
    protected void computeRows(boolean current) throws SqlJetException {
        if (this.indexTable != null) {
            this.db.read().asVoid(db -> this.indexTable.pushState());
        }
        try {
            super.computeRows(current);
        }
        catch (Throwable throwable) {
            if (this.indexTable != null) {
                this.db.read().asVoid(db -> {
                    boolean bl = this.indexTable.popState();
                });
            }
            throw throwable;
        }
        if (this.indexTable != null) {
            this.db.read().asVoid(db -> {
                boolean bl = this.indexTable.popState();
            });
        }
    }
}

