/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetIndexOrderCursor;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.sqljet.core.table.SqlJetScope;

public class SqlJetIndexScopeCursor
extends SqlJetIndexOrderCursor {
    private final Object[] firstKey;
    private final Object[] lastKey;
    private final long firstRowId;
    private final long lastRowId;
    private final boolean firstKeyIncluded;
    private final boolean lastKeyIncluded;

    public SqlJetIndexScopeCursor(ISqlJetBtreeDataTable table, SqlJetDb db, String indexName, Object[] firstKey, Object[] lastKey) throws SqlJetException {
        this(table, db, indexName, new SqlJetScope(firstKey, lastKey));
    }

    public SqlJetIndexScopeCursor(ISqlJetBtreeDataTable table, SqlJetDb db, String indexName, SqlJetScope scope) throws SqlJetException {
        super(table, db, indexName);
        this.firstKey = SqlJetUtility.copyArray(scope.getLeftBound().getValue());
        this.firstKeyIncluded = scope.getLeftBound().isInclusive();
        this.lastKey = SqlJetUtility.copyArray(scope.getRightBound().getValue());
        this.lastKeyIncluded = scope.getRightBound().isInclusive();
        long firstRowId = 0L;
        long lastRowId = 0L;
        if (this.indexTable == null) {
            firstRowId = this.getRowIdFromKey(this.firstKey);
            lastRowId = this.getRowIdFromKey(this.lastKey);
            if (!this.firstKeyIncluded && firstRowId > 0L) {
                ++firstRowId;
            }
            if (!this.lastKeyIncluded && lastRowId > 0L) {
                --lastRowId;
            }
        }
        this.firstRowId = firstRowId;
        this.lastRowId = lastRowId;
        this.first();
    }

    @Override
    public boolean goTo(long rowId) throws SqlJetException {
        return this.db.read().asBool(db -> {
            SqlJetIndexScopeCursor.super.goTo(rowId);
            return !this.eof();
        });
    }

    @Override
    public boolean first() throws SqlJetException {
        return this.db.read().asBool(this::firstSafe);
    }

    private boolean firstSafe(SqlJetDb db) throws SqlJetException {
        if (this.firstKey == null) {
            return SqlJetIndexScopeCursor.super.first();
        }
        if (this.indexTable == null) {
            if (this.firstRowId == 0L) {
                return SqlJetIndexScopeCursor.super.first();
            }
            return this.firstRowNum(this.goTo(this.firstRowId));
        }
        long lookup = this.indexTable.lookupNear(this.firstKey);
        if (!this.firstKeyIncluded && lookup != 0L) {
            while (this.indexTable.compareKey(this.firstKey) == 0) {
                if (this.indexTable.next()) {
                    lookup = this.indexTable.getKeyRowId();
                    continue;
                }
                lookup = 0L;
                break;
            }
        }
        if (lookup != 0L) {
            return this.firstRowNum(this.goTo(lookup));
        }
        return false;
    }

    @Override
    public boolean next() throws SqlJetException {
        return this.db.read().asBool(this::nextSafe);
    }

    private boolean nextSafe(SqlJetDb db) throws SqlJetException {
        if (this.lastKey == null) {
            return SqlJetIndexScopeCursor.super.next();
        }
        if (this.indexTable == null) {
            SqlJetIndexScopeCursor.super.next();
            return !this.eof();
        }
        if (this.indexTable.next() && !this.eof()) {
            return this.nextRowNum(this.goTo(this.indexTable.getKeyRowId()));
        }
        return false;
    }

    @Override
    public boolean previous() throws SqlJetException {
        return this.db.read().asBool(this::previousSafe);
    }

    private boolean previousSafe(SqlJetDb db) throws SqlJetException {
        if (this.firstKey == null) {
            return SqlJetIndexScopeCursor.super.previous();
        }
        if (this.indexTable == null) {
            SqlJetIndexScopeCursor.super.previous();
            return !this.eof();
        }
        if (this.indexTable.previous() && !this.eof()) {
            return this.previousRowNum(this.goTo(this.indexTable.getKeyRowId()));
        }
        return false;
    }

    @Override
    public boolean eof() throws SqlJetException {
        return this.db.read().asBool(db -> SqlJetIndexScopeCursor.super.eof() || !this.checkScope());
    }

    private boolean checkScope() throws SqlJetException {
        if (this.indexTable == null) {
            if (this.getBtreeDataTable().eof()) {
                return false;
            }
            long rowId = this.getRowId();
            if (this.firstRowId != 0L && this.firstRowId > rowId) {
                return false;
            }
            if (this.lastRowId != 0L && this.lastRowId < rowId) {
                return false;
            }
        } else {
            int compareResult;
            if (this.firstKey != null) {
                compareResult = this.indexTable.compareKey(this.firstKey);
                if (compareResult < 0) {
                    return false;
                }
                if (!this.firstKeyIncluded && compareResult == 0) {
                    return false;
                }
            }
            if (this.lastKey != null) {
                compareResult = this.indexTable.compareKey(this.lastKey);
                if (compareResult > 0) {
                    return false;
                }
                if (!this.lastKeyIncluded && compareResult == 0) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean last() throws SqlJetException {
        return this.db.read().asBool(db -> {
            if (this.lastKey == null) {
                return SqlJetIndexScopeCursor.super.last();
            }
            if (this.indexTable == null) {
                if (this.lastRowId == 0L) {
                    return SqlJetIndexScopeCursor.super.last();
                }
                return this.lastRowNum(this.goTo(this.lastRowId));
            }
            long lookup = this.indexTable.lookupLastNear(this.lastKey);
            if (lookup != 0L && !this.lastKeyIncluded) {
                while (this.indexTable.compareKey(this.lastKey) == 0) {
                    if (this.indexTable.previous()) {
                        lookup = this.indexTable.getKeyRowId();
                        continue;
                    }
                    lookup = 0L;
                    break;
                }
            }
            if (lookup != 0L) {
                return this.lastRowNum(this.goTo(lookup));
            }
            return false;
        });
    }

    private long getRowIdFromKey(Object[] key) {
        if (key != null && key.length > 0 && key[0] instanceof Long) {
            return (Long)key[0];
        }
        return 0L;
    }

    @Override
    public void delete() throws SqlJetException {
        this.db.runSynchronized(db -> {
            SqlJetIndexScopeCursor.super.delete();
            return null;
        });
        this.db.read().asVoid(db -> {
            if (!this.checkScope()) {
                this.next();
            }
        });
    }

    @Override
    public long getRowId() throws SqlJetException {
        return this.db.runSynchronized(db -> {
            if (this.indexTable != null && !this.indexTable.eof()) {
                return this.indexTable.getKeyRowId();
            }
            return SqlJetIndexScopeCursor.super.getRowId();
        });
    }
}

