/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetIndexOrderCursor;
import org.tmatesoft.sqljet.core.internal.table.SqlJetIndexScopeCursor;
import org.tmatesoft.sqljet.core.internal.table.SqlJetReverseOrderCursor;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTableDataCursor;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.sqljet.core.table.SqlJetScope;

public class SqlJetTable
implements ISqlJetTable {
    private final SqlJetDb db;
    private final ISqlJetBtree btree;
    private final String tableName;
    private final boolean write;

    public SqlJetTable(SqlJetDb db, ISqlJetBtree btree, String tableName, boolean write) throws SqlJetException {
        this.db = db;
        this.btree = btree;
        this.tableName = tableName;
        this.write = write;
        if (this.getDefinition() == null) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Table not found: " + tableName);
        }
    }

    @Override
    public SqlJetDb getDataBase() {
        return this.db;
    }

    @Override
    public String getPrimaryKeyIndexName() throws SqlJetException {
        ISqlJetTableDef definition = this.getDefinition();
        return definition.isRowIdPrimaryKey() ? null : definition.getPrimaryKeyIndexName();
    }

    @Override
    public ISqlJetTableDef getDefinition() throws SqlJetException {
        return this.btree.getSchema().getTable(this.tableName);
    }

    @Override
    public Set<ISqlJetIndexDef> getIndexesDefs() throws SqlJetException {
        return this.btree.getSchema().getIndexes(this.tableName);
    }

    @Override
    public Set<String> getIndexesNames() throws SqlJetException {
        return Collections.unmodifiableSet(this.getIndexesDefs().stream().map(ISqlJetIndexDef::getName).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
    }

    @Override
    public ISqlJetIndexDef getIndexDef(String name) throws SqlJetException {
        String realName;
        if (name == null) {
            realName = this.getPrimaryKeyIndexName();
            if (realName == null) {
                return null;
            }
        } else {
            realName = name;
        }
        return this.getIndexesDefs().stream().filter(indexDef -> realName.equalsIgnoreCase(indexDef.getName())).findFirst().orElse(null);
    }

    @Override
    public ISqlJetCursor open() throws SqlJetException {
        return this.db.runWithLock(db -> new SqlJetTableDataCursor(new SqlJetBtreeDataTable(this.btree, this.tableName, this.write), (SqlJetDb)db));
    }

    @Override
    public ISqlJetCursor lookup(String indexName, Object ... key) throws SqlJetException {
        Object[] k = SqlJetUtility.adjustNumberTypes(key);
        return this.db.runWithLock(db -> {
            SqlJetBtreeDataTable table = new SqlJetBtreeDataTable(this.btree, this.tableName, this.write);
            this.checkIndexName(indexName, table);
            return new SqlJetIndexScopeCursor(table, (SqlJetDb)db, indexName, k, k);
        });
    }

    private <T> T runWriteTransaction(ISqlJetTransaction<T, ISqlJetBtreeDataTable> op) throws SqlJetException {
        return (T)this.db.write().as(db -> {
            try (SqlJetBtreeDataTable table = new SqlJetBtreeDataTable(this.btree, this.tableName, this.write);){
                Object t = op.run(table);
                return t;
            }
        });
    }

    @Override
    public long insert(Object ... values) throws SqlJetException {
        return this.insertOr(null, values);
    }

    @Override
    public long insertByFieldNames(Map<String, Object> values) throws SqlJetException {
        return this.insertByFieldNamesOr(null, values);
    }

    @Override
    public long insertWithRowId(long rowId, Object ... values) throws SqlJetException {
        return this.insertWithRowIdOr(null, rowId, values);
    }

    @Override
    public long insertOr(SqlJetConflictAction onConflict, Object ... values) throws SqlJetException {
        return this.runWriteTransaction(table -> table.insert(onConflict, values));
    }

    @Override
    public long insertByFieldNamesOr(SqlJetConflictAction onConflict, Map<String, Object> values) throws SqlJetException {
        return this.runWriteTransaction(table -> table.insert(onConflict, values));
    }

    @Override
    public long insertWithRowIdOr(SqlJetConflictAction onConflict, long rowId, Object ... values) throws SqlJetException {
        return this.runWriteTransaction(table -> table.insertWithRowId(onConflict, rowId, values));
    }

    @Override
    public ISqlJetCursor order(String indexName) throws SqlJetException {
        return this.db.runWithLock(db -> {
            SqlJetBtreeDataTable table = new SqlJetBtreeDataTable(this.btree, this.tableName, this.write);
            this.checkIndexName(indexName, table);
            return new SqlJetIndexOrderCursor(table, (SqlJetDb)db, indexName);
        });
    }

    @Override
    public ISqlJetCursor scope(String indexName, Object[] firstKey, Object[] lastKey) throws SqlJetException {
        return this.scope(indexName, new SqlJetScope(firstKey, lastKey));
    }

    @Override
    public ISqlJetCursor scope(String indexName, SqlJetScope scope) throws SqlJetException {
        SqlJetScope adjustedScope = SqlJetUtility.adjustScopeNumberTypes(scope);
        return this.db.runWithLock(db -> {
            SqlJetBtreeDataTable table = new SqlJetBtreeDataTable(this.btree, this.tableName, this.write);
            this.checkIndexName(indexName, table);
            if (this.isNeedReverse(this.getIndexTable(indexName, table), adjustedScope)) {
                return new SqlJetReverseOrderCursor(new SqlJetIndexScopeCursor(table, (SqlJetDb)db, indexName, adjustedScope.reverse()));
            }
            return new SqlJetIndexScopeCursor(table, (SqlJetDb)db, indexName, adjustedScope);
        });
    }

    @Override
    public void clear() throws SqlJetException {
        this.runWriteTransaction(table -> {
            table.clear();
            return null;
        });
    }

    private boolean isNeedReverse(ISqlJetBtreeIndexTable indexTable, SqlJetScope scope) throws SqlJetException {
        Object[] lastKey;
        Object[] firstKey = scope.getLeftBound() != null ? scope.getLeftBound().getValue() : null;
        Object[] objectArray = lastKey = scope.getRightBound() != null ? scope.getRightBound().getValue() : null;
        if (firstKey != null && lastKey != null && firstKey.length > 0 && lastKey.length > 0) {
            if (indexTable != null) {
                return indexTable.compareKeys(firstKey, lastKey) < 0;
            }
            if (firstKey.length == 1 && lastKey.length == 1 && firstKey[0] instanceof Long && lastKey[0] instanceof Long) {
                return ((Long)firstKey[0]).compareTo((Long)lastKey[0]) > 0;
            }
        }
        return false;
    }

    private ISqlJetBtreeIndexTable getIndexTable(String indexName, SqlJetBtreeDataTable table) {
        String index = indexName == null ? table.getPrimaryKeyIndex() : indexName;
        return index != null ? table.getIndex(index) : null;
    }

    private void checkIndexName(String indexName, SqlJetBtreeDataTable table) throws SqlJetException {
        if (!this.isIndexNameValid(indexName, table)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Index not exists: %s", indexName));
        }
    }

    private boolean isIndexNameValid(String indexName, SqlJetBtreeDataTable table) {
        if (indexName != null) {
            return this.getIndexTable(indexName, table) != null;
        }
        if (table.getDefinition().isRowIdPrimaryKey()) {
            return true;
        }
        return table.getPrimaryKeyIndex() != null;
    }
}

