/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.vdbe;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetVarintResult32;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemFactory;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeSerialType;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;

public class SqlJetBtreeRecord
implements ISqlJetBtreeRecord {
    private final List<ISqlJetVdbeMem> fields;
    private final int fileFormat;

    public SqlJetBtreeRecord(ISqlJetBtreeCursor cursor, boolean isIndex, int fileFormat) throws SqlJetException {
        this.fileFormat = fileFormat;
        this.fields = SqlJetBtreeRecord.read(cursor, isIndex);
    }

    private SqlJetBtreeRecord(List<ISqlJetVdbeMem> values) {
        this.fileFormat = ISqlJetOptions.SQLJET_DEFAULT_FILE_FORMAT;
        this.fields = values;
    }

    public static ISqlJetBtreeRecord getRecord(SqlJetEncoding encoding, Object ... values) throws SqlJetException {
        ArrayList<ISqlJetVdbeMem> fields = new ArrayList<ISqlJetVdbeMem>(values.length);
        int i = 0;
        while (i < values.length) {
            ISqlJetVdbeMem mem;
            Object value = values[i];
            if (value == null) {
                mem = SqlJetVdbeMemFactory.getNull();
            } else if (value instanceof String) {
                mem = SqlJetVdbeMemFactory.getStr((String)value, encoding);
            } else if (value instanceof Boolean) {
                mem = SqlJetVdbeMemFactory.getInt((Boolean)value != false ? 1 : 0);
            } else if (value instanceof Float) {
                mem = SqlJetVdbeMemFactory.getDouble(((Float)value).doubleValue());
            } else if (value instanceof Double) {
                mem = SqlJetVdbeMemFactory.getDouble((Double)value);
            } else if (value instanceof Number) {
                mem = SqlJetVdbeMemFactory.getInt(((Number)value).longValue());
            } else if (value instanceof ByteBuffer) {
                mem = SqlJetVdbeMemFactory.getBlob(SqlJetUtility.fromByteBuffer((ByteBuffer)value), encoding);
            } else if (value instanceof InputStream) {
                mem = SqlJetVdbeMemFactory.getBlob(SqlJetUtility.streamToBuffer((InputStream)value), encoding);
            } else if ("byte[]".equalsIgnoreCase(value.getClass().getCanonicalName())) {
                mem = SqlJetVdbeMemFactory.getBlob(SqlJetUtility.wrapPtr((byte[])value), encoding);
            } else if (value instanceof SqlJetMemoryPointer) {
                mem = SqlJetVdbeMemFactory.getBlob((SqlJetMemoryPointer)value, encoding);
            } else {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Bad value #" + i + " " + value.toString());
            }
            fields.add(mem);
            ++i;
        }
        return new SqlJetBtreeRecord(fields);
    }

    @Override
    public int getFieldsCount() {
        return this.fields.size();
    }

    private static List<ISqlJetVdbeMem> read(ISqlJetBtreeCursor cursor, boolean isIndex) throws SqlJetException {
        long payloadSize;
        ArrayList<ISqlJetVdbeMem> result = new ArrayList<ISqlJetVdbeMem>();
        long l = payloadSize = isIndex ? cursor.getKeySize() : (long)cursor.getDataSize();
        if (payloadSize == 0L) {
            return result;
        }
        int[] avail = new int[1];
        ISqlJetMemoryPointer zData = isIndex ? cursor.keyFetch(avail) : cursor.dataFetch(avail);
        SqlJetVarintResult32 res = zData.getVarint32();
        int offset = res.getValue();
        int szHdrSz = res.getOffset();
        if (avail[0] < offset) {
            zData = SqlJetVdbeMemFactory.fromBtree(cursor, 0, offset, isIndex);
        }
        int zEndHdr = zData.getAbsolute(offset);
        ISqlJetMemoryPointer zIdx = zData.pointer(szHdrSz);
        int i = 0;
        while (i < 2000 && zIdx.getPointer() < zEndHdr && (long)offset <= payloadSize) {
            int cOffset = offset;
            SqlJetVarintResult32 res2 = zIdx.getVarint32();
            int a = res2.getValue();
            zIdx.movePointer(res2.getOffset());
            offset += SqlJetVdbeSerialType.serialTypeLen(a);
            result.add(SqlJetBtreeRecord.getField(cursor, isIndex, i, a, cOffset));
            ++i;
        }
        if (zIdx.getPointer() > zEndHdr || (long)offset > payloadSize || zIdx.getPointer() == zEndHdr && (long)offset != payloadSize) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        return result;
    }

    private static ISqlJetVdbeMem getField(ISqlJetBtreeCursor cursor, boolean isIndex, int column, int type, int offset) throws SqlJetException {
        ISqlJetVdbeMem pDest = SqlJetVdbeMemFactory.getNull();
        long payloadSize = isIndex ? cursor.getKeySize() : (long)cursor.getDataSize();
        if (payloadSize == 0L) {
            return pDest;
        }
        if (offset != 0) {
            int len = SqlJetVdbeSerialType.serialTypeLen(type);
            ISqlJetMemoryPointer z = SqlJetVdbeMemFactory.fromBtree(cursor, offset, len, isIndex);
            SqlJetEncoding encoding = cursor.getCursorDb().getOptions().getEncoding();
            pDest = SqlJetVdbeMemFactory.serialGet(z, type, encoding).getValue();
        }
        return pDest;
    }

    @Override
    public String getStringField(int field) throws SqlJetException {
        return this.fields.get(field).stringValue();
    }

    @Override
    public long getIntField(int field) {
        return this.fields.get(field).intValue();
    }

    @Override
    public double getRealField(int field) {
        return this.fields.get(field).realValue();
    }

    @Override
    public ISqlJetMemoryPointer getRawRecord() {
        int nData = 0;
        int nHdr = 0;
        int nByte = 0;
        for (ISqlJetVdbeMem value : this.fields) {
            int serialType = value.serialType(this.fileFormat);
            int len = SqlJetVdbeSerialType.serialTypeLen(serialType);
            nData += len;
            nHdr += SqlJetUtility.varintLen(serialType);
        }
        int nVarint = SqlJetUtility.varintLen(nHdr);
        if (nVarint < SqlJetUtility.varintLen(nHdr += nVarint)) {
            ++nHdr;
        }
        nByte = nHdr + nData;
        ISqlJetMemoryPointer zNewRecord = SqlJetUtility.memoryManager.allocatePtr(nByte);
        int i = zNewRecord.putVarint32(0, nHdr);
        int t = nHdr;
        for (ISqlJetVdbeMem value : this.fields) {
            i += zNewRecord.putVarint32(i, value.serialType(this.fileFormat));
            t += value.serialPut(zNewRecord.pointer(t), nByte - t, this.fileFormat);
        }
        assert (t == nByte);
        return zNewRecord;
    }

    @Override
    public ISqlJetVdbeMem getRawField(int field) {
        return this.fields.get(field);
    }

    @Override
    public ISqlJetVdbeMem getLastRawField() {
        return this.fields.isEmpty() ? null : this.fields.get(this.fields.size() - 1);
    }
}

