/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.vdbe;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetUnpackedRecord;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetResultWithOffset;
import org.tmatesoft.sqljet.core.internal.SqlJetUnpackedRecordFlags;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetVarintResult32;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetKeyInfo;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemFactory;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeSerialType;

public class SqlJetUnpackedRecord
implements ISqlJetUnpackedRecord {
    private final SqlJetKeyInfo pKeyInfo;
    private final Set<SqlJetUnpackedRecordFlags> flags = EnumSet.noneOf(SqlJetUnpackedRecordFlags.class);
    private final List<ISqlJetVdbeMem> aMem;

    public SqlJetUnpackedRecord(SqlJetKeyInfo pKeyInfo, List<ISqlJetVdbeMem> aMem) {
        this.pKeyInfo = pKeyInfo;
        this.aMem = aMem;
    }

    @Override
    public int recordCompare(int nKey1, ISqlJetMemoryPointer pKey1) throws SqlJetException {
        int i = 0;
        int rc = 0;
        SqlJetVarintResult32 res = pKey1.getVarint32();
        int szHdr1 = res.getValue();
        int idx1 = res.getOffset();
        int d1 = szHdr1--;
        if (this.flags.contains((Object)SqlJetUnpackedRecordFlags.IGNORE_ROWID)) {
            // empty if block
        }
        for (ISqlJetVdbeMem mem : this.aMem) {
            if (idx1 >= szHdr1) continue;
            SqlJetVarintResult32 res2 = pKey1.getVarint32(idx1);
            idx1 += res2.getOffset();
            if (d1 >= nKey1 && SqlJetVdbeSerialType.serialTypeLen(res2.getValue()) > 0) break;
            SqlJetResultWithOffset<ISqlJetVdbeMem> result = SqlJetVdbeMemFactory.serialGet(pKey1, d1, res2.getValue(), this.pKeyInfo.getEnc());
            d1 += result.getOffset();
            rc = result.getValue().compareTo(mem);
            if (rc != 0) break;
            ++i;
        }
        if (rc == 0) {
            if (this.flags.contains((Object)SqlJetUnpackedRecordFlags.INCRKEY)) {
                rc = -1;
            } else if (!this.flags.contains((Object)SqlJetUnpackedRecordFlags.PREFIX_MATCH) && idx1 < szHdr1) {
                rc = 1;
            }
        } else if (this.pKeyInfo.getSortOrder(i)) {
            rc = -rc;
        }
        return rc;
    }

    public Set<SqlJetUnpackedRecordFlags> getFlags() {
        return this.flags;
    }
}

