/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.vdbe;

import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetResultWithOffset;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemBlob;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemDouble;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemInt;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemNull;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemString;

public class SqlJetVdbeMemFactory {
    private static final SqlJetResultWithOffset<ISqlJetVdbeMem> NULL = new SqlJetResultWithOffset<ISqlJetVdbeMem>(SqlJetVdbeMemFactory.getNull(), 0);
    private static final SqlJetResultWithOffset<ISqlJetVdbeMem> ZERO = new SqlJetResultWithOffset<ISqlJetVdbeMem>(SqlJetVdbeMemFactory.getInt(0L), 0);
    private static final SqlJetResultWithOffset<ISqlJetVdbeMem> ONE = new SqlJetResultWithOffset<ISqlJetVdbeMem>(SqlJetVdbeMemFactory.getInt(1L), 0);

    public static ISqlJetVdbeMem getNull() {
        return SqlJetVdbeMemNull.INSTANCE;
    }

    public static ISqlJetVdbeMem getInt(long value) {
        return new SqlJetVdbeMemInt(value);
    }

    public static ISqlJetVdbeMem getDouble(double value) {
        return new SqlJetVdbeMemDouble(value);
    }

    public static ISqlJetVdbeMem getStr(String value, SqlJetEncoding enc) {
        return new SqlJetVdbeMemString(value, enc);
    }

    public static ISqlJetVdbeMem getStr(ISqlJetMemoryPointer z, SqlJetEncoding enc) {
        return SqlJetVdbeMemFactory.getStr(SqlJetUtility.toString(z, enc), enc);
    }

    public static ISqlJetVdbeMem getBlob(ISqlJetMemoryPointer z, SqlJetEncoding enc) {
        return new SqlJetVdbeMemBlob(z, enc);
    }

    public static ISqlJetMemoryPointer fromBtree(ISqlJetBtreeCursor pCur, int offset, int amt, boolean key) throws SqlJetException {
        ISqlJetMemoryPointer result;
        assert (pCur.getCursorDb().getMutex().held());
        int[] available = new int[1];
        ISqlJetMemoryPointer zData = key ? pCur.keyFetch(available) : pCur.dataFetch(available);
        assert (zData != null);
        if (offset + amt <= available[0]) {
            result = zData.pointer(offset);
        } else {
            result = SqlJetUtility.memoryManager.allocatePtr(amt + 2);
            if (key) {
                pCur.key(offset, amt, result);
            } else {
                pCur.data(offset, amt, result);
            }
            result.putByteUnsigned(amt, 0);
            result.putByteUnsigned(amt + 1, 0);
        }
        return result;
    }

    public static SqlJetResultWithOffset<ISqlJetVdbeMem> serialGet(ISqlJetMemoryPointer buf, int serialType, SqlJetEncoding enc) {
        return SqlJetVdbeMemFactory.serialGet(buf, 0, serialType, enc);
    }

    public static SqlJetResultWithOffset<ISqlJetVdbeMem> serialGet(ISqlJetMemoryPointer buf, int offset, int serialType, SqlJetEncoding enc) {
        switch (serialType) {
            case 0: 
            case 10: 
            case 11: {
                return NULL;
            }
            case 1: {
                ISqlJetVdbeMem result = SqlJetVdbeMemFactory.getInt(buf.getByte(offset));
                return new SqlJetResultWithOffset<ISqlJetVdbeMem>(result, 1);
            }
            case 2: {
                ISqlJetVdbeMem result = SqlJetVdbeMemFactory.getInt(SqlJetUtility.fromUnsigned(buf.getByteUnsigned(offset) << 8 | buf.getByteUnsigned(offset + 1)));
                return new SqlJetResultWithOffset<ISqlJetVdbeMem>(result, 2);
            }
            case 3: {
                ISqlJetVdbeMem result = SqlJetVdbeMemFactory.getInt(buf.getByte(offset) << 16 | buf.getByteUnsigned(offset + 1) << 8 | buf.getByteUnsigned(offset + 2));
                return new SqlJetResultWithOffset<ISqlJetVdbeMem>(result, 3);
            }
            case 4: {
                ISqlJetVdbeMem result = SqlJetVdbeMemFactory.getInt(SqlJetUtility.fromUnsigned(buf.getIntUnsigned(offset)));
                return new SqlJetResultWithOffset<ISqlJetVdbeMem>(result, 4);
            }
            case 5: {
                long x = buf.getByteUnsigned(offset) << 8 | buf.getByteUnsigned(offset + 1);
                long y = buf.getIntUnsigned(offset + 2);
                ISqlJetVdbeMem result = SqlJetVdbeMemFactory.getInt((long)((short)x) << 32 | y);
                return new SqlJetResultWithOffset<ISqlJetVdbeMem>(result, 6);
            }
            case 6: 
            case 7: {
                double v;
                long x = buf.getIntUnsigned(offset);
                long y = buf.getIntUnsigned(offset + 4);
                x = (long)((int)x) << 32 | y;
                ISqlJetVdbeMem result = serialType == 6 ? SqlJetVdbeMemFactory.getInt(x) : (Double.isNaN(v = Double.longBitsToDouble(x)) ? SqlJetVdbeMemFactory.getNull() : SqlJetVdbeMemFactory.getDouble(v));
                return new SqlJetResultWithOffset<ISqlJetVdbeMem>(result, 8);
            }
            case 8: {
                return ZERO;
            }
            case 9: {
                return ONE;
            }
        }
        int len = (serialType - 12) / 2;
        ISqlJetMemoryPointer pointer = buf.pointer(offset, len);
        ISqlJetVdbeMem result = (serialType & 1) != 0 ? SqlJetVdbeMemFactory.getStr(pointer, enc) : SqlJetVdbeMemFactory.getBlob(pointer, enc);
        return new SqlJetResultWithOffset<ISqlJetVdbeMem>(result, len);
    }
}

