/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.vdbe;

import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemAbstract;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemFactory;
import org.tmatesoft.sqljet.core.schema.SqlJetTypeAffinity;

public class SqlJetVdbeMemString
extends SqlJetVdbeMemAbstract {
    private final String str;
    private final SqlJetEncoding enc;

    public SqlJetVdbeMemString(String str, SqlJetEncoding enc) {
        this.str = str;
        this.enc = enc;
    }

    @Override
    public String stringValue() {
        return this.str;
    }

    @Override
    public long intValue() {
        try {
            return Long.parseLong(this.stringValue());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public double realValue() {
        try {
            return Double.parseDouble(this.stringValue());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isInt() {
        return false;
    }

    @Override
    public boolean isReal() {
        return false;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isBlob() {
        return false;
    }

    @Override
    public SqlJetValueType getType() {
        return SqlJetValueType.TEXT;
    }

    @Override
    public ISqlJetMemoryPointer blobValue() {
        return SqlJetUtility.fromString(this.str, this.enc);
    }

    @Override
    public ISqlJetVdbeMem applyAffinity(SqlJetTypeAffinity affinity, SqlJetEncoding enc) throws SqlJetException {
        String zStr;
        if ((affinity == SqlJetTypeAffinity.INTEGER || affinity == SqlJetTypeAffinity.REAL || affinity == SqlJetTypeAffinity.NUMERIC) && SqlJetUtility.isNumber(zStr = this.stringValue())) {
            if (SqlJetUtility.isRealNumber(zStr)) {
                return SqlJetVdbeMemFactory.getDouble(Double.parseDouble(zStr));
            }
            return SqlJetVdbeMemFactory.getInt(Long.parseLong(zStr));
        }
        return this;
    }

    @Override
    public int serialType(int file_format) {
        return this.str.getBytes(this.enc.getCharset()).length * 2 + 13;
    }

    @Override
    public int serialPut(ISqlJetMemoryPointer buf, int nBuf, int file_format) {
        byte[] bytes = this.str.getBytes(this.enc.getCharset());
        int len = bytes.length;
        assert (len <= nBuf);
        buf.putBytes(bytes);
        return len;
    }

    @Override
    public Object toObject() {
        return this.stringValue();
    }
}

