/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.simpleschema;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.simpleschema.SqlJetSimpleSchemaTable;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public class SqlJetSimpleSchemaField {
    private final SqlJetSimpleSchemaTable table;
    private final String name;
    private final String type;
    private final boolean indexed;

    private SqlJetSimpleSchemaField(SqlJetSimpleSchemaTable table, String name, String type, boolean indexed) {
        this.table = table;
        this.name = name;
        this.type = type;
        this.indexed = indexed;
    }

    public SqlJetSimpleSchemaField(String name, String type, boolean indexed) {
        this(null, name, type, indexed);
    }

    public SqlJetSimpleSchemaField withTable(SqlJetSimpleSchemaTable table) {
        return new SqlJetSimpleSchemaField(table, this.name, this.type, this.indexed);
    }

    public void updateDb(SqlJetDb db) throws SqlJetException {
        ISqlJetTableDef sqlJetTable = db.getSchema().getTable(this.table.getName());
        if (sqlJetTable.getColumn(this.name) == null) {
            db.alterTable("ALTER TABLE " + sqlJetTable.getName() + " ADD " + this.toSql());
        }
        if (this.indexed && db.getSchema().getIndex(this.indexName()) == null) {
            db.createIndex("CREATE INDEX " + this.indexName() + " ON " + sqlJetTable.getName() + "(" + this.name + ")");
        }
    }

    public SqlJetSimpleSchemaTable getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public String indexName() {
        return String.valueOf(this.table.getName()) + "__" + this.name;
    }

    public String toSql() {
        return String.valueOf(this.name) + " " + this.type;
    }
}

