/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.table;

public class SqlJetScope {
    private final SqlJetScopeBound myLeftBound;
    private final SqlJetScopeBound myRightBound;

    public SqlJetScope(Object[] leftKey, Object[] rightKey) {
        this(new SqlJetScopeBound(leftKey), new SqlJetScopeBound(rightKey));
    }

    public SqlJetScope(Object[] leftKey, boolean isLeftKeyIncluded, Object[] rightKey, boolean isRightKeyIncluded) {
        this(new SqlJetScopeBound(leftKey, isLeftKeyIncluded), new SqlJetScopeBound(rightKey, isRightKeyIncluded));
    }

    public SqlJetScope(SqlJetScopeBound leftBound, SqlJetScopeBound rightBound) {
        this.myLeftBound = leftBound == null ? new SqlJetScopeBound(null, true) : leftBound;
        this.myRightBound = rightBound == null ? new SqlJetScopeBound(null, true) : rightBound;
    }

    public SqlJetScopeBound getLeftBound() {
        return this.myLeftBound;
    }

    public SqlJetScopeBound getRightBound() {
        return this.myRightBound;
    }

    public SqlJetScope reverse() {
        return new SqlJetScope(this.myRightBound, this.myLeftBound);
    }

    public String toString() {
        return this.myLeftBound + ":" + this.myRightBound;
    }

    public static class SqlJetScopeBound {
        private final Object[] myValue;
        private final boolean myIsInclusive;

        public SqlJetScopeBound(Object[] value) {
            this(value, true);
        }

        public SqlJetScopeBound(Object[] value, boolean inclusive) {
            this.myValue = value;
            this.myIsInclusive = inclusive;
        }

        public Object[] getValue() {
            return this.myValue;
        }

        public boolean isInclusive() {
            return this.myIsInclusive;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.isInclusive() ? (char)'[' : '(');
            if (this.getValue() == null) {
                sb.append(this.getValue());
            } else if (this.getValue().length > 0) {
                sb.append(this.getValue()[0]);
                if (this.getValue().length > 1) {
                    sb.append(",...");
                }
            }
            sb.append(this.isInclusive() ? (char)']' : ')');
            return sb.toString();
        }
    }
}

