/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.table.engine;

import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.SqlJetAssert;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.sqljet.core.internal.SqlJetSafetyLevel;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.db.SqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileSystemsManager;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.internal.table.SqlJetOptions;
import org.tmatesoft.sqljet.core.table.ISqlJetBooleanTransaction;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetDefaultBusyHandler;

public abstract class SqlJetEngine {
    private static final Set<SqlJetBtreeFlags> READ_FLAGS = Collections.unmodifiableSet(SqlJetUtility.of(SqlJetBtreeFlags.READONLY));
    private static final Set<SqlJetFileOpenPermission> READ_PERMISSIONS = Collections.unmodifiableSet(SqlJetUtility.of(SqlJetFileOpenPermission.READONLY));
    private static final Set<SqlJetBtreeFlags> WRITE_FLAGS = Collections.unmodifiableSet(SqlJetUtility.of(SqlJetBtreeFlags.READWRITE, SqlJetBtreeFlags.CREATE));
    private static final Set<SqlJetFileOpenPermission> WRITE_PREMISSIONS = Collections.unmodifiableSet(SqlJetUtility.of(SqlJetFileOpenPermission.READWRITE, SqlJetFileOpenPermission.CREATE));
    protected final ISqlJetFileSystem fileSystem;
    protected final boolean writable;
    protected ISqlJetDbHandle dbHandle;
    protected ISqlJetBtree btree;
    protected boolean open = true;
    private final File file;
    private SqlJetTransactionMode transactionMode;

    public SqlJetEngine(File file, boolean writable, ISqlJetFileSystem fs) throws SqlJetException {
        this.file = file;
        this.fileSystem = fs;
        this.dbHandle = new SqlJetDbHandle(this.fileSystem);
        this.dbHandle.setBusyHandler(new SqlJetDefaultBusyHandler());
        EnumSet<SqlJetBtreeFlags> flags = EnumSet.copyOf(writable ? WRITE_FLAGS : READ_FLAGS);
        EnumSet<SqlJetFileOpenPermission> permissions = EnumSet.copyOf(writable ? WRITE_PREMISSIONS : READ_PERMISSIONS);
        SqlJetFileType type = file != null ? SqlJetFileType.MAIN_DB : SqlJetFileType.TEMP_DB;
        this.btree = new SqlJetBtree(file, this.dbHandle, flags, type, permissions);
        ISqlJetFile file2 = this.btree.getPager().getFile();
        if (file2 != null) {
            Set<SqlJetFileOpenPermission> realPermissions = this.btree.getPager().getFile().getPermissions();
            this.writable = realPermissions.contains((Object)SqlJetFileOpenPermission.READWRITE);
        } else {
            this.writable = writable;
        }
    }

    public SqlJetEngine(File file, boolean writable) throws SqlJetException {
        this(file, writable, SqlJetFileSystemsManager.getManager().find(null));
    }

    public SqlJetEngine(File file, boolean writable, String fsName) throws SqlJetException {
        this(file, writable, SqlJetAssert.assertNotNull(SqlJetFileSystemsManager.getManager().find(fsName), SqlJetErrorCode.MISUSE, String.format("File system '%s' not found", fsName)));
    }

    public void registerFileSystem(ISqlJetFileSystem fs, boolean isDefault) throws SqlJetException {
        SqlJetFileSystemsManager.getManager().register(fs, isDefault);
    }

    public void unregisterFileSystem(ISqlJetFileSystem fs) throws SqlJetException {
        SqlJetFileSystemsManager.getManager().unregister(fs);
    }

    public File getFile() {
        return this.file;
    }

    public boolean isWritable() throws SqlJetException {
        return this.writable;
    }

    public ISqlJetFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public boolean isOpen() {
        return this.open;
    }

    protected void checkOpen() throws SqlJetException {
        SqlJetAssert.assertTrue(this.isOpen(), SqlJetErrorCode.MISUSE, "Database closed");
    }

    public <T> T runSynchronized(ISqlJetTransaction<T, SqlJetEngine> op) throws SqlJetException {
        this.checkOpen();
        return (T)this.dbHandle.getMutex().run(mutex -> op.run(this));
    }

    public boolean runSynchronizedBool(ISqlJetBooleanTransaction<SqlJetEngine> op) throws SqlJetException {
        this.checkOpen();
        return this.dbHandle.getMutex().runBool(mutex -> op.run(this));
    }

    public void close() throws SqlJetException {
        if (this.open) {
            this.runSynchronized(engine -> {
                if (this.btree != null) {
                    this.btree.close();
                    this.btree = null;
                    this.open = false;
                }
                this.closeResources();
                return null;
            });
            if (!this.open) {
                this.dbHandle = null;
            }
        }
    }

    protected void closeResources() throws SqlJetException {
    }

    protected void finalize() throws Throwable {
        try {
            if (this.open) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void readSchema() throws SqlJetException {
        this.runSynchronized(engline -> {
            this.dbHandle.setOptions(new SqlJetOptions(this.btree, this.dbHandle));
            this.btree.setSchema(new SqlJetSchema(this.dbHandle, this.btree));
            return null;
        });
    }

    public ISqlJetOptions getOptions() throws SqlJetException {
        this.checkOpen();
        if (this.btree.getSchema() == null) {
            this.readSchema();
        }
        return this.dbHandle.getOptions();
    }

    public void refreshSchema() throws SqlJetException {
        if (this.btree.getSchema() == null || !this.getOptions().verifySchemaVersion()) {
            this.readSchema();
        }
    }

    protected SqlJetSchema getSchemaInternal() throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return this.btree.getSchema();
    }

    public ISqlJetBusyHandler getBusyHandler() {
        return this.dbHandle.getBusyHandler();
    }

    public void setBusyHandler(ISqlJetBusyHandler busyHandler) {
        this.dbHandle.setBusyHandler(busyHandler);
    }

    public void setCacheSize(int cacheSize) throws SqlJetException {
        this.checkOpen();
        this.runSynchronized(engline -> {
            this.btree.setCacheSize(cacheSize);
            return null;
        });
    }

    public int getCacheSize() throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return this.btree.getCacheSize();
    }

    public void setSafetyLevel(SqlJetSafetyLevel safetyLevel) throws SqlJetException {
        this.checkOpen();
        this.runSynchronized(engine -> {
            this.btree.setSafetyLevel(safetyLevel);
            return null;
        });
    }

    public void setJournalMode(SqlJetPagerJournalMode journalMode) throws SqlJetException {
        this.checkOpen();
        this.runSynchronized(engine -> {
            this.btree.setJournalMode(journalMode);
            return null;
        });
    }

    public SqlJetSafetyLevel getSafetyLevel() throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return this.btree.getSafetyLevel();
    }

    public SqlJetPagerJournalMode getJournalMode() throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return this.runSynchronized(engine -> this.btree.getJournalMode());
    }

    public boolean isInTransaction() {
        return this.transactionMode != null;
    }

    public SqlJetTransactionMode getTransactionMode() {
        return this.transactionMode;
    }

    public void beginTransaction(SqlJetTransactionMode mode) throws SqlJetException {
        this.checkOpen();
        this.runSynchronized(engine -> {
            if (!this.isTransactionStarted(mode)) {
                this.doBeginTransaction(mode);
            }
            return null;
        });
    }

    public void commit() throws SqlJetException {
        this.checkOpen();
        this.runSynchronized(engine -> {
            if (this.isInTransaction()) {
                this.doCommitTransaction();
            }
            return null;
        });
    }

    public void rollback() throws SqlJetException {
        this.checkOpen();
        this.runSynchronized(engine -> {
            this.doRollbackTransaction();
            return null;
        });
    }

    public <T> T runEngineTransaction(ISqlJetTransaction<T, SqlJetEngine> op, SqlJetTransactionMode mode) throws SqlJetException {
        this.checkOpen();
        return (T)this.runSynchronized(engine -> {
            if (this.isTransactionStarted(mode)) {
                return op.run(this);
            }
            this.doBeginTransaction(mode);
            boolean success = false;
            try {
                Object result = op.run(this);
                this.doCommitTransaction();
                success = true;
                Object t = result;
                return t;
            }
            finally {
                if (!success) {
                    this.doRollbackTransaction();
                }
                this.transactionMode = null;
            }
        });
    }

    public boolean runEngineTransactionBool(ISqlJetBooleanTransaction<SqlJetEngine> op, SqlJetTransactionMode mode) throws SqlJetException {
        this.checkOpen();
        return this.runSynchronizedBool(engine -> {
            if (this.isTransactionStarted(mode)) {
                return op.run(this);
            }
            this.doBeginTransaction(mode);
            boolean success = false;
            try {
                boolean result = op.run(this);
                this.doCommitTransaction();
                success = true;
                boolean bl = result;
                return bl;
            }
            finally {
                if (!success) {
                    this.doRollbackTransaction();
                }
                this.transactionMode = null;
            }
        });
    }

    private boolean isTransactionStarted(SqlJetTransactionMode mode) {
        return this.transactionMode != null && (this.transactionMode == mode || mode == SqlJetTransactionMode.READ_ONLY);
    }

    private void doBeginTransaction(SqlJetTransactionMode mode) throws SqlJetException {
        this.btree.beginTrans(mode);
        this.refreshSchema();
        this.transactionMode = mode;
    }

    private void doCommitTransaction() throws SqlJetException {
        this.btree.closeAllCursors();
        this.btree.commit();
        this.transactionMode = null;
    }

    private void doRollbackTransaction() throws SqlJetException {
        this.btree.closeAllCursors();
        this.btree.rollback();
        this.transactionMode = null;
    }
}

