/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.rodos;

import cz.vutbr.fit.rodos.MainParameters;
import cz.vutbr.fit.rodos.db.DatabaseManager;
import cz.vutbr.fit.rodos.db.rows.AsimRow;
import cz.vutbr.fit.rodos.db.rows.GenericRow;
import cz.vutbr.fit.rodos.db.rows.TableRow;
import cz.vutbr.fit.rodos.db.rows.TollGateRow;
import cz.vutbr.fit.rodos.db.tables.AsimTable;
import cz.vutbr.fit.rodos.db.tables.GenericTable;
import cz.vutbr.fit.rodos.db.tables.TollGateTable;
import general.io.OutputManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import libsvm.SvmModel;
import libsvm.SvmNode;
import libsvm.SvmParameters;
import libsvm.SvmProblem;
import libsvm.svm.Svm;

public class Main {
    private DatabaseManager dm = new DatabaseManager();

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(OutputManager.getInstance());
        try {
            new Main().run(args);
        }
        catch (Exception e) {
            OutputManager.getInstance().printException(e);
        }
    }

    private void run(String[] args) throws Exception {
        MainParameters mainParams = new MainParameters(args);
        if (mainParams.dbHost != null) {
            this.dm.setHost(mainParams.dbHost);
        }
        if (mainParams.dbPort != -1) {
            this.dm.setPort(mainParams.dbPort);
        }
        if (mainParams.db != null) {
            this.dm.setDatabase(mainParams.db);
        }
        if (mainParams.dbUser != null) {
            this.dm.setUser(mainParams.dbUser);
        }
        if (mainParams.dbPassword != null) {
            this.dm.setPassword(mainParams.dbPassword);
        }
        SvmParameters svmParams = new SvmParameters();
        svmParams.svmType = mainParams.svmType;
        svmParams.kernelType = mainParams.kernelType;
        svmParams.gamma = 1.0 / (double)(mainParams.detectorType == 1 ? 5 : 11);
        svmParams.degree = mainParams.polyDegree;
        if (mainParams.mode == 1) {
            SvmProblem trainingProblem = this.createProblem(mainParams);
            if (trainingProblem == null) {
                return;
            }
            SvmModel model = Svm.train(trainingProblem, svmParams);
            Svm.saveModel(mainParams.modelFile, model);
            OutputManager.getInstance().printMessage("Model saved to: " + mainParams.modelFile);
        } else if (mainParams.mode == 2) {
            SvmModel model;
            try {
                model = Svm.loadModel(mainParams.modelFile);
            }
            catch (IOException e) {
                throw new Exception("Cannot read model from file: " + mainParams.modelFile, e);
            }
            SvmProblem testingProblem = this.createProblem(mainParams);
            if (OutputManager.getInstance().isMathematicaOnly()) {
                String out = "{";
                for (int i = 0; i < testingProblem.l; ++i) {
                    SvmNode[] x = testingProblem.x[i];
                    double y = testingProblem.y[i];
                    double y_p = Svm.predict(model, x);
                    if (i > 0) {
                        out = out + ",";
                    }
                    out = out + "{" + y + "," + y_p + "}";
                }
                out = out + "}";
                OutputManager.getInstance().printOutputForMathematica(out);
            } else {
                for (int i = 0; i < testingProblem.l; ++i) {
                    SvmNode[] x = testingProblem.x[i];
                    double y = testingProblem.y[i];
                    double y_p = Svm.predict(model, x);
                    OutputManager.getInstance().printMessage("y = " + y + ", y_p = " + y_p);
                }
            }
        } else {
            OutputManager.getInstance().printErrorMessage("Nothing to do.");
        }
    }

    private SvmProblem createProblem(MainParameters params) {
        int gid;
        Iterator iterator;
        HashMap<Integer, ArrayList<TableRow>> dbData = new HashMap<Integer, ArrayList<TableRow>>();
        HashMap values = new HashMap();
        ArrayList<Integer> gids = new ArrayList<Integer>();
        for (int gid2 : params.allDetectors) {
            if (gid2 == params.predictDetector) continue;
            gids.add(gid2);
        }
        gids.add(params.predictDetector);
        if (params.detectorType == 1) {
            TollGateTable tollGateTable = new TollGateTable(this.dm);
            iterator = gids.iterator();
            while (iterator.hasNext()) {
                gid = (Integer)iterator.next();
                List<TollGateRow> rows = tollGateTable.getSumByHour(gid, params.timeFrom, params.timeTo);
                dbData.put(gid, new ArrayList<TollGateRow>(rows));
            }
        } else if (params.detectorType == 0) {
            AsimTable asimTable = new AsimTable(this.dm);
            iterator = gids.iterator();
            while (iterator.hasNext()) {
                gid = (Integer)iterator.next();
                List<AsimRow> rows = asimTable.getSumByHour(gid, params.timeFrom, params.timeTo);
                dbData.put(gid, new ArrayList<AsimRow>(rows));
            }
        } else {
            GenericTable table = new GenericTable(this.dm, params.dbTable, params.dbColDetector, params.dbColTime, params.dbColAmount);
            iterator = gids.iterator();
            while (iterator.hasNext()) {
                gid = (Integer)iterator.next();
                List<GenericRow> rows = table.getSumByHour(gid, params.timeFrom, params.timeTo);
                dbData.put(gid, new ArrayList<GenericRow>(rows));
            }
        }
        for (int i = 0; i < gids.size(); ++i) {
            int gid3 = (Integer)gids.get(i);
            for (TableRow row : (List)dbData.get(gid3)) {
                long time = 0L;
                double value = 0.0;
                if (params.detectorType == 1) {
                    TollGateRow tgRow = (TollGateRow)row;
                    time = tgRow.start.getTime();
                    if (params.columnType == 2) {
                        value = tgRow.axes2;
                    } else if (params.columnType == 3) {
                        value = tgRow.axes3;
                    } else if (params.columnType == 4) {
                        value = tgRow.axes4;
                    }
                } else if (params.detectorType == 0) {
                    AsimRow aRow = (AsimRow)row;
                    time = aRow.start.getTime();
                    if (params.columnType == 1) {
                        value = aRow.category_1_amount;
                    } else if (params.columnType == 2) {
                        value = aRow.category_2_amount;
                    } else if (params.columnType == 3) {
                        value = aRow.category_3_amount;
                    } else if (params.columnType == 4) {
                        value = aRow.category_4_amount;
                    } else if (params.columnType == 5) {
                        value = aRow.category_5_amount;
                    } else if (params.columnType == 6) {
                        value = aRow.category_6_amount;
                    }
                } else {
                    GenericRow gRow = (GenericRow)row;
                    time = gRow.time.getTime();
                    value = gRow.amount;
                }
                if (!values.containsKey(time)) {
                    values.put(time, new HashMap());
                }
                ((HashMap)values.get(time)).put(gid3, value);
            }
        }
        SvmProblem problem = new SvmProblem();
        problem.l = values.size();
        problem.x = new SvmNode[problem.l][];
        problem.y = new double[problem.l];
        LinkedList times = new LinkedList(values.keySet());
        Collections.sort(times);
        for (int i = 0; i < times.size(); ++i) {
            long time = (Long)times.get(i);
            HashMap row = (HashMap)values.get(time);
            problem.x[i] = new SvmNode[gids.size() - 1];
            for (int j = 0; j < gids.size(); ++j) {
                int gid4 = (Integer)gids.get(j);
                double value = 0.0;
                if (row.containsKey(gid4)) {
                    value = (Double)row.get(gid4);
                }
                if (j == gids.size() - 1) {
                    problem.y[i] = value;
                    continue;
                }
                SvmNode node = new SvmNode();
                node.index = j;
                node.value = value;
                problem.x[i][j] = node;
            }
        }
        return problem;
    }
}

