/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.rodos.db.tables;

import cz.vutbr.fit.rodos.db.DatabaseManager;
import cz.vutbr.fit.rodos.db.DatabaseTable;
import cz.vutbr.fit.rodos.db.StatementManager;
import cz.vutbr.fit.rodos.db.rows.GenericRow;
import general.io.OutputManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class GenericTable
extends DatabaseTable {
    private String tableName;
    private String detectorColumn;
    private String timeColumn;
    private String amountColumn;

    public GenericTable(DatabaseManager dm, String tableName, String detectorColumn, String rowTime, String rowAmount) {
        super(dm);
        this.detectorColumn = detectorColumn;
        this.tableName = tableName;
        this.timeColumn = rowTime;
        this.amountColumn = rowAmount;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDetectorColumn() {
        return this.detectorColumn;
    }

    public String getTimeColumn() {
        return this.timeColumn;
    }

    public String getAmountColumn() {
        return this.amountColumn;
    }

    public List<GenericRow> getSumByHour(int detector, String timeStart, String timeEnd) {
        ArrayList<GenericRow> rows = new ArrayList<GenericRow>();
        String sql = "SELECT     " + this.detectorColumn + ",     DATE_FORMAT(" + this.timeColumn + ", \"%Y-%m-%d %H:00:00\") " + this.timeColumn + ",     SUM(" + this.amountColumn + ") " + this.amountColumn + " FROM     " + this.tableName + " WHERE     " + this.detectorColumn + " = ? AND     DATE(" + this.timeColumn + ") >= ? AND     DATE(" + this.timeColumn + ") < ? GROUP BY     DATE(" + this.timeColumn + "),     HOUR(" + this.timeColumn + ") ORDER BY     DATE(" + this.timeColumn + ") ASC,     HOUR(" + this.timeColumn + ") ASC; ";
        try (StatementManager sm = new StatementManager(this.dm);){
            PreparedStatement ps = sm.prepareStatement(sql);
            int i = 0;
            ps.setInt(++i, detector);
            ps.setString(++i, timeStart);
            ps.setString(++i, timeEnd);
            ResultSet rs = ps.executeQuery();
            rows.addAll(GenericRow.getRows(this, rs));
        }
        catch (SQLException e) {
            OutputManager.getInstance().printException(e);
        }
        return rows;
    }
}

