/*
 * Decompiled with CFR 0.152.
 */
package general.io;

public class OutputManager
implements Thread.UncaughtExceptionHandler {
    private static OutputManager instance;
    private boolean mathematicaOnly = false;

    public static OutputManager getInstance() {
        if (instance == null) {
            instance = new OutputManager();
        }
        return instance;
    }

    private OutputManager() {
    }

    public boolean isMathematicaOnly() {
        return this.mathematicaOnly;
    }

    public void setMathematicaOnly(boolean mathematicaOnly) {
        this.mathematicaOnly = mathematicaOnly;
    }

    public void printException(Throwable t) {
        t.printStackTrace();
    }

    public void printErrorMessage(String msg) {
        System.err.println(msg);
    }

    public void printMessage(String msg) {
        if (!this.mathematicaOnly) {
            System.out.println(msg);
        }
    }

    public void printCharacters(String chars) {
        if (!this.mathematicaOnly) {
            System.out.print(chars);
        }
    }

    public void printOutputForMathematica(String output) {
        System.out.println(output);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.printException(e);
    }
}

