/*
 * Decompiled with CFR 0.152.
 */
package libsvm.svm;

import libsvm.SvmParameters;
import libsvm.SvmProblem;
import libsvm.svm.SvmCache;
import libsvm.svm.SvmKernel;

class OneClassQ
extends SvmKernel {
    private final SvmCache cache;
    private final double[] QD;

    OneClassQ(SvmProblem prob, SvmParameters param) {
        super(prob.l, prob.x, param);
        this.cache = new SvmCache(prob.l, (long)(param.cache_size * 1048576.0));
        this.QD = new double[prob.l];
        for (int i = 0; i < prob.l; ++i) {
            this.QD[i] = this.kernel_function(i, i);
        }
    }

    @Override
    float[] get_Q(int i, int len) {
        float[][] data = new float[1][];
        int start = this.cache.get_data(i, data, len);
        if (start < len) {
            for (int j = start; j < len; ++j) {
                data[0][j] = (float)this.kernel_function(i, j);
            }
        }
        return data[0];
    }

    @Override
    double[] get_QD() {
        return this.QD;
    }

    @Override
    void swap_index(int i, int j) {
        this.cache.swap_index(i, j);
        super.swap_index(i, j);
        double tmp = this.QD[i];
        this.QD[i] = this.QD[j];
        this.QD[j] = tmp;
    }
}

