/*
 * Decompiled with CFR 0.152.
 */
package libsvm.svm;

import general.io.OutputManager;
import libsvm.svm.QMatrix;
import libsvm.svm.Svm;

class SvmSolver {
    int active_size;
    byte[] y;
    double[] G;
    static final byte LOWER_BOUND = 0;
    static final byte UPPER_BOUND = 1;
    static final byte FREE = 2;
    byte[] alpha_status;
    double[] alpha;
    QMatrix Q;
    double[] QD;
    double eps;
    double Cp;
    double Cn;
    double[] p;
    int[] active_set;
    double[] G_bar;
    int l;
    boolean unshrink;
    static final double INF = Double.POSITIVE_INFINITY;

    SvmSolver() {
    }

    double get_C(int i) {
        return this.y[i] > 0 ? this.Cp : this.Cn;
    }

    void update_alpha_status(int i) {
        this.alpha_status[i] = this.alpha[i] >= this.get_C(i) ? 1 : (this.alpha[i] <= 0.0 ? 0 : 2);
    }

    boolean is_upper_bound(int i) {
        return this.alpha_status[i] == 1;
    }

    boolean is_lower_bound(int i) {
        return this.alpha_status[i] == 0;
    }

    boolean is_free(int i) {
        return this.alpha_status[i] == 2;
    }

    void swap_index(int i, int j) {
        this.Q.swap_index(i, j);
        byte tmp = this.y[i];
        this.y[i] = this.y[j];
        this.y[j] = tmp;
        double tmp2 = this.G[i];
        this.G[i] = this.G[j];
        this.G[j] = tmp2;
        tmp = this.alpha_status[i];
        this.alpha_status[i] = this.alpha_status[j];
        this.alpha_status[j] = tmp;
        double tmp3 = this.alpha[i];
        this.alpha[i] = this.alpha[j];
        this.alpha[j] = tmp3;
        tmp3 = this.p[i];
        this.p[i] = this.p[j];
        this.p[j] = tmp3;
        int tmp4 = this.active_set[i];
        this.active_set[i] = this.active_set[j];
        this.active_set[j] = tmp4;
        double tmp5 = this.G_bar[i];
        this.G_bar[i] = this.G_bar[j];
        this.G_bar[j] = tmp5;
    }

    void reconstruct_gradient() {
        int j;
        if (this.active_size == this.l) {
            return;
        }
        int nr_free = 0;
        for (j = this.active_size; j < this.l; ++j) {
            this.G[j] = this.G_bar[j] + this.p[j];
        }
        for (j = 0; j < this.active_size; ++j) {
            if (!this.is_free(j)) continue;
            ++nr_free;
        }
        if (2 * nr_free < this.active_size) {
            Svm.info("\nWARNING: using -h 0 may be faster\n");
        }
        if (nr_free * this.l > 2 * this.active_size * (this.l - this.active_size)) {
            for (int i = this.active_size; i < this.l; ++i) {
                float[] Q_i = this.Q.get_Q(i, this.active_size);
                for (j = 0; j < this.active_size; ++j) {
                    if (!this.is_free(j)) continue;
                    int n = i;
                    this.G[n] = this.G[n] + this.alpha[j] * (double)Q_i[j];
                }
            }
        } else {
            for (int i = 0; i < this.active_size; ++i) {
                if (!this.is_free(i)) continue;
                float[] Q_i = this.Q.get_Q(i, this.l);
                double alpha_i = this.alpha[i];
                for (j = this.active_size; j < this.l; ++j) {
                    int n = j;
                    this.G[n] = this.G[n] + alpha_i * (double)Q_i[j];
                }
            }
        }
    }

    void Solve(int l, QMatrix Q, double[] p_, byte[] y_, double[] alpha_, double Cp, double Cn, double eps, SolutionInfo si, int shrinking) {
        int i;
        this.l = l;
        this.Q = Q;
        this.QD = Q.get_QD();
        this.p = (double[])p_.clone();
        this.y = (byte[])y_.clone();
        this.alpha = (double[])alpha_.clone();
        this.Cp = Cp;
        this.Cn = Cn;
        this.eps = eps;
        this.unshrink = false;
        this.alpha_status = new byte[l];
        for (i = 0; i < l; ++i) {
            this.update_alpha_status(i);
        }
        this.active_set = new int[l];
        for (i = 0; i < l; ++i) {
            this.active_set[i] = i;
        }
        this.active_size = l;
        this.G = new double[l];
        this.G_bar = new double[l];
        for (i = 0; i < l; ++i) {
            this.G[i] = this.p[i];
            this.G_bar[i] = 0.0;
        }
        for (i = 0; i < l; ++i) {
            int j;
            if (this.is_lower_bound(i)) continue;
            float[] Q_i = Q.get_Q(i, l);
            double alpha_i = this.alpha[i];
            for (j = 0; j < l; ++j) {
                int n = j;
                this.G[n] = this.G[n] + alpha_i * (double)Q_i[j];
            }
            if (!this.is_upper_bound(i)) continue;
            for (j = 0; j < l; ++j) {
                int n = j;
                this.G_bar[n] = this.G_bar[n] + this.get_C(i) * (double)Q_i[j];
            }
        }
        int iter = 0;
        int max_iter = Math.max(10000000, l > 21474836 ? Integer.MAX_VALUE : 100 * l);
        int counter = Math.min(l, 1000) + 1;
        int[] working_set = new int[2];
        while (iter < max_iter) {
            int k;
            double delta;
            double quad_coef;
            if (--counter == 0) {
                counter = Math.min(l, 1000);
                if (shrinking != 0) {
                    this.do_shrinking();
                }
                Svm.info(".");
            }
            if (this.select_working_set(working_set) != 0) {
                this.reconstruct_gradient();
                this.active_size = l;
                Svm.info("*");
                if (this.select_working_set(working_set) != 0) break;
                counter = 1;
            }
            int i2 = working_set[0];
            int j = working_set[1];
            ++iter;
            float[] Q_i = Q.get_Q(i2, this.active_size);
            float[] Q_j = Q.get_Q(j, this.active_size);
            double C_i = this.get_C(i2);
            double C_j = this.get_C(j);
            double old_alpha_i = this.alpha[i2];
            double old_alpha_j = this.alpha[j];
            if (this.y[i2] != this.y[j]) {
                quad_coef = this.QD[i2] + this.QD[j] + (double)(2.0f * Q_i[j]);
                if (quad_coef <= 0.0) {
                    quad_coef = 1.0E-12;
                }
                delta = (-this.G[i2] - this.G[j]) / quad_coef;
                double diff = this.alpha[i2] - this.alpha[j];
                int n = i2;
                this.alpha[n] = this.alpha[n] + delta;
                int n2 = j;
                this.alpha[n2] = this.alpha[n2] + delta;
                if (diff > 0.0) {
                    if (this.alpha[j] < 0.0) {
                        this.alpha[j] = 0.0;
                        this.alpha[i2] = diff;
                    }
                } else if (this.alpha[i2] < 0.0) {
                    this.alpha[i2] = 0.0;
                    this.alpha[j] = -diff;
                }
                if (diff > C_i - C_j) {
                    if (this.alpha[i2] > C_i) {
                        this.alpha[i2] = C_i;
                        this.alpha[j] = C_i - diff;
                    }
                } else if (this.alpha[j] > C_j) {
                    this.alpha[j] = C_j;
                    this.alpha[i2] = C_j + diff;
                }
            } else {
                quad_coef = this.QD[i2] + this.QD[j] - (double)(2.0f * Q_i[j]);
                if (quad_coef <= 0.0) {
                    quad_coef = 1.0E-12;
                }
                delta = (this.G[i2] - this.G[j]) / quad_coef;
                double sum = this.alpha[i2] + this.alpha[j];
                int n = i2;
                this.alpha[n] = this.alpha[n] - delta;
                int n3 = j;
                this.alpha[n3] = this.alpha[n3] + delta;
                if (sum > C_i) {
                    if (this.alpha[i2] > C_i) {
                        this.alpha[i2] = C_i;
                        this.alpha[j] = sum - C_i;
                    }
                } else if (this.alpha[j] < 0.0) {
                    this.alpha[j] = 0.0;
                    this.alpha[i2] = sum;
                }
                if (sum > C_j) {
                    if (this.alpha[j] > C_j) {
                        this.alpha[j] = C_j;
                        this.alpha[i2] = sum - C_j;
                    }
                } else if (this.alpha[i2] < 0.0) {
                    this.alpha[i2] = 0.0;
                    this.alpha[j] = sum;
                }
            }
            double delta_alpha_i = this.alpha[i2] - old_alpha_i;
            double delta_alpha_j = this.alpha[j] - old_alpha_j;
            for (int k2 = 0; k2 < this.active_size; ++k2) {
                int n = k2;
                this.G[n] = this.G[n] + ((double)Q_i[k2] * delta_alpha_i + (double)Q_j[k2] * delta_alpha_j);
            }
            boolean ui = this.is_upper_bound(i2);
            boolean uj = this.is_upper_bound(j);
            this.update_alpha_status(i2);
            this.update_alpha_status(j);
            if (ui != this.is_upper_bound(i2)) {
                Q_i = Q.get_Q(i2, l);
                if (ui) {
                    for (k = 0; k < l; ++k) {
                        int n = k;
                        this.G_bar[n] = this.G_bar[n] - C_i * (double)Q_i[k];
                    }
                } else {
                    for (k = 0; k < l; ++k) {
                        int n = k;
                        this.G_bar[n] = this.G_bar[n] + C_i * (double)Q_i[k];
                    }
                }
            }
            if (uj == this.is_upper_bound(j)) continue;
            Q_j = Q.get_Q(j, l);
            if (uj) {
                for (k = 0; k < l; ++k) {
                    int n = k;
                    this.G_bar[n] = this.G_bar[n] - C_j * (double)Q_j[k];
                }
                continue;
            }
            for (k = 0; k < l; ++k) {
                int n = k;
                this.G_bar[n] = this.G_bar[n] + C_j * (double)Q_j[k];
            }
        }
        if (iter >= max_iter) {
            if (this.active_size < l) {
                this.reconstruct_gradient();
                this.active_size = l;
                Svm.info("*");
            }
            OutputManager.getInstance().printErrorMessage("\nWARNING: reaching max number of iterations.");
        }
        si.rho = this.calculate_rho();
        double v = 0.0;
        for (int i3 = 0; i3 < l; ++i3) {
            v += this.alpha[i3] * (this.G[i3] + this.p[i3]);
        }
        si.obj = v / 2.0;
        for (int i4 = 0; i4 < l; ++i4) {
            alpha_[this.active_set[i4]] = this.alpha[i4];
        }
        si.upper_bound_p = Cp;
        si.upper_bound_n = Cn;
        Svm.info("\noptimization finished, #iter = " + iter + "\n");
    }

    int select_working_set(int[] working_set) {
        double Gmax = Double.NEGATIVE_INFINITY;
        double Gmax2 = Double.NEGATIVE_INFINITY;
        int Gmax_idx = -1;
        int Gmin_idx = -1;
        double obj_diff_min = Double.POSITIVE_INFINITY;
        for (int t = 0; t < this.active_size; ++t) {
            if (this.y[t] == 1) {
                if (this.is_upper_bound(t) || !(-this.G[t] >= Gmax)) continue;
                Gmax = -this.G[t];
                Gmax_idx = t;
                continue;
            }
            if (this.is_lower_bound(t) || !(this.G[t] >= Gmax)) continue;
            Gmax = this.G[t];
            Gmax_idx = t;
        }
        int i = Gmax_idx;
        float[] Q_i = null;
        if (i != -1) {
            Q_i = this.Q.get_Q(i, this.active_size);
        }
        for (int j = 0; j < this.active_size; ++j) {
            double quad_coef;
            double obj_diff;
            double grad_diff;
            if (this.y[j] == 1) {
                if (this.is_lower_bound(j)) continue;
                grad_diff = Gmax + this.G[j];
                if (this.G[j] >= Gmax2) {
                    Gmax2 = this.G[j];
                }
                if (!(grad_diff > 0.0) || !((obj_diff = (quad_coef = this.QD[i] + this.QD[j] - 2.0 * (double)this.y[i] * (double)Q_i[j]) > 0.0 ? -(grad_diff * grad_diff) / quad_coef : -(grad_diff * grad_diff) / 1.0E-12) <= obj_diff_min)) continue;
                Gmin_idx = j;
                obj_diff_min = obj_diff;
                continue;
            }
            if (this.is_upper_bound(j)) continue;
            grad_diff = Gmax - this.G[j];
            if (-this.G[j] >= Gmax2) {
                Gmax2 = -this.G[j];
            }
            if (!(grad_diff > 0.0) || !((obj_diff = (quad_coef = this.QD[i] + this.QD[j] + 2.0 * (double)this.y[i] * (double)Q_i[j]) > 0.0 ? -(grad_diff * grad_diff) / quad_coef : -(grad_diff * grad_diff) / 1.0E-12) <= obj_diff_min)) continue;
            Gmin_idx = j;
            obj_diff_min = obj_diff;
        }
        if (Gmax + Gmax2 < this.eps || Gmin_idx == -1) {
            return 1;
        }
        working_set[0] = Gmax_idx;
        working_set[1] = Gmin_idx;
        return 0;
    }

    private boolean be_shrunk(int i, double Gmax1, double Gmax2) {
        if (this.is_upper_bound(i)) {
            if (this.y[i] == 1) {
                return -this.G[i] > Gmax1;
            }
            return -this.G[i] > Gmax2;
        }
        if (this.is_lower_bound(i)) {
            if (this.y[i] == 1) {
                return this.G[i] > Gmax2;
            }
            return this.G[i] > Gmax1;
        }
        return false;
    }

    void do_shrinking() {
        int i;
        double Gmax1 = Double.NEGATIVE_INFINITY;
        double Gmax2 = Double.NEGATIVE_INFINITY;
        for (i = 0; i < this.active_size; ++i) {
            if (this.y[i] == 1) {
                if (!this.is_upper_bound(i) && -this.G[i] >= Gmax1) {
                    Gmax1 = -this.G[i];
                }
                if (this.is_lower_bound(i) || !(this.G[i] >= Gmax2)) continue;
                Gmax2 = this.G[i];
                continue;
            }
            if (!this.is_upper_bound(i) && -this.G[i] >= Gmax2) {
                Gmax2 = -this.G[i];
            }
            if (this.is_lower_bound(i) || !(this.G[i] >= Gmax1)) continue;
            Gmax1 = this.G[i];
        }
        if (!this.unshrink && Gmax1 + Gmax2 <= this.eps * 10.0) {
            this.unshrink = true;
            this.reconstruct_gradient();
            this.active_size = this.l;
        }
        block1: for (i = 0; i < this.active_size; ++i) {
            if (!this.be_shrunk(i, Gmax1, Gmax2)) continue;
            --this.active_size;
            while (this.active_size > i) {
                if (!this.be_shrunk(this.active_size, Gmax1, Gmax2)) {
                    this.swap_index(i, this.active_size);
                    continue block1;
                }
                --this.active_size;
            }
        }
    }

    double calculate_rho() {
        int nr_free = 0;
        double ub = Double.POSITIVE_INFINITY;
        double lb = Double.NEGATIVE_INFINITY;
        double sum_free = 0.0;
        for (int i = 0; i < this.active_size; ++i) {
            double yG = (double)this.y[i] * this.G[i];
            if (this.is_lower_bound(i)) {
                if (this.y[i] > 0) {
                    ub = Math.min(ub, yG);
                    continue;
                }
                lb = Math.max(lb, yG);
                continue;
            }
            if (this.is_upper_bound(i)) {
                if (this.y[i] < 0) {
                    ub = Math.min(ub, yG);
                    continue;
                }
                lb = Math.max(lb, yG);
                continue;
            }
            ++nr_free;
            sum_free += yG;
        }
        double r = nr_free > 0 ? sum_free / (double)nr_free : (ub + lb) / 2.0;
        return r;
    }

    static class SolutionInfo {
        double obj;
        double rho;
        double upper_bound_p;
        double upper_bound_n;
        double r;

        SolutionInfo() {
        }
    }
}

