/*
 * Decompiled with CFR 0.152.
 */
package libsvm.tools;

import general.io.OutputManager;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import libsvm.SvmModel;
import libsvm.SvmNode;
import libsvm.SvmPrintInterface;
import libsvm.svm.Svm;

class SvmPredict {
    private static SvmPrintInterface svm_print_null = new SvmPrintInterface(){

        @Override
        public void print(String s) {
        }
    };
    private static SvmPrintInterface svm_print_stdout;
    private static SvmPrintInterface svm_print_string;

    SvmPredict() {
    }

    static void info(String s) {
        svm_print_string.print(s);
    }

    private static double atof(String s) {
        return Double.valueOf(s);
    }

    private static int atoi(String s) {
        return Integer.parseInt(s);
    }

    private static void predict(BufferedReader input, DataOutputStream output, SvmModel model, int predict_probability) throws IOException {
        String line;
        int correct = 0;
        int total = 0;
        double error = 0.0;
        double sumv = 0.0;
        double sumy = 0.0;
        double sumvv = 0.0;
        double sumyy = 0.0;
        double sumvy = 0.0;
        int svm_type = Svm.svm_get_svm_type(model);
        int nr_class = Svm.svm_get_nr_class(model);
        double[] prob_estimates = null;
        if (predict_probability == 1) {
            if (svm_type == 3 || svm_type == 4) {
                SvmPredict.info("Prob. model for test data: target value = predicted value + z,\nz: Laplace distribution e^(-|z|/sigma)/(2sigma),sigma=" + Svm.svm_get_svr_probability(model) + "\n");
            } else {
                int[] labels = new int[nr_class];
                Svm.svm_get_labels(model, labels);
                prob_estimates = new double[nr_class];
                output.writeBytes("labels");
                for (int j = 0; j < nr_class; ++j) {
                    output.writeBytes(" " + labels[j]);
                }
                output.writeBytes("\n");
            }
        }
        while ((line = input.readLine()) != null) {
            double v;
            StringTokenizer st = new StringTokenizer(line, " \t\n\r\f:");
            double target = SvmPredict.atof(st.nextToken());
            int m = st.countTokens() / 2;
            SvmNode[] x = new SvmNode[m];
            for (int j = 0; j < m; ++j) {
                x[j] = new SvmNode();
                x[j].index = SvmPredict.atoi(st.nextToken());
                x[j].value = SvmPredict.atof(st.nextToken());
            }
            if (predict_probability == 1 && (svm_type == 0 || svm_type == 1)) {
                v = Svm.svm_predict_probability(model, x, prob_estimates);
                output.writeBytes(v + " ");
                for (int j = 0; j < nr_class; ++j) {
                    output.writeBytes(prob_estimates[j] + " ");
                }
                output.writeBytes("\n");
            } else {
                v = Svm.predict(model, x);
                output.writeBytes(v + "\n");
            }
            if (v == target) {
                ++correct;
            }
            error += (v - target) * (v - target);
            sumv += v;
            sumy += target;
            sumvv += v * v;
            sumyy += target * target;
            sumvy += v * target;
            ++total;
        }
        if (svm_type == 3 || svm_type == 4) {
            SvmPredict.info("Mean squared error = " + error / (double)total + " (regression)\n");
            SvmPredict.info("Squared correlation coefficient = " + ((double)total * sumvy - sumv * sumy) * ((double)total * sumvy - sumv * sumy) / (((double)total * sumvv - sumv * sumv) * ((double)total * sumyy - sumy * sumy)) + " (regression)\n");
        } else {
            SvmPredict.info("Accuracy = " + (double)correct / (double)total * 100.0 + "% (" + correct + "/" + total + ") (classification)\n");
        }
    }

    private static void exit_with_help() {
        OutputManager.getInstance().printErrorMessage("usage: SvmPredict [options] test_file model_file output_file\noptions:\n-b probability_estimates: whether to predict probability estimates, 0 or 1 (default 0); one-class SVM not supported yet\n-q : quiet mode (no outputs)");
        System.exit(1);
    }

    public static void main(String[] argv) throws IOException {
        int i;
        int predict_probability = 0;
        svm_print_string = svm_print_stdout;
        block7: for (i = 0; i < argv.length && argv[i].charAt(0) == '-'; ++i) {
            switch (argv[++i - 1].charAt(1)) {
                case 'b': {
                    predict_probability = SvmPredict.atoi(argv[i]);
                    continue block7;
                }
                case 'q': {
                    svm_print_string = svm_print_null;
                    --i;
                    continue block7;
                }
                default: {
                    OutputManager.getInstance().printErrorMessage("Unknown option: " + argv[i - 1]);
                    SvmPredict.exit_with_help();
                }
            }
        }
        if (i >= argv.length - 2) {
            SvmPredict.exit_with_help();
        }
        try {
            BufferedReader input = new BufferedReader(new FileReader(argv[i]));
            DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(argv[i + 2])));
            SvmModel model = Svm.loadModel(argv[i + 1]);
            if (model == null) {
                OutputManager.getInstance().printErrorMessage("can't open model file " + argv[i + 1] + "\n");
                System.exit(1);
            }
            if (predict_probability == 1) {
                if (Svm.svm_check_probability_model(model) == 0) {
                    OutputManager.getInstance().printErrorMessage("Model does not support probabiliy estimates\n");
                    System.exit(1);
                }
            } else if (Svm.svm_check_probability_model(model) != 0) {
                SvmPredict.info("Model supports probability estimates, but disabled in prediction.\n");
            }
            SvmPredict.predict(input, output, model, predict_probability);
            input.close();
            output.close();
        }
        catch (FileNotFoundException e) {
            SvmPredict.exit_with_help();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            SvmPredict.exit_with_help();
        }
    }

    static {
        svm_print_string = svm_print_stdout = new SvmPrintInterface(){

            @Override
            public void print(String s) {
                OutputManager.getInstance().printCharacters(s);
            }
        };
    }
}

