package cz.vutbr.fit.rodos;

import general.io.OutputManager;
import libsvm.SvmParameters;

public class MainParameters
{
    public static final int NO_VALUE = -1;
    
    public static final int DETECTOR_ASIM = 0;
    public static final int DETECTOR_TOLLGATE = 1;
    public static final int DETECTOR_OTHER = 2;
    
    public static final int COLUMN_CATEGORY_1 = 1;
    public static final int COLUMN_CATEGORY_2 = 2;
    public static final int COLUMN_CATEGORY_3 = 3;
    public static final int COLUMN_CATEGORY_4 = 4;
    public static final int COLUMN_CATEGORY_5 = 5;
    public static final int COLUMN_CATEGORY_6 = 6;
    public static final int COLUMN_AXES_2 = 2;
    public static final int COLUMN_AXES_3 = 3;
    public static final int COLUMN_AXES_4 = 4;
    
    public static final int MODE_TRAIN = 1;
    public static final int MODE_PREDICT = 2;
    
    public int mode;
    public int svmType;
    public int kernelType;
    public int polyDegree;
    public int detectorType;
    public int columnType;
    
    public int predictDetector;
    public int[] allDetectors;
    
    public String dbHost;
    public int dbPort;
    public String db;
    public String dbUser;
    public String dbPassword;
    public String dbTable;
    public String dbColTime;
    public String dbColDetector;
    public String dbColAmount;
    
    public String modelFile;
    
    public String timeFrom;
    public String timeTo;

    public MainParameters( String[] args ) throws Exception
    {
        mode = NO_VALUE;
        svmType = NO_VALUE;
        kernelType = NO_VALUE;
        polyDegree = NO_VALUE;
        detectorType = NO_VALUE;
        columnType = NO_VALUE;
        
        predictDetector = NO_VALUE;
        allDetectors = null;
    
        dbHost = null;
        dbPort = NO_VALUE;
        db = null;
        dbUser = null;
        dbPassword = null;
    
        dbTable = null;
        dbColDetector = null;
        dbColAmount = null;
        dbColTime = null;
        
        modelFile = null;
    
        timeFrom = null;
        timeTo = null;
        
        for( int i = 0; i < args.length; ++i )
        {
            String arg = args[i];
            String argNext = "";
    
            if( i + 1 < args.length )
            {
                argNext = args[i+1];
            }
    
            if( "--help".equals( arg ) )
            {
                this.printHelp();
            }
            else if( "--train".equals( arg ) )
            {
                mode = MODE_TRAIN;
            }
            else if( "--predict".equals( arg ) )
            {
                mode = MODE_PREDICT;
            }
            else if( "--modelFile".equals( arg ) )
            {
                modelFile = argNext;
    
                ++i;
            }
            else if( "--dbHost".equals( arg ) )
            {
                dbHost = argNext;
                
                ++i;
            }
            else if( "--dbPort".equals( arg ) )
            {
                try
                {
                    dbPort = Integer.parseInt( argNext );
    
                    ++i;
                }
                catch( NumberFormatException e )
                {
                    throw new Exception( "Cannot parse value for parameter: " + arg, e );
                }
            }
            else if( "--db".equals( arg ) )
            {
                db = argNext;
    
                ++i;
            }
            else if( "--dbUser".equals( arg ) )
            {
                dbUser = argNext;
    
                ++i;
            }
            else if( "--dbPassword".equals( arg ) )
            {
                dbPassword = argNext;
    
                ++i;
            }
            else if( "--dbTable".equals( arg ) )
            {
                dbTable = argNext;
    
                ++i;
            }
            else if( "--dbColDetector".equals( arg ) )
            {
                dbColDetector = argNext;
    
                ++i;
            }
            else if( "--dbColAmount".equals( arg ) )
            {
                dbColAmount = argNext;
    
                ++i;
            }
            else if( "--dbColTime".equals( arg ) )
            {
                dbColTime = argNext;
    
                ++i;
            }
            else if( "--timeFrom".equals( arg ) )
            {
                timeFrom = argNext;
    
                ++i;
            }
            else if( "--timeTo".equals( arg ) )
            {
                timeTo = argNext;
    
                ++i;
            }
            else if( "--output".equals( arg ) )
            {
                if( "mathematica".equals( argNext ) )
                {
                    OutputManager.getInstance().setMathematicaOnly( true );
        
                    ++i;
                }
                else if( "all".equals( argNext ) )
                {
                    OutputManager.getInstance().setMathematicaOnly( false );
        
                    ++i;
                }
                else
                {
                    throw new Exception( "Cannot parse value for parameter: " + arg );
                }
            }
            else if( "--svm".equals( arg ) )
            {
                if( "epsilon".equals( argNext ) )
                {
                    svmType = SvmParameters.SVM_TYPE_EPSILON_SVR;
    
                    ++i;
                }
                else if( "nu".equals( argNext ) )
                {
                    svmType = SvmParameters.SVM_TYPE_NU_SVR;
    
                    ++i;
                }
                else
                {
                    throw new Exception( "Cannot parse value for parameter: " + arg );
                }
            }
            else if( "--kernel".equals( arg ) )
            {
                if( "rbf".equals( argNext ) )
                {
                    kernelType = SvmParameters.KERNEL_TYPE_RBF;
    
                    ++i;
                }
                else if( "poly".equals( argNext ) )
                {
                    kernelType = SvmParameters.KERNEL_TYPE_POLY;
    
                    ++i;
                }
                else if( "linear".equals( argNext ) )
                {
                    kernelType = SvmParameters.KERNEL_TYPE_LINEAR;
    
                    ++i;
                }
                else
                {
                    throw new Exception( "Cannot parse value for parameter: " + arg );
                }
            }
            else if( "--polyDegree".equals( arg ) )
            {
                try
                {
                    this.polyDegree = Integer.parseInt( argNext );
    
                    ++i;
                }
                catch( NumberFormatException e )
                {
                    throw new Exception( "Cannot parse value for parameter: " + arg, e );
                }
            }
            else if( "--detectorType".equals( arg ) )
            {
                if( "tollgate".equals( argNext ) )
                {
                    this.detectorType = DETECTOR_TOLLGATE;
    
                    ++i;
                }
                else if( "asim".equals( argNext ) )
                {
                    this.detectorType = DETECTOR_ASIM;
    
                    ++i;
                }
                else if( "other".equals( argNext ) )
                {
                    this.detectorType = DETECTOR_OTHER;
    
                    ++i;
                }
                else
                {
                    throw new Exception( "Cannot parse value for parameter: " + arg );
                }
            }
            else if( "--columnType".equals( arg ) )
            {
                if( "cat1".equals( argNext ) )
                {
                    this.columnType = COLUMN_CATEGORY_1;
    
                    ++i;
                }
                else if( "cat2".equals( argNext ) )
                {
                    this.columnType = COLUMN_CATEGORY_2;
    
                    ++i;
                }
                else if( "cat3".equals( argNext ) )
                {
                    this.columnType = COLUMN_CATEGORY_3;
    
                    ++i;
                }
                else if( "cat4".equals( argNext ) )
                {
                    this.columnType = COLUMN_CATEGORY_4;
    
                    ++i;
                }
                else if( "cat5".equals( argNext ) )
                {
                    this.columnType = COLUMN_CATEGORY_5;
    
                    ++i;
                }
                else if( "cat6".equals( argNext ) )
                {
                    this.columnType = COLUMN_CATEGORY_6;
    
                    ++i;
                }
                else if( "axes2".equals( argNext ) )
                {
                    this.columnType = COLUMN_AXES_2;
    
                    ++i;
                }
                else if( "axes3".equals( argNext ) )
                {
                    this.columnType = COLUMN_AXES_3;
    
                    ++i;
                }
                else if( "axes4".equals( argNext ) )
                {
                    this.columnType = COLUMN_AXES_4;
    
                    ++i;
                }
                else
                {
                    throw new Exception( "Cannot parse value for parameter: " + arg );
                }
            }
            else if( "--predict".equals( arg ) )
            {
                try
                {
                    this.predictDetector = Integer.parseInt( argNext );
    
                    ++i;
                }
                catch( NumberFormatException e )
                {
                    throw new Exception( "Cannot parse value for parameter: " + arg, e );
                }
            }
            else if( "--detectors".equals( arg ) )
            {
                String[] ids = argNext.split( "," );
                
                allDetectors = new int[ids.length];
    
                try
                {
                    for( int j = 0; j < ids.length; ++j )
                    {
                        allDetectors[j] = Integer.parseInt( ids[i] );
                    }
        
                    ++i;
                }
                catch( NumberFormatException e )
                {
                    throw new Exception( "Cannot parse value for parameter: " + arg, e );
                }
            }
            else
            {
                throw new Exception( "Unknown program parameter: " + arg );
            }
        }
        
        if( dbTable == null )
        {
            dbTable = "unknown_table";
        }
        else if( dbColDetector == null )
        {
            dbColDetector = "gid";
        }
        else if( dbColAmount == null )
        {
            dbColAmount = "amount";
        }
        else if( dbColTime == null )
        {
            dbColTime = "time";
        }
        
        if( modelFile == null )
        {
            modelFile = "svm.model";
        }
    
        if( timeFrom == null )
        {
            timeFrom = "0000-00-00";
        }
    
        if( timeTo == null )
        {
            timeTo = "0000-00-00";
        }
        
        if( svmType == NO_VALUE )
        {
            svmType = SvmParameters.SVM_TYPE_EPSILON_SVR;
        }
        
        if( kernelType == NO_VALUE )
        {
            kernelType = SvmParameters.KERNEL_TYPE_LINEAR;
        }
        
        if( polyDegree == NO_VALUE )
        {
            polyDegree = 3;
        }
        
        if( detectorType == NO_VALUE )
        {
            detectorType = DETECTOR_TOLLGATE;
        }
        
        if( columnType == NO_VALUE )
        {
            if( detectorType == DETECTOR_TOLLGATE )
            {
                columnType = COLUMN_AXES_2;
            }
            else
            {
                columnType = COLUMN_CATEGORY_2;
            }
        }
        
        if( predictDetector == NO_VALUE )
        {
            if( detectorType == DETECTOR_TOLLGATE )
            {
                predictDetector = 571;
            }
            else
            {
                predictDetector = 79;
            }
        }
        
        if( allDetectors == null )
        {
            if( detectorType == MainParameters.DETECTOR_ASIM )
            {
                allDetectors = new int[]
                        {
                                79, 80,
                                81, 82,
                                83, 84,
                                85, 86,
                                165, 166,
                                167, 168
                        };
            }
            else if( detectorType == MainParameters.DETECTOR_TOLLGATE )
            {
                allDetectors = new int[]{ 537, 536, 284, 285, 311, 571 };
            }
            else
            {
                throw new Exception( "No detectors selected." );
            }
        }
    }
    
    public void printHelp()
    {
        String help = "" +
                "--help\n" +
                "    Will print this help.\n" +
                "    \n" +
                "--train\n" +
                "    Will train SVM model.\n" +
                "    \n" +
                "--predict\n" +
                "    Will predict detector data.\n" +
                "    \n" +
                "--modelFile <path>\n" +
                "    Where to load from / save to model file.\n" +
                "    Default value is 'svm.model'.\n" +
                "    \n" +
                "--dbHost <host>\n" +
                "    Database host.nDefault value 'localhost'.\n" +
                "    \n" +
                "--dbPort <port>\n" +
                "    Database port.\n" +
                "    Default value is default port.\n" +
                "    \n" +
                "--db <name>\n" +
                "    Database name.\n" +
                "    \n" +
                "--dbUser <user>\n" +
                "    Database user. Default value 'root'.\n" +
                "    \n" +
                "--dbPassword <password>\n" +
                "    Database password. Empty be default.\n" +
                "    \n" +
                "--dbTable <table name>\n" +
                "    Custom database table.\n" +
                "    Use if your table is not predefined Asim / Tollgate table.\n" +
                "    \n" +
                "--dbColDetector <column name>\n" +
                "    Custom column containing detector ID.\n" +
                "    Use if your table is not predefined Asim / Tollgate table.\n" +
                "    \n" +
                "--dbColAmount <column name>\n" +
                "    Custom column containing amount of vehicles.\n"  +
                "    Use if your table is not predefined Asim / Tollgate table.\n" +
                "    \n" +
                "--dbColTime <column name>\n"  +
                "    Custom column containg time of last row update.\n" +
                "    Use if your table is not predefined Asim / Tollgate table.\n" +
                "    \n" +
                "--timeFrom <datetime>\n" +
                "    Interval star time in SQL format.\n" +
                "    \n" +
                "--timeTo <datetime>\n" +
                "    Interval end time in SQL format.\n" +
                "    \n" +
                "--output <type>\n" +
                "    all -> Write everything to the output (default).\n" +
                "    mathematica -> Write only data for Wolfram Mathematica to the output.\n" +
                "                   Format: {{y, y_predicted}, ...}\n" +
                "    \n" +
                "--svm <type>\n" +
                "    epsilon / nu\n" +
                "    \n" +
                "--kernel <type>\n" +
                "    rbf / poly / linear\n" +
                "    \n" +
                "--polyDegree <degree>\n" +
                "    Polynomial degree for poly kernel.\n" +
                "    \n" +
                "--detectorType <type>\n" +
                "    asim / tollgate / other\n" +
                "    \n" +
                "--columnType <type>\n" +
                "    asim: cat1 / cat2 / cat3 / cat4 / cat5 / cat6\n" +
                "    tollgate: axes2 / axes3 / axes4\n" +
                "    other: (use --dbColXxx to define columns)\n" +
                "    \n" +
                "--predict <id>\n" +
                "    ID of the detector for which the training / predicting is done.\n" +
                "    \n" +
                "--detectors <id,id,id,...>\n" +
                "    IDs of all detectors contained in the model.\n" +
                "    Separated with ',' without spaces.\n" +
                "    \n";
    }
}
