
package cz.vutbr.fit.rodos.db;

import general.io.OutputManager;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author karel
 */
public class StatementManager implements AutoCloseable
{
    private final DatabaseManager dm;
    
    private Connection conn;
    
    private final List<Statement> statements;

    public StatementManager( DatabaseManager dm )
    {
        this.dm = dm;
        
        this.statements = new ArrayList<>();
    }
    
    private Connection getConnection() throws SQLException
    {
        if( conn == null || conn.isClosed() )
        {
            conn = dm.getConnection();
        }
        
        return conn;
    }
    
    public DatabaseMetaData getMetaData() throws SQLException
    {
        return this.getConnection().getMetaData();
    }
    
    public PreparedStatement prepareStatement( String sql ) throws SQLException
    {
        return this.prepareStatement( sql, false );
    }
    
    public PreparedStatement prepareStatement( String sql, boolean returnKeys ) throws SQLException
    {
        PreparedStatement ps;
        
        if( returnKeys )
        {
            ps = this.getConnection().prepareStatement( sql, Statement.RETURN_GENERATED_KEYS );
        }
        else
        {
            ps = this.getConnection().prepareStatement( sql );
        }
        
        statements.add( ps );
        
        return ps;
    }
    
    public Statement createStatement() throws SQLException
    {
        Statement st = this.getConnection().createStatement();
        
        statements.add( st );
        
        return st;
    }

    @Override
    public void close()
    {
        if( conn != null )
        {
            try
            {
                conn.close();
            }
            catch( SQLException e )
            {
                OutputManager.getInstance().printException( e );
            }
        }
        
        for( Statement ps : statements )
        {
            try
            {
                ps.close();
            }
            catch( SQLException e )
            {
                OutputManager.getInstance().printException( e );
            }
        }
    }
}
