package cz.vutbr.fit.rodos.db.rows;

import cz.vutbr.fit.rodos.db.tables.AsimTable;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AsimRow extends TableRow
{
    public int id;
    public int gid;
    public Date start;
    public int category_1_amount;
    public int category_2_amount;
    public int category_3_amount;
    public int category_4_amount;
    public int category_5_amount;
    public int category_6_amount;
    public int category_1_speed;
    public int category_2_speed;
    public int category_3_speed;
    public int category_4_speed;
    public int category_5_speed;
    public int category_6_speed;
    
    public AsimRow( ResultSet rs ) throws SQLException
    {
        id = rs.getInt( AsimTable.COL_ID );
        gid = rs.getInt( AsimTable.COL_GID );
        
        start = rs.getTimestamp( AsimTable.COL_START );
        
        category_1_amount = rs.getInt( AsimTable.COL_CATEGORY_1_AMOUNT );
        category_2_amount = rs.getInt( AsimTable.COL_CATEGORY_2_AMOUNT );
        category_3_amount = rs.getInt( AsimTable.COL_CATEGORY_3_AMOUNT );
        category_4_amount = rs.getInt( AsimTable.COL_CATEGORY_4_AMOUNT );
        category_5_amount = rs.getInt( AsimTable.COL_CATEGORY_5_AMOUNT );
        category_6_amount = rs.getInt( AsimTable.COL_CATEGORY_6_AMOUNT );

        category_1_speed = rs.getInt( AsimTable.COL_CATEGORY_1_SPEED );
        category_2_speed = rs.getInt( AsimTable.COL_CATEGORY_2_SPEED );
        category_3_speed = rs.getInt( AsimTable.COL_CATEGORY_3_SPEED );
        category_4_speed = rs.getInt( AsimTable.COL_CATEGORY_4_SPEED );
        category_5_speed = rs.getInt( AsimTable.COL_CATEGORY_5_SPEED );
        category_6_speed = rs.getInt( AsimTable.COL_CATEGORY_6_SPEED );
    }
    
    public static List<AsimRow> getRows( ResultSet rs ) throws SQLException
    {
        List<AsimRow> list = new ArrayList<>();
        
        while( rs.next() )
        {
            list.add( new AsimRow( rs ) );
        }
        
        return list;
    }
}
