package cz.vutbr.fit.rodos.db.rows;

import cz.vutbr.fit.rodos.db.tables.AsimTable;
import cz.vutbr.fit.rodos.db.tables.GenericTable;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GenericRow extends TableRow
{
    public int detector;
    public Date time;
    public long amount;
    
    public GenericRow( GenericTable table, ResultSet rs ) throws SQLException
    {
        detector = rs.getInt( table.getDetectorColumn() );
        
        time = rs.getTimestamp( table.getTimeColumn() );
        
        amount = rs.getLong( table.getAmountColumn() );
    }
    
    public static List<GenericRow> getRows( GenericTable table, ResultSet rs ) throws SQLException
    {
        List<GenericRow> list = new ArrayList<>();
        
        while( rs.next() )
        {
            list.add( new GenericRow( table, rs ) );
        }
        
        return list;
    }
}
