package cz.vutbr.fit.rodos.db.rows;

import cz.vutbr.fit.rodos.db.tables.TollGateTable;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TollGateRow extends TableRow
{
    public int id;
    public int gid;
    public Date start;
    public Date updated;
    public int axes2;
    public int axes3;
    public int axes4;
    
    TollGateRow( ResultSet rs ) throws SQLException
    {
        id = rs.getInt( TollGateTable.COL_ID );
        
        gid = rs.getInt( TollGateTable.COL_GID );
    
        start = rs.getTimestamp( TollGateTable.COL_START );
        updated = rs.getTimestamp( TollGateTable.COL_UPDATED );
    
        axes2 = rs.getInt( TollGateTable.COL_AXES_2 );
        axes3 = rs.getInt( TollGateTable.COL_AXES_3 );
        axes4 = rs.getInt( TollGateTable.COL_AXES_4 );
    }
    
    public static List<TollGateRow> getRows( ResultSet rs ) throws SQLException
    {
        List<TollGateRow> list = new ArrayList<>();
        
        while( rs.next() )
        {
            list.add( new TollGateRow( rs ) );
        }
        
        return list;
    }
}
