package cz.vutbr.fit.rodos.db.tables;

import cz.vutbr.fit.rodos.db.DatabaseManager;
import cz.vutbr.fit.rodos.db.DatabaseTable;
import cz.vutbr.fit.rodos.db.StatementManager;
import cz.vutbr.fit.rodos.db.rows.AsimRow;
import general.io.OutputManager;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class AsimTable extends DatabaseTable
{
    public static final String TABLE_NAME = "asim";
    
    public static final String COL_ID = "id";
    public static final String COL_GID = "detector";
    public static final String COL_START = "start";
    public static final String COL_CATEGORY_1_AMOUNT = "category_1_amount";
    public static final String COL_CATEGORY_2_AMOUNT = "category_2_amount";
    public static final String COL_CATEGORY_3_AMOUNT = "category_3_amount";
    public static final String COL_CATEGORY_4_AMOUNT = "category_4_amount";
    public static final String COL_CATEGORY_5_AMOUNT = "category_5_amount";
    public static final String COL_CATEGORY_6_AMOUNT = "category_6_amount";
    public static final String COL_CATEGORY_1_SPEED = "category_1_speed";
    public static final String COL_CATEGORY_2_SPEED = "category_2_speed";
    public static final String COL_CATEGORY_3_SPEED = "category_3_speed";
    public static final String COL_CATEGORY_4_SPEED = "category_4_speed";
    public static final String COL_CATEGORY_5_SPEED = "category_5_speed";
    public static final String COL_CATEGORY_6_SPEED = "category_6_speed";
    
    public AsimTable( DatabaseManager dm )
    {
        super( dm );
    }
    
    public List<AsimRow> getSumByHour( int gid, String dateStart, String dateEnd )
    {
        List<AsimRow> rows = new ArrayList<>();
    
        String sql = "" +
                "SELECT " +
                "    -1 " + COL_ID + ", " +
                "    " + COL_GID + ", " +
                "    DATE_FORMAT(" + COL_START + ", \"%Y-%m-%d %H:00:00\") " + COL_START + ", " +
                "    SUM(" + COL_CATEGORY_1_AMOUNT + ") " + COL_CATEGORY_1_AMOUNT + ", " +
                "    SUM(" + COL_CATEGORY_2_AMOUNT + ") " + COL_CATEGORY_2_AMOUNT + ", " +
                "    SUM(" + COL_CATEGORY_3_AMOUNT + ") " + COL_CATEGORY_3_AMOUNT + ", " +
                "    SUM(" + COL_CATEGORY_4_AMOUNT + ") " + COL_CATEGORY_4_AMOUNT + ", " +
                "    SUM(" + COL_CATEGORY_5_AMOUNT + ") " + COL_CATEGORY_5_AMOUNT + ", " +
                "    SUM(" + COL_CATEGORY_6_AMOUNT + ") " + COL_CATEGORY_6_AMOUNT + ", " +
                "    SUM(" + COL_CATEGORY_1_SPEED + ") " + COL_CATEGORY_1_SPEED + ", " +
                "    SUM(" + COL_CATEGORY_2_SPEED + ") " + COL_CATEGORY_2_SPEED + ", " +
                "    SUM(" + COL_CATEGORY_3_SPEED + ") " + COL_CATEGORY_3_SPEED + ", " +
                "    SUM(" + COL_CATEGORY_4_SPEED + ") " + COL_CATEGORY_4_SPEED + ", " +
                "    SUM(" + COL_CATEGORY_5_SPEED + ") " + COL_CATEGORY_5_SPEED + ", " +
                "    SUM(" + COL_CATEGORY_6_SPEED + ") " + COL_CATEGORY_6_SPEED + " " +
                "FROM " +
                "    " + TABLE_NAME + " " +
                "WHERE " +
                "    " + COL_GID + " = ? AND " +
                "    DATE(" + COL_START + ") >= ? AND " +
                "    DATE(" + COL_START + ") < ? " +
                "GROUP BY " +
                "    DATE(" + COL_START + "), " +
                "    HOUR(" + COL_START + ") " +
                "ORDER BY " +
                "    DATE(" + COL_START + ") ASC, " +
                "    HOUR(" + COL_START + ") ASC; ";
    
        try( StatementManager sm = new StatementManager( dm ) )
        {
            PreparedStatement ps = sm.prepareStatement( sql );
        
            {
                int i = 0;
            
                ps.setInt( ++i, gid );
                ps.setString( ++i, dateStart );
                ps.setString( ++i, dateEnd );
            }
        
            ResultSet rs = ps.executeQuery();
        
            rows.addAll( AsimRow.getRows( rs ) );
        }
        catch( SQLException e )
        {
            OutputManager.getInstance().printException( e );
        }
    
        return rows;
    }
}
