package cz.vutbr.fit.rodos.db.tables;

import cz.vutbr.fit.rodos.db.DatabaseManager;
import cz.vutbr.fit.rodos.db.DatabaseTable;
import cz.vutbr.fit.rodos.db.StatementManager;
import cz.vutbr.fit.rodos.db.rows.AsimRow;
import cz.vutbr.fit.rodos.db.rows.GenericRow;
import general.io.OutputManager;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class GenericTable extends DatabaseTable
{
    private String tableName;
    
    private String detectorColumn;
    private String timeColumn;
    private String amountColumn;
    
    public GenericTable( DatabaseManager dm, String tableName, String detectorColumn, String rowTime, String rowAmount )
    {
        super( dm );
        
        
        this.detectorColumn = detectorColumn;
        this.tableName = tableName;
        this.timeColumn = rowTime;
        this.amountColumn = rowAmount;
    }
    
    public String getTableName()
    {
        return tableName;
    }
    
    public String getDetectorColumn()
    {
        return detectorColumn;
    }
    
    public String getTimeColumn()
    {
        return timeColumn;
    }
    
    public String getAmountColumn()
    {
        return amountColumn;
    }
    
    public List<GenericRow> getSumByHour( int detector, String timeStart, String timeEnd )
    {
        List<GenericRow> rows = new ArrayList<>();
    
        String sql = "" +
                "SELECT " +
                "    " + detectorColumn + ", " +
                "    DATE_FORMAT(" + timeColumn + ", \"%Y-%m-%d %H:00:00\") " + timeColumn + ", " +
                "    SUM(" + amountColumn + ") " + amountColumn + " " +
                "FROM " +
                "    " + tableName + " " +
                "WHERE " +
                "    " + detectorColumn + " = ? AND " +
                "    DATE(" + timeColumn + ") >= ? AND " +
                "    DATE(" + timeColumn + ") < ? " +
                "GROUP BY " +
                "    DATE(" + timeColumn + "), " +
                "    HOUR(" + timeColumn + ") " +
                "ORDER BY " +
                "    DATE(" + timeColumn + ") ASC, " +
                "    HOUR(" + timeColumn + ") ASC; ";
    
        try( StatementManager sm = new StatementManager( dm ) )
        {
            PreparedStatement ps = sm.prepareStatement( sql );
        
            {
                int i = 0;
            
                ps.setInt( ++i, detector );
                ps.setString( ++i, timeStart );
                ps.setString( ++i, timeEnd );
            }
        
            ResultSet rs = ps.executeQuery();
        
            rows.addAll( GenericRow.getRows( this, rs ) );
        }
        catch( SQLException e )
        {
            OutputManager.getInstance().printException( e );
        }
    
        return rows;
    }
}
