package libsvm;

public class SvmParameters implements Cloneable,java.io.Serializable
{
	/* svmType */
	public static final int SVM_TYPE_C_SVC = 0;
	public static final int SVM_TYPE_NU_SVC = 1;
	public static final int SVM_TYPE_ONE_CLASS = 2;
	public static final int SVM_TYPE_EPSILON_SVR = 3;
	public static final int SVM_TYPE_NU_SVR = 4;

	/* kernelType */
	public static final int KERNEL_TYPE_LINEAR = 0;
	public static final int KERNEL_TYPE_POLY = 1;
	public static final int KERNEL_TYPE_RBF = 2;
	public static final int KERNEL_TYPE_SIGMOID = 3;
	public static final int KERNEL_TYPE_PRECOMPUTED = 4;

	public int svmType;
	public int kernelType;
	public int degree;	// for poly
	public double gamma;	// for poly/rbf/sigmoid
	public double coef0;	// for poly/sigmoid

	// these are for training only
	public double cache_size; // in MB
	public double eps;	// stopping criteria
	public double C;	// for SVM_TYPE_C_SVC, SVM_TYPE_EPSILON_SVR and SVM_TYPE_NU_SVR
	public int nr_weight;		// for SVM_TYPE_C_SVC
	public int[] weight_label;	// for SVM_TYPE_C_SVC
	public double[] weight;		// for SVM_TYPE_C_SVC
	public double nu;	// for SVM_TYPE_NU_SVC, SVM_TYPE_ONE_CLASS, and SVM_TYPE_NU_SVR
	public double p;	// for SVM_TYPE_EPSILON_SVR
	public int shrinking;	// use the shrinking heuristics
	public int probability; // do probability estimates

	public SvmParameters()
	{
		this.svmType = SvmParameters.SVM_TYPE_C_SVC;
		this.kernelType = SvmParameters.KERNEL_TYPE_RBF;
		this.degree = 3;
		this.gamma = 0;	// 1/num_features
		this.coef0 = 0;
		this.nu = 0.5;
		this.cache_size = 100;
		this.C = 1;
		this.eps = 1e-3;
		this.p = 0.1;
		this.shrinking = 1;
		this.probability = 0;
		this.nr_weight = 0;
		this.weight_label = new int[0];
		this.weight = new double[0];
	}
	
	public Object clone() 
	{
		try 
		{
			return super.clone();
		} catch (CloneNotSupportedException e) 
		{
			return null;
		}
	}

}
