#!/usr/bin/env python3

import sys
import os

import src.clparser as clparser
import src.pcapparser as pcapparser
import src.method1 as method1
import src.method2 as method2
import src.method3 as method3
import src.globs as globs

def main():
    args = clparser.parse_arguments()

    sys.setrecursionlimit(100000)

    globs.fdir = os.path.abspath(os.path.dirname(__file__))
    os.makedirs(os.path.dirname(globs.fdir + "/output/"), exist_ok = True)

    if args.correct:
        try:
            commands = pcapparser.get_commands(args)
        except RuntimeError as err:
            sys.stderr.write("ERROR: %s\n" % str(err))
            return 1
        if len(commands) == 0:
            sys.stderr.write("ERROR: %s\n" % "No commands in pcaps found")
            return 2
        method1.train_correct(commands, args)
        method2.train_correct(commands, args)
        method3.train_correct(commands, args)
    if args.incorrect:
        try:
            commands = pcapparser.get_commands(args)
        except RuntimeError as err:
            sys.stderr.write("ERROR: %s\n" %  str(err))
            return 1
        if len(commands) == 0:
            sys.stderr.write("ERROR: %s\n" % "No commands in pcap found")
            return 2
        method1.train_incorrect(commands, args)
        method2.train_incorrect(commands, args)
        method3.train_incorrect(commands, args)
    if args.check:
        try:
            commands = pcapparser.get_commands(args)
        except RuntimeError as err:
            sys.stderr.write("ERROR: %s\n" % str(err))
            return 1
        if len(commands) == 0:
            sys.stderr.write("ERROR: %s\n" % "No commands in pcap found")
            return 2
        try:
            method1.check(commands, args)
        except RuntimeError as err:
            print(err)
        else:
            print("Method 1: Correct!")
        try:
            method2.check(commands, args)
        except RuntimeError as err:
            print(err)
        else:
            print("Method 2: Correct!")
        try:
            method3.check(commands, args)
        except RuntimeError as err:
            print(err)
        else:
            print("Method 3: Correct!")

if __name__ == "__main__":
    main()
