import argparse

def parse_arguments():
    parser = argparse.ArgumentParser(description = """Program for semiautomatic
                                                    protocol diagnostics""")
    group1 = parser.add_mutually_exclusive_group(required = True)
    group2 = parser.add_mutually_exclusive_group(required = True)
    group1.add_argument("--correct", dest = "correct",
                        action = "store_true", default = False, 
                        help = "Correct communication training mode")
    group1.add_argument("--incorrect", dest = "incorrect",
                        action = "store_true", default = False, 
                        help = "Incorrect communication training mode")
    group1.add_argument("--check", dest = "check", 
                        action = "store_true", default = False, 
                        help = "Communication checking mode")
    parser.add_argument("--maxlen", dest = "maxlen", default = 6, type = int,
                        help = "Maximum length of command in training mode")
    group2.add_argument("--idir", dest = "idir",
                        help = """Directory containing pcaps with correct 
                                communication""")
    group2.add_argument("--ifile", dest = "ifile",
                        help = "Pcap containing communication for diagnostics")
    parser.add_argument("--clientfield", dest = "clientfield", required = True,
                        nargs = "*", help = "Key in json containing requests")
    parser.add_argument("--serverfield", dest = "serverfield", required = True,
                        nargs = "*", help = "Key in json containing responses")
    parser.add_argument("--errmsg", dest = "errmsg",
                        help = "Error message for currently learned error type")
    parser.add_argument("--trid", dest = "trid", required = True,
                        help = "Identificator of training session")
    group1.add_argument("--json", dest = "json",
                        action = "store_true", default = False, 
                        help = "Input files are .json --- for debug only")

    args = parser.parse_args()

    if  ((args.correct and args.idir == None) or 
        (not args.correct and args.idir != None)):
        parser.error("arguments --correct and --idir must be given together")

    if  ((args.incorrect and args.ifile == None) or 
        (not args.incorrect and args.ifile != None and not args.check)):
        parser.error("argument --incorrect and --ifile must be given together")

    if  ((args.check and args.ifile == None) or 
        (not args.check and args.ifile != None and not args.incorrect)):
        parser.error("arguments --check and --ifile must be given together")

    if (args.maxlen != 6) and (not args.train):
        parser.error("argument --maxlen must be given with argument --correct")

    if  ((args.errmsg and not args.incorrect) or
        (not args.errmsg and args.incorrect)):
        parser.error("Argument --errmsg must be used with argument --incorrect")

    if (args.idir != None) and (args.idir[-1] != "/"):
        args.idir += "/"

    return args
