/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.ta.splaso;

import cz.vutbr.fit.ta.splaso.PlasoEntry;
import cz.vutbr.fit.ta.splaso.PlasoParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlasoTextParser
extends PlasoParser {
    @Override
    public List<PlasoEntry> parseInputStream(InputStream is) throws IOException {
        String line;
        Pattern p = Pattern.compile("^.*'([a-zA-Z_]+)':\\s+(.+)[\\,\\}]$");
        ArrayList<PlasoEntry> ret = new ArrayList<PlasoEntry>();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        PlasoEntry curEntry = null;
        Map<String, String> curMap = null;
        block8: while ((line = in.readLine()) != null) {
            switch (line = line.trim()) {
                case "Event:": {
                    if (curEntry != null) {
                        ret.add(curEntry);
                    }
                    curEntry = new PlasoEntry();
                    curMap = curEntry.getEvent();
                    continue block8;
                }
                case "Event data:": {
                    if (curEntry == null) continue block8;
                    curMap = curEntry.getEventData();
                    continue block8;
                }
            }
            Matcher m = p.matcher(line);
            if (!m.find()) continue;
            String key = m.group(1);
            String val = m.group(2);
            if (val == null || val.equals("None")) continue;
            if (val.startsWith("[u'")) {
                val = val.substring(3);
            } else if (val.startsWith("u'")) {
                val = val.substring(2);
            } else if (val.startsWith("'")) {
                val = val.substring(1);
            }
            if (val.endsWith("']")) {
                val = val.substring(0, val.length() - 2);
            } else if (val.endsWith("'")) {
                val = val.substring(0, val.length() - 1);
            }
            if (curMap == null) continue;
            curMap.put(key, val);
        }
        if (curEntry != null) {
            ret.add(curEntry);
        }
        return ret;
    }
}

