# -*- coding: utf-8 -*-

""" Test package for SMTP spacifics and e--mail detection """
# Copyright (C) 2018 Michal Orsák
#                    Libor Polčák
#                    Irena Talašová
#                    
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

def parametrizable_test(paramList):
    def wrap(fn):
        fn._parameters = paramList
        return fn
    return wrap


class parametrizable_tc_meta(type):
    def __new__(cls, name, bases, bodydict):
        def gen_test(origTest, params):
            def test(self):
                return origTest(self, *params)
            return test

        # names of tests to delete
        convertedTests = []
        # {name: test function}
        newTests = {}
        for name, test in bodydict.items():
            if name.startswith("test_") and hasattr(test, "_parameters"):
                convertedTests.append(name)
                for tname, params in test._parameters:
                    test_name = "%s_%s" % (name, tname)
                    assert test_name not in bodydict, test_name
                    newTests[test_name] = gen_test(test, params)
        # remove original test functions
        for t in convertedTests:
            del bodydict[t]
        # add new test functions
        bodydict.update(newTests)
        # continue with class creation
        return type.__new__(cls, name, bases, bodydict)
