// mnozina.cpp - implementation for mnozina
//

#include "stdafx.h"
#include "CESet.h"
#include "CEPNobj.h"
#include <algorithm>

////////////////////////////////////////////////////////////////////////////
// CSetConditions
IMPLEMENT_SERIAL(CSetConditions,CObject,1|VERSIONABLE_SCHEMA)

CSetConditions::CSetConditions()
{
}

CSetConditions::CSetConditions(CSetConditions& s)
{
	insert_iterator < SET_COND > ins_it(m_set,m_set.begin());
	copy(s.m_set.begin(),s.m_set.end(),ins_it);
}

void CSetConditions::Serialize(CArchive& ar)
{	// save and load
	ASSERT_VALID(this);

	CObject::Serialize(ar);
	if(ar.IsStoring())
	{
		int size;
		size=m_set.size();
		ar << size;
		CPNCondition* pCondition;
		SET_COND::iterator iter=m_set.begin();
		while(iter!=m_set.end())
		{
			pCondition=*iter;
			ar << pCondition;
			iter++;
		}
	}
	else
	{
		m_set.clear();
		int size;
		ar >> size;
		CPNCondition* pCondition;
		for(int i=0;i<size;i++)
		{
			ar >> pCondition;
			m_set.insert(pCondition);
		}
	}
}

void CSetConditions::Add(CPNCondition* pCondition)
{	// insert new element
	if(pCondition)m_set.insert(pCondition);
}

void CSetConditions::Reset()
{	// clear set
	m_set.clear();
}

bool CSetConditions::IsRealizable(CSetConditions& preset,CSetConditions& postset,bool forward)
{	// return whether is event whith preset and postset realizable in this set
	bool realizable;
	SET_COND res_set;
	insert_iterator < SET_COND > res_ins(res_set,res_set.begin());
	if(forward)
	{	// check forward realizable (normal)
		realizable=includes(m_set.begin(),m_set.end(),preset.m_set.begin(),preset.m_set.end());
		set_intersection(m_set.begin(),m_set.end(),postset.m_set.begin(),postset.m_set.end(),res_ins);
	}
	else
	{	// check backward realizable (for case class)
		realizable=includes(m_set.begin(),m_set.end(),postset.m_set.begin(),postset.m_set.end());
		set_intersection(m_set.begin(),m_set.end(),preset.m_set.begin(),preset.m_set.end(),res_ins);
	}
	realizable=realizable && res_set.empty();

	return realizable;
}

bool CSetConditions::Includes(CPNCondition* pcondition)
{	// return whether is pcondition included in this set
	return m_set.count(pcondition)==1;
}

bool CSetConditions::IsContact(CSetConditions& preset,CSetConditions& postset)
{	// zjisti, zda se udalost nachazi v aktualnim pripade v kontaktni situaci
	SET_COND cont_set;
	insert_iterator < SET_COND > cont_ins(cont_set,cont_set.begin());
	if(includes(m_set.begin(),m_set.end(),preset.m_set.begin(),preset.m_set.end()))
	{	// dopredne - udalost ma splneny preset
		set_intersection(m_set.begin(),m_set.end(),postset.m_set.begin(),postset.m_set.end(),cont_ins);
		if(!cont_set.empty())return true; // udalost ma splnenou i cast postsetu - kontakt
	}
	cont_set.clear();
	if(includes(m_set.begin(),m_set.end(),postset.m_set.begin(),postset.m_set.end()))
	{	// zpetne - udalost ma splneny postset
		set_intersection(m_set.begin(),m_set.end(),preset.m_set.begin(),preset.m_set.end(),cont_ins);
		if(!cont_set.empty())return true; // udalost ma splnenou i cast presetu - kontakt
	}
	return false;
}

void CSetConditions::Difference(CSetConditions& s)
{	// compute difference between this set and s
	SET_COND res_set;
	insert_iterator < SET_COND > res_ins(res_set,res_set.begin());
	set_difference(m_set.begin(),m_set.end(),s.m_set.begin(),s.m_set.end(),res_ins);

	Reset();
	insert_iterator < SET_COND > ins_it(m_set,m_set.begin());
	copy(res_set.begin(),res_set.end(),ins_it);
}

void CSetConditions::Union(CSetConditions& s)
{	// compute union with this set and s
	SET_COND res_set;
	insert_iterator < SET_COND > res_ins(res_set,res_set.begin());
	set_union(m_set.begin(),m_set.end(),s.m_set.begin(),s.m_set.end(),res_ins);

	Reset();
	insert_iterator < SET_COND > ins_it(m_set,m_set.begin());
	copy(res_set.begin(),res_set.end(),ins_it);
}

CSetConditions CSetConditions::Intersect(CSetConditions& s)
{
	CSetConditions aux_set;
	insert_iterator < SET_COND > aux_ins(aux_set.m_set,aux_set.m_set.begin());
	set_intersection(m_set.begin(),m_set.end(),s.m_set.begin(),s.m_set.end(),aux_ins);
	return aux_set;
}

CSetConditions& CSetConditions::operator=(const CSetConditions& s)
{	// copy s to this set
	Reset();
	insert_iterator < SET_COND > ins_it(m_set,m_set.begin());
	copy(s.m_set.begin(),s.m_set.end(),ins_it);
	return *this;
}

bool CSetConditions::operator==(const CSetConditions& s)
{	// compare this set and s
/*	bool equal=(m_set.size()==s.m_set.size());
	if(equal)
	{
		SET_COND::iterator iter=m_set.begin();
		while((iter!=m_set.end()) && equal)
		{
			equal=equal && (s.m_set.count(*iter)==1);
			iter++;
		}
	}*/
	bool equal=(m_set.size()==s.m_set.size());
	if(equal)
	{
		CSetConditions aux_set;
		insert_iterator < SET_COND > aux_ins(aux_set.m_set,aux_set.m_set.begin());
		set_symmetric_difference(m_set.begin(),m_set.end(),s.m_set.begin(),s.m_set.end(),aux_ins);
		equal=aux_set.IsEmpty();
	}
	return equal;
}

CString	CSetConditions::Format(int type/*=FORMAT_TOGETHER*/)
{	// return formated names of elements in this set
	CString text;

	if(type==FORMAT_TOGETHER)text="{";

	bool first=true;
	CPNLabel* pLabel;
	SET_COND ::iterator iter=m_set.begin();
	while(iter!=m_set.end())
	{
		pLabel=dynamic_cast<CPNLabel*>((*iter)->GetLabel());
		iter++;
		if(pLabel)
		{
			if(!first)text+=",";
			if((type==FORMAT_TOGETHER) || (!first))text+=" ";
//			if(type==FORMAT_INDIVIDUAL)text+="{ ";
			text+=pLabel->GetText();
//			if(type==FORMAT_INDIVIDUAL)text+=" }";
			first=false;
		}
	}
	if(!first)text+=" ";
	if(type==FORMAT_TOGETHER)text+="}";

	return text;
}

bool CSetConditions::IsEmpty()
{
	return m_set.empty();
}

void CSetConditions::InitIteration()
{
	m_iterator=m_set.begin();
}

CPNCondition* CSetConditions::NextIteration()
{
	CPNCondition* pCondition=NULL;
	if(m_iterator!=m_set.end())
	{
		pCondition=(*m_iterator);
		m_iterator++;
	}
	return pCondition;
}

////////////////////////////////////////////////////////////////////////////
// CSetEvents
IMPLEMENT_SERIAL(CSetEvents,CObject,1|VERSIONABLE_SCHEMA)

CSetEvents::CSetEvents()
{
}

CSetEvents::CSetEvents(CSetEvents& s)
{
	insert_iterator < SET_EVENT > ins_it(m_set,m_set.begin());
	copy(s.m_set.begin(),s.m_set.end(),ins_it);
}

void CSetEvents::Serialize(CArchive& ar)
{	// save and load
	ASSERT_VALID(this);

	CObject::Serialize(ar);
	if(ar.IsStoring())
	{
		int size;
		size=m_set.size();
		ar << size;
		CPNEvent* pEvent;
		SET_EVENT::iterator iter=m_set.begin();
		while(iter!=m_set.end())
		{
			pEvent=*iter;
			ar << pEvent;
			iter++;
		}
	}
	else
	{
		m_set.clear();
		int size;
		ar >> size;
		CPNEvent* pEvent;
		for(int i=0;i<size;i++)
		{
			ar >> pEvent;
			m_set.insert(pEvent);
		}
	}
}

void CSetEvents::Add(CPNEvent* pEvent)
{	// insert new element
	if(pEvent)m_set.insert(pEvent);
}

void CSetEvents::Union(CSetEvents& s)
{	// compute union with this set and s
	SET_EVENT res_set;
	insert_iterator < SET_EVENT > res_ins(res_set,res_set.begin());
	set_union(m_set.begin(),m_set.end(),s.m_set.begin(),s.m_set.end(),res_ins);

	Reset();
	insert_iterator < SET_EVENT > ins_it(m_set,m_set.begin());
	copy(res_set.begin(),res_set.end(),ins_it);
}

void CSetEvents::Reset()
{	// clear set
	m_set.clear();
}

CSetEvents& CSetEvents::operator=(const CSetEvents& s)
{	// copy s to this set
	Reset();
	insert_iterator < SET_EVENT > ins_it(m_set,m_set.begin());
	copy(s.m_set.begin(),s.m_set.end(),ins_it);
	return *this;
}

bool CSetEvents::operator==(const CSetEvents& s)
{	// compare this set and s
/*	bool equal=(m_set.size()==s.m_set.size());
	if(equal)
	{
		SET_EVENT::iterator iter=m_set.begin();
		while(iter!=m_set.end())
		{
			equal=equal && (s.m_set.count(*iter)==1);
			iter++;
		}
	}*/
	bool equal=(m_set.size()==s.m_set.size());
	if(equal)
	{
		CSetEvents aux_set;
		insert_iterator < SET_EVENT > aux_ins(aux_set.m_set,aux_set.m_set.begin());
		set_symmetric_difference(m_set.begin(),m_set.end(),s.m_set.begin(),s.m_set.end(),aux_ins);
		equal=aux_set.IsEmpty();
	}
	return equal;
}

bool CSetEvents::IsEmpty()
{
	return m_set.empty();
}

CString	CSetEvents::Format()
{	// return formated names of elements in this set
	CString text;

	text="{ ";
	bool first=true;
	CPNLabel* pLabel;
	SET_EVENT::iterator iter=m_set.begin();
	while(iter!=m_set.end())
	{
		pLabel=dynamic_cast<CPNLabel*>((*iter)->GetLabel());
		iter++;
		if(pLabel)
		{
			if(!first)text+=", ";
			text+=pLabel->GetText();
			first=false;
		}
	}
	if(!first)text+=" ";
	text+="}";

	return text;
}

void CSetEvents::InitIteration()
{
	m_iterator=m_set.begin();
}

CPNEvent* CSetEvents::NextIteration()
{
	CPNEvent* pEvent=NULL;
	if(m_iterator!=m_set.end())
	{
		pEvent=(*m_iterator);
		m_iterator++;
	}
	return pEvent;
}

////////////////////////////////////////////////////////////////////////////
// CSetCases
IMPLEMENT_SERIAL(CSetCases,CObject,1|VERSIONABLE_SCHEMA)

CSetCases::CSetCases()
{
}

CSetCases::CSetCases(CSetCases& s)
{
	insert_iterator < SET_CASE > ins_it(m_set,m_set.begin());
	copy(s.m_set.begin(),s.m_set.end(),ins_it);
}

void CSetCases::Add(CPNCase* pCase)
{	// insert new element
	if(pCase)m_set.insert(pCase);
}

void CSetCases::Reset()
{	// clear set
	m_set.clear();
}

bool CSetCases::IsEmpty()
{
	return m_set.empty();
}

CSetCases& CSetCases::operator=(const CSetCases& s)
{	// copy s to this set
	Reset();
	insert_iterator < SET_CASE > ins_it(m_set,m_set.begin());
	copy(s.m_set.begin(),s.m_set.end(),ins_it);
	return *this;
}

bool CSetCases::operator==(const CSetCases& s)
{	// compare this set and s
/*	bool equal=(m_set.size()==s.m_set.size());
	if(equal)
	{
		SET_EVENT::iterator iter=m_set.begin();
		while(iter!=m_set.end())
		{
			equal=equal && (s.m_set.count(*iter)==1);
			iter++;
		}
	}*/
	bool equal=(m_set.size()==s.m_set.size());
	if(equal)
	{
		CSetCases aux_set;
		insert_iterator < SET_CASE> aux_ins(aux_set.m_set,aux_set.m_set.begin());
		set_symmetric_difference(m_set.begin(),m_set.end(),s.m_set.begin(),s.m_set.end(),aux_ins);
		equal=aux_set.IsEmpty();
	}
	return equal;
}

CString	CSetCases::Format(int style)
{	// return formated names of elements in this set
	CString text;

	text="{ ";
	bool first=true;
	SET_CASE::iterator iter=m_set.begin();
	while(iter!=m_set.end())
	{
		if(!first)text+=", ";
		if(style == STYLE_CONDITIONS)
			text+=(*iter)->GetCaseStr();
		else
			text+=(*iter)->GetText();
		first=false;
		iter++;
	}
	if(!first)text+=" ";
	text+="}";

	return text;
}
