// Mnozina.h - interface for CMnozina
//

#ifndef __MYSET_H__
#define __MYSET_H__

#include <set>

using namespace std;

// forward declarations
class CPNCondition;
class CPNEvent;
class CPNLabel;
class CPNCase;

/////////////////////////////////////////////////////////////////////////////
// CSetConditions
class CSetConditions : public CObject
{
public:
	enum { FORMAT_TOGETHER, FORMAT_INDIVIDUAL };

	DECLARE_SERIAL(CSetConditions);
	virtual void Serialize(CArchive& ar);

	CSetConditions();
	CSetConditions(CSetConditions& s);
	void Add(CPNCondition* pcondition);
	void Reset();
	void Difference(CSetConditions& s);
	void Union(CSetConditions& s);
	CSetConditions Intersect(CSetConditions& s);
	bool IsRealizable(CSetConditions& preset,CSetConditions& postset,bool forward);
	bool IsContact(CSetConditions& preset,CSetConditions& postset);
	bool Includes(CPNCondition* pcondition);
	bool IsEmpty();
	bool operator==(const CSetConditions& s);
	CSetConditions& operator=(const CSetConditions& s);
	CString Format(int type=FORMAT_TOGETHER);
	void InitIteration();
	CPNCondition* NextIteration();

private:
	typedef set < CPNCondition* > SET_COND;
	SET_COND m_set;
	SET_COND::iterator m_iterator;
};

/////////////////////////////////////////////////////////////////////////////
// CSetEvents
class CSetEvents : public CObject
{
public:
	DECLARE_SERIAL(CSetEvents);
	virtual void Serialize(CArchive& ar);

	CSetEvents();
	CSetEvents(CSetEvents& s);
	void Add(CPNEvent* pevent);
	void Union(CSetEvents& s);
	void Reset();
	CString Format();
	bool IsEmpty();
	bool operator==(const CSetEvents& s);
	CSetEvents& operator=(const CSetEvents& s);
	void InitIteration();
	CPNEvent* NextIteration();
	int GetLength()	{ return m_set.size(); }

private:
	typedef set < CPNEvent* > SET_EVENT;
	SET_EVENT m_set;
	SET_EVENT::iterator m_iterator;
};

/////////////////////////////////////////////////////////////////////////////
// CSetCases
class CSetCases : public CObject
{
public:
	DECLARE_SERIAL(CSetCases);

	enum { STYLE_CONDITIONS, STYLE_CASES };

	CSetCases();
	CSetCases(CSetCases& s);
	void Add(CPNCase* pCase);
	void Reset();
	CString Format(int style=STYLE_CASES);
	bool IsEmpty();
	bool operator==(const CSetCases& s);
	CSetCases& operator=(const CSetCases& s);

private:
	typedef set < CPNCase* > SET_CASE;
	SET_CASE m_set;
	SET_CASE::iterator m_iterator;
};

#endif
