// CESimDoc.cpp : implementation of the CCESimDoc class
//

#include "stdafx.h"
#include "CESim.h"
#include "MainFrm.h"
#include "CESimDoc.h"
#include <time.h>
#include "DlgCaseClassAnalysis.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCESimDoc
IMPLEMENT_DYNCREATE(CCESimDoc, CDocument)

BEGIN_MESSAGE_MAP(CCESimDoc, CDocument)
	//{{AFX_MSG_MAP(CCESimDoc)
	ON_COMMAND(ID_ANALYSIS_WRITEOUTCASECLASS, OnAnalysisWriteoutcaseclass)
	ON_UPDATE_COMMAND_UI(ID_ANALYSIS_WRITEOUTCASECLASS, OnUpdateAnalysisWriteoutcaseclass)
	ON_COMMAND(ID_SIMULATION_ENTERSIMULATIONMODE, OnSimulationEntersimulationmode)
	ON_UPDATE_COMMAND_UI(ID_SIMULATION_ENTERSIMULATIONMODE, OnUpdateSimulationEntersimulationmode)
	ON_COMMAND(ID_SIMULATION_LEAVESIMULATIONMODE, OnSimulationLeavesimulationmode)
	ON_UPDATE_COMMAND_UI(ID_SIMULATION_LEAVESIMULATIONMODE, OnUpdateSimulationLeavesimulationmode)
	ON_COMMAND(ID_SIMULATION_SETBREAKPOINTS, OnSimulationSetbreakpoints)
	ON_UPDATE_COMMAND_UI(ID_SIMULATION_SETBREAKPOINTS, OnUpdateSimulationSetbreakpoints)
	ON_COMMAND(ID_ANALYSIS_CASECLASSVERIFICATION, OnAnalysisCaseclassverification)
	ON_UPDATE_COMMAND_UI(ID_ANALYSIS_CASECLASSVERIFICATION, OnUpdateAnalysisCaseclassverification)
	ON_COMMAND(ID_CASEGRAPH_EXPORTCASECLASS, OnCasegraphExportcaseclass)
	ON_UPDATE_COMMAND_UI(ID_CASEGRAPH_EXPORTCASECLASS, OnUpdateCasegraphExportcaseclass)
	ON_COMMAND(ID_NETDESIGN_EXPORTTOXML, OnNetdesignExporttoxml)
	ON_COMMAND(ID_CASEGRAPH_EXPORTTOXML, OnCasegraphExporttoxml)
	ON_UPDATE_COMMAND_UI(ID_CASEGRAPH_EXPORTTOXML, OnUpdateCasegraphExporttoxml)
	ON_COMMAND(ID_OCCURRENCENET_EXPORTTOXML, OnOccurrenceNetExporttoxml)
	ON_UPDATE_COMMAND_UI(ID_OCCURRENCENET_EXPORTTOXML, OnUpdateOccurrenceNetExporttoxml)
	ON_UPDATE_COMMAND_UI(ID_NETDESIGN_EXPORTTOXML, OnUpdateNetdesignExporttoxml)
	ON_COMMAND(ID_ANALYSIS_COMPUTEALLREACHABLECASES, OnAnalysisComputeallreachablecases)
	ON_UPDATE_COMMAND_UI(ID_ANALYSIS_COMPUTEALLREACHABLECASES, OnUpdateAnalysisComputeallreachablecases)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCESimDoc construction/destruction

CCESimDoc::CCESimDoc()
{
	m_version=VERSION;
	m_old_occurrence_net=false;
	m_token_animation_delay=25;
	m_tkn_pen.CreatePen(PS_SOLID,1,TKN_CLR);
	m_tkn_brush.CreateSolidBrush(TKN_CLR);
}

CCESimDoc::~CCESimDoc()
{
}

BOOL CCESimDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	m_version=VERSION;
	m_loaded_from_file=false;
	m_case_graph_initialized=FALSE;
	m_can_show_case_graph=FALSE;
	m_can_show_occurrence_net=FALSE;
//	m_occurrence_net_placed=false;
	m_net_modified=TRUE;
	m_view_ruler=FALSE;
	m_view_grid=TRUE;
	m_grid_span=10;
	m_cnt_text_case_graph=m_cnt_condition=m_cnt_event=m_cnt_text=1;
	m_simulation_mode=false;
	m_token_is_animating=false;
	m_token_index=0;

	srand((unsigned)time(NULL));

	return TRUE;
}

void CCESimDoc::DeleteContents() 
{
	m_cnt_text_case_graph=m_cnt_condition=m_cnt_event=m_cnt_text=1;
	// delete selected list
	m_selected_elements.RemoveAll();
	// delete all elements
	m_net_design.DeleteContents(); 
	// delete edge list
	m_animate_edge_list.RemoveAll();
	m_simulation_mode=false;
	m_token_is_animating=false;
	m_token_index=0;
	// case graph
	m_case_graph.DeleteContents();
	// occurrence net
	m_occurrence_net.DeleteContents();

	CMainFrame* pFrame=(CMainFrame*)AfxGetApp()->m_pMainWnd;
	if(pFrame!=NULL)pFrame->Reset();
	
	CDocument::DeleteContents();
}

/////////////////////////////////////////////////////////////////////////////
// CCESimDoc serialization
void CCESimDoc::Serialize(CArchive& ar)
{
	if(ar.IsStoring())
	{
		ar << m_version;
		if(m_net_modified)
		{	// neukladat neplatnou sit
			m_case_graph.DeleteContents();
			m_occurrence_net.DeleteContents();
		}
		if(m_simulation_mode)
			ar << m_old_view_grid;
		else
			ar << m_view_grid;
//		ar << m_view_ruler;
		ar << m_grid_span;

		/////////// NEUKLADAT
		ar << m_net_modified;

		ar << m_case_graph_initialized;
		ar << m_can_show_case_graph;
		ar << m_can_show_occurrence_net;
		ar << m_cnt_condition;
		ar << m_cnt_event;
		ar << m_cnt_text;
		ar << m_cnt_text_case_graph;
//		ar << ;
	}
	else
	{
		// pridano 7.3.2004
		ar >> m_version;
		if(m_version!=VERSION)AfxThrowArchiveException(CArchiveException::badSchema);

		ar >> m_view_grid;
//		ar >> m_view_ruler;
		ar >> m_grid_span;

		/////////// NENACITAT
		ar >> m_net_modified;

		ar >> m_case_graph_initialized;
		ar >> m_can_show_case_graph;
		ar >> m_can_show_occurrence_net;
		ar >> m_cnt_condition;
		ar >> m_cnt_event;
		ar >> m_cnt_text;
		ar >> m_cnt_text_case_graph;
//		ar >> ;

		m_loaded_from_file=true;
		m_case_graph_loaded=true;
		m_old_occurrence_net=true;
	}
	m_net_design.Serialize(ar);
	m_case_graph.Serialize(ar);
	m_occurrence_net.Serialize(ar);
}

/////////////////////////////////////////////////////////////////////////////
// CCESimDoc diagnostics
#ifdef _DEBUG
void CCESimDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CCESimDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCESimDoc commands
void CCESimDoc::NetDesign_Draw(CDC* pDC)
{	// draw all elements on pDC
	m_net_design.Draw(pDC);
	if(m_simulation_mode && m_token_is_animating)
	{	// token animation
		CPNEdge* pEdge;
		POSITION pos=m_animate_edge_list.GetHeadPosition();
		m_old_pen=pDC->SelectObject(&m_tkn_pen);
		m_old_brush=pDC->SelectObject(&m_tkn_brush);
		while(pos!=NULL)
		{
			pEdge=m_animate_edge_list.GetNext(pos);


//			for(int i=0;i<CPNEdge::TOKEN_PATH_POINTS;i++)
			{
//				CPoint point=pEdge->GetTokenPathPoint(i);
				CPoint point=pEdge->GetTokenPathPoint(m_token_index);

/*				if(point.x==508)
				{
					CString str;
					str.Format("Vadn bod: %d %d",m_token_index,point.x);
					MessageBox(NULL,str,"",MB_OK);
				}*/

				pDC->Ellipse(point.x-TKN_RDS,point.y-TKN_RDS,point.x+TKN_RDS,point.y+TKN_RDS);
			}
		}
		pDC->SelectObject(m_old_pen);
		pDC->SelectObject(m_old_brush);
	}
}

CRect CCESimDoc::NetDesign_PlaceSelectedElements(int position)
{	// place elements to back or front of all selected elements
	CRect invalid_rect=m_net_design.PlaceSelectedElements(position==PLACE_BACK,m_selected_elements);
	SetModifiedFlag();
	return invalid_rect;
}

CRect CCESimDoc::CaseGraph_PlaceSelectedElements(int position)
{	// place elements to back or front of all selected elements
	CRect invalid_rect=m_case_graph.PlaceSelectedElements(position==PLACE_BACK,m_selected_elements);
	SetModifiedFlag();
	return invalid_rect;
}

CRect CCESimDoc::OccurrenceNet_PlaceSelectedElements(int position)
{	// place elements to back or front of all selected elements
	CRect invalid_rect=m_occurrence_net.PlaceSelectedElements(position==PLACE_BACK,m_selected_elements);
	SetModifiedFlag();
	return invalid_rect;
}

bool CCESimDoc::NetDesign_AddElement(CPNElement* pElement)
{	// add new element
	bool add=m_net_design.AddElement(pElement);
	if(add)SetModifiedFlag();
	return add;
}

void CCESimDoc::CaseGraph_AddElement(CPNElement* pElement)
{	// add new user element to case graph
	m_case_graph.m_elements_list.AddTail(pElement);
	SetModifiedFlag();
}

void CCESimDoc::OccurrenceNet_AddElement(CPNElement* pElement)
{	// add new user element to case graph
	m_occurrence_net.AddElement(pElement);
	SetModifiedFlag();
}

bool CCESimDoc::NetDesign_CanRemoveElements()
{	// nesmi jit vymazat samostatne oznacene label od eventu nebo od condition
	CPNLabel* pLabel;
	CPNElement* pElement;
	POSITION pos=m_selected_elements.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_selected_elements.GetNext(pos);
		if(dynamic_cast<CPNEdge*>(pElement))return true;
		if(dynamic_cast<CPNEvent*>(pElement))return true;
		if(dynamic_cast<CPNCondition*>(pElement))return true;
		if(dynamic_cast<CPNPolygon*>(pElement))return true;
		pLabel=dynamic_cast<CPNLabel*>(pElement);
		if(pLabel)if(pLabel->GetOwner()==NULL)return true;
	}
	return false;
}

bool CCESimDoc::CaseGraph_CanRemoveElements()
{	// vymazat lze pouze uzivatelem pridane objekty
	CPNElement* pElement;
	POSITION pos=m_case_graph.m_elements_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_case_graph.m_elements_list.GetNext(pos);
		if(IsElementSelected(pElement))return true;
	}
	return false;
}

bool CCESimDoc::OccurrenceNet_CanRemoveElements()
{	// vymazat lze pouze uzivatelem pridane objekty
	CPNElement* pElement;
	POSITION pos=m_occurrence_net.m_user_element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_occurrence_net.m_user_element_list.GetNext(pos);
		if(IsElementSelected(pElement))return true;
	}
	return false;
}

CRect CCESimDoc::NetDesign_RemoveSelectedElements()
{
	CRect invalid_rect;
	invalid_rect=m_net_design.RemoveSelectedElements(m_selected_elements);
	SetModifiedFlag();
	return invalid_rect;
}

CRect CCESimDoc::CaseGraph_RemoveSelectedElements()
{	// vymazou se jenom uzivatelem pridane objekty, ostatni se jen odznaci
	POSITION oldpos,rm_pos;
	CPNElement* pElement;
	CRect invalid_rect,tmp_rect;
	tmp_rect.SetRectEmpty();
	POSITION pos=m_case_graph.m_elements_list.GetHeadPosition();
	while(pos!=NULL)
	{
		oldpos=pos;
		pElement=m_case_graph.m_elements_list.GetNext(pos);
		if(IsElementSelected(pElement))
		{
			// remove element from selected elements
			rm_pos=m_selected_elements.Find(pElement);
			m_selected_elements.RemoveAt(rm_pos);
			// delete element
			m_case_graph.m_elements_list.RemoveAt(oldpos);
			invalid_rect.UnionRect(tmp_rect,pElement->GetRect());
			tmp_rect=invalid_rect;
			delete pElement;
			// iterate again
			pos=m_case_graph.m_elements_list.GetHeadPosition();
		}
	}
	invalid_rect.UnionRect(tmp_rect,DeselectAllElements());
	SetModifiedFlag();
	return invalid_rect;
}

CRect CCESimDoc::OccurrenceNet_RemoveSelectedElements()
{	// vymazou se jenom uzivatelem pridane objekty, ostatni se jen odznaci
	POSITION oldpos,rm_pos;
	CPNElement* pElement;
	CRect invalid_rect,tmp_rect;
	tmp_rect.SetRectEmpty();
	POSITION pos=m_occurrence_net.m_user_element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		oldpos=pos;
		pElement=m_occurrence_net.m_user_element_list.GetNext(pos);
		if(IsElementSelected(pElement))
		{
			// remove element from selected elements
			rm_pos=m_selected_elements.Find(pElement);
			m_selected_elements.RemoveAt(rm_pos);
			// delete element
			m_occurrence_net.m_user_element_list.RemoveAt(oldpos);
			invalid_rect.UnionRect(tmp_rect,pElement->GetRect());
			tmp_rect=invalid_rect;
			delete pElement;
			// iterate again
			pos=m_occurrence_net.m_user_element_list.GetHeadPosition();
		}
	}
	invalid_rect.UnionRect(tmp_rect,DeselectAllElements());
	SetModifiedFlag();
	return invalid_rect;
}

CString CCESimDoc::GetAutomaticLabelText(int element_type)
{	// return text for next label of new element
	CString text;
	switch(element_type)
	{
	case LABEL_CONDITION:
		text.Format("b%d",m_cnt_condition++);
		break;
	case LABEL_EVENT:
		text.Format("e%d",m_cnt_event++);
		break;
	case LABEL_TEXT_NET_DESIGN:
		text.Format("Text%d",m_cnt_text++);
		break;
	case LABEL_TEXT_CASE_GRAPH:
		text.Format("Text%d",m_cnt_text_case_graph++);
		break;
	default:
		ASSERT(FALSE);
		break;
	}
	return text;
}

bool CCESimDoc::IsElementSelected(CPNElement* pElement/*=NULL*/)
{
	if(pElement==NULL)return !m_selected_elements.IsEmpty(); // test if we have selected any element
	return (m_selected_elements.Find(pElement)!=NULL);
}

bool CCESimDoc::IsMultiselect()
{
	return m_selected_elements.GetCount()>1;
}

CRect CCESimDoc::DeselectAllElements()
{
	CPNElement* pElement;
	CRect sel_rect,tmp_rect;
	sel_rect.SetRectEmpty();
	tmp_rect.SetRectEmpty();
	POSITION pos=m_selected_elements.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_selected_elements.GetNext(pos);
		pElement->Select(false);
		sel_rect.UnionRect(tmp_rect,pElement->GetRect());
		tmp_rect=sel_rect;
	}
	m_selected_elements.RemoveAll();
	return sel_rect;
}

CPNElement* CCESimDoc::GetFirstSelectedElement()
{
	if(m_selected_elements.IsEmpty())return NULL;
	return m_selected_elements.GetHead();
}

CRect CCESimDoc::SelectElement(CPNElement* pElement,bool multiselect/*=false*/)
{
	CRect old_sel_rect;
	old_sel_rect.SetRectEmpty();
	if(!multiselect)old_sel_rect=DeselectAllElements();
	pElement->Select();
	m_selected_elements.AddTail(pElement);
	CRect invalid_rect;
	invalid_rect.UnionRect(old_sel_rect,pElement->GetRect());
	return invalid_rect;
}

CRect CCESimDoc::NetDesign_SelectElements(CRect& rect)
{	// select elements with in rect
	CRect old_sel_rect;
	old_sel_rect=DeselectAllElements();
	CRect sel_rect;
	sel_rect=m_net_design.SelectElements(rect,m_simulation_mode,m_selected_elements);
	CRect invalid_rect;
	invalid_rect.UnionRect(old_sel_rect,sel_rect);
	return invalid_rect;
}

CRect CCESimDoc::OccurrenceNet_SelectElements(CRect& rect)
{	// select elements with in rect
	CRect old_sel_rect;
	old_sel_rect=DeselectAllElements();
	CRect sel_rect;
	sel_rect=m_occurrence_net.SelectElements(rect,m_selected_elements);
	CRect invalid_rect;
	invalid_rect.UnionRect(old_sel_rect,sel_rect);
	return invalid_rect;
}

CRect CCESimDoc::CaseGraph_SelectElements(CRect& rect)
{	// select elements with in rect
	CRect old_sel_rect;
	old_sel_rect=DeselectAllElements();
	CRect sel_rect;
	sel_rect=m_case_graph.SelectElements(rect,m_selected_elements);
	CRect invalid_rect;
	invalid_rect.UnionRect(old_sel_rect,sel_rect);
	return invalid_rect;
}

CRect CCESimDoc::MoveSelectedElementsByVector(CSize move)
{
	CRect invalid_rect,tmp_rect;
	invalid_rect.SetRectEmpty();
	tmp_rect=invalid_rect;
	CPoint position;
	CPNEdge* pEdge;
	CPNPolygon* pPolygon;
	CPNLabel* pLabel;
	CPNElement* pElement;
	CPNElement* pOwnerElement;
	POSITION pos=m_selected_elements.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_selected_elements.GetNext(pos);
		pLabel=dynamic_cast<CPNLabel*>(pElement);
		if(pLabel)
		{
			pOwnerElement=pLabel->GetOwner();
			if(pOwnerElement)
			{	// pokud ma label vlastnika, ktery je take oznace, pohne si s label sam kdyz se bude hybat s nim
				if(IsElementSelected(pOwnerElement))continue;
			}
		}
		pEdge=dynamic_cast<CPNEdge*>(pElement);
		if(pEdge)
		{
			invalid_rect.UnionRect(tmp_rect,pEdge->MoveByVector(move));
			tmp_rect=invalid_rect;
			continue;
		}
		pPolygon=dynamic_cast<CPNPolygon*>(pElement);
		if(pPolygon)
		{
			invalid_rect.UnionRect(tmp_rect,pPolygon->MoveByVector(move));
			tmp_rect=invalid_rect;
			continue;
		}
		position=pElement->GetPosition();
		position=position+move;
		invalid_rect.UnionRect(tmp_rect,pElement->MoveTo(position));
		tmp_rect=invalid_rect;
	}
	return invalid_rect;
}

CRect CCESimDoc::DeselectElement(CPNElement* pElement)
{
	pElement->Select(false);
	POSITION pos=m_selected_elements.Find(pElement);
	if(pos)m_selected_elements.RemoveAt(pos);
	return pElement->GetRect();
}

CPNElement* CCESimDoc::SelectedDraggedEdgeAt(const CPoint& point)
{	// vrati hranu, pokud se klikne na pretahovaci bod oznacene hrany
	CPNEdge* pEdge;
	CPNElement* pElement;
	POSITION pos=m_selected_elements.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_selected_elements.GetNext(pos);
		pEdge=dynamic_cast<CPNEdge*>(pElement);
		if(pEdge)
		{
			if(pEdge->IsDragging(point))return pElement;
		}
	}
	return NULL;
}

void CCESimDoc::SetNetModified()
{	// zmenila se struktura site (ne pozice prvku)
	m_net_modified=TRUE;
	m_case_graph_initialized=FALSE;
	m_can_show_case_graph=FALSE;
	m_can_show_occurrence_net=FALSE;
//	m_occurrence_net_placed=false;
}

void CCESimDoc::OnSimulationEntersimulationmode() 
{
	if(m_simulation_mode)return;
	CWaitCursor wait;
	ASSERT((CMainFrame*)AfxGetApp()->m_pMainWnd);
	((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowOutputBar(); // show output window
	((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_HIDE);
	// output document info
	CString str;
	str="--------------------Document: ";
	str+=GetTitle();
	str+="--------------------";
	_AddOutputListString(OUTPUT_STANDARD,str);
	DeselectAllElements();
	bool net_was_modified=m_net_modified!=0;
	if(m_net_modified)
	{	// try enter simulation mode
		m_case_graph.DeleteContents(false);
		m_simulation_mode=EnterSimulation();
		if(m_simulation_mode)
		{
			m_net_modified=FALSE;
			m_case_graph_initialized=FALSE;
			m_can_show_case_graph=TRUE;
//			m_occurrence_net_placed=false;

			// 31.3.2006 opravena chyba spatne podminky pro moznost zobrazeni vyskytove site
			m_can_show_occurrence_net=m_case_graph.IsContactFree(); // ptame se, zda je system bezkontaktni
			if(m_can_show_occurrence_net)
				str="System is contact-free";
			else
				str="System is not contact-free";
			_AddOutputListString(OUTPUT_STANDARD,str);
		}
	}
	else
	{	// sit nebyla zmenena
		if(m_loaded_from_file)
		{
			m_loaded_from_file=false;
			m_initial_case=m_net_design.ComputeElementsSets();
			m_actual_case=m_initial_case;
		}
//		else

			// ZMENIT, VOLAT JEN KDYZ SE ZMENILA POZICE HRAN

			m_net_design.UpdateTokensPath();

		m_simulation_mode=true;
		_AddOutputListString(OUTPUT_STANDARD,"Entering simulation...");
	}
	if(m_simulation_mode)
	{
		((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_SIMULATION);
		m_old_view_grid=m_view_grid;
		m_view_grid=false;
		CaseGraph_HighlightActCase();
		// update for realizable events
		UpdateEvents();
		if(net_was_modified)
		{
			m_occurrence_net.DeleteContents();
			if(m_can_show_case_graph)
			{
				m_occurrence_net.Init(m_net_design.m_element_list);
				m_occurrence_net.AddInitialCase(m_initial_case);
			}
			m_dlg_breakpoints.InvalidCaseClass();
		}
		m_old_occurrence_net=!net_was_modified;
	}
	else
		m_net_design.ClearNet();
	UpdateAllViews(NULL);
}

void CCESimDoc::OnUpdateSimulationEntersimulationmode(CCmdUI* pCmdUI) 
{
//	pCmdUI->Enable(true);
	pCmdUI->Enable(!m_simulation_mode);
//	pCmdUI->SetRadio(m_simulation_mode);
}

void CCESimDoc::OnSimulationLeavesimulationmode() 
{
	if(!m_simulation_mode)return;
	LeaveSimulation();
}

void CCESimDoc::OnUpdateSimulationLeavesimulationmode(CCmdUI* pCmdUI) 
{
//	pCmdUI->Enable(true);
	pCmdUI->Enable(m_simulation_mode);
//	pCmdUI->SetRadio(!m_simulation_mode);
}

bool CCESimDoc::EnterSimulation()
{
	// prepare net for simulation
	m_initial_case=m_net_design.ComputeElementsSets();
	m_actual_case=m_initial_case;
	// compute case graph
	CString out_str;
	_AddOutputListString(OUTPUT_STANDARD,"Computing case graph...");
	m_case_graph.ComputeCaseGraph(m_initial_case,m_net_design.m_element_list);
	m_case_graph.ComputeReach(m_initial_case);
	out_str.Format("Total %d case(s), %d step(s)",m_case_graph.m_nCases,m_case_graph.m_nSteps);
	_AddOutputListString(OUTPUT_STANDARD,out_str);
	out_str="Initial case: ";
	out_str+=m_initial_case.Format();
	_AddOutputListString(OUTPUT_STANDARD,out_str);
	// test net
	_AddOutputListString(OUTPUT_STANDARD,"Testing net for C/E system requirements...");
	int nErrors=0;
	nErrors+=m_net_design.TestElementsNaming();
	nErrors+=m_net_design.TestIsolatedElements();
	nErrors+=m_net_design.TestEventsConcession(m_case_graph.m_case_graph_cases,m_case_graph.m_nCases);
	nErrors+=m_net_design.TestDistinguishability();
	nErrors+=m_net_design.TestEmptyNet();
	if(nErrors==0)
	{
		_AddOutputListString(OUTPUT_STANDARD,"Net is C/E system");
	}
	else
	{
		_AddOutputListString(OUTPUT_STANDARD,"Net is not C/E system");
		_AddOutputListString(OUTPUT_STANDARD,"Aborting simulation");
	}
	// output results
	out_str=GetTitle();
	out_str+=" - ";
	CString aux_str;
	aux_str.Format("%d error(s)",nErrors);
	out_str+=aux_str;
	_AddOutputListString(OUTPUT_STANDARD,out_str);
	return (nErrors==0);
}

void CCESimDoc::ResetSystem()
{
	CString out_str;
	out_str="System reset to initial case ";
	out_str+=m_initial_case.Format();
	_AddOutputListString(OUTPUT_SIMULATION,out_str);
	m_actual_case=m_initial_case;
	UpdateEvents();
	ReflectActCase();
	m_occurrence_net.DeleteContents();
	if(m_can_show_case_graph)m_occurrence_net.AddInitialCase(m_initial_case);
}

bool CCESimDoc::TestRealizeStep(bool output/*=true*/)
{	// test na konfliktni situace, return true if no conflict
	bool first_event=true;
	CString step_str;
	CPNLabel* pLabel;
	CPNElement* pElement;
	CPNEvent* pOuterEvent;
	CPNEvent* pInnerEvent;
	CSetConditions conflict_set,aux_set;
	POSITION outer_pos,inner_pos;
	if(output)step_str="{";
	outer_pos=m_selected_elements.GetHeadPosition();
	while(outer_pos!=NULL)
	{	// outer loop
		pElement=m_selected_elements.GetNext(outer_pos);
		pOuterEvent=dynamic_cast<CPNEvent*>(pElement);
		if(pOuterEvent)
		{
			if(output)
			{
				pLabel=pOuterEvent->GetLabel();
				if(pLabel)
				{
					if(!first_event)step_str+=",";
					first_event=false;
					step_str+=" ";
					step_str+=pLabel->GetText();
				}
			}
			inner_pos=outer_pos;
			while(inner_pos!=NULL)
			{	// inner loop
				pElement=m_selected_elements.GetNext(inner_pos);
				pInnerEvent=dynamic_cast<CPNEvent*>(pElement);
				if(pInnerEvent)
				{
					aux_set=pOuterEvent->GetPreSet().Intersect(pInnerEvent->GetPreSet());
					conflict_set.Union(aux_set);
					aux_set=pOuterEvent->GetPostSet().Intersect(pInnerEvent->GetPostSet());
					conflict_set.Union(aux_set);
				}
			}
		}
	}
	if(output)
	{
		if(!first_event)step_str+=" ";
		step_str+="}";
	}
	if(!conflict_set.IsEmpty())
	{	// error not a step
		if(output)
		{
			CString str;
			str="cannot execute step ";
			str+=step_str;
			str+=", conflict in conditions ";
			str+=conflict_set.Format(CSetConditions::FORMAT_INDIVIDUAL);
			_WriteOutError(OUTPUT_SIMULATION,str);
		}
		return false;
	}
	return true;	
}

void CCESimDoc::RealizeStep(int part/*=RLZ_DIFF_CASE*/)
{
	// realizing step: new_case=(actual_case\preset_of_step) + postset_of_step
	// first make RLZ_DIFF_CASE part, second make RLZ_SWITCH_CONDITON and third make RLZ_UNION_CASE part

	if(part==RLZ_DIFF_CASE)
	{
		if(m_old_occurrence_net)
		{
			m_old_occurrence_net=false;
			m_occurrence_net.DeleteContents();
			if(m_can_show_case_graph)
			{
				m_occurrence_net.Init(m_net_design.m_element_list);
				m_occurrence_net.AddInitialCase(m_actual_case);
			}
		}
	}

	bool first_event=true;
	CString step_str;
	step_str="{";
	CPNEvent* pEvent;
	CPNLabel* pLabel;
	CPNCondition* pCondition;
	POSITION pos=m_selected_elements.GetHeadPosition();
	while(pos!=NULL)
	{
		pEvent=dynamic_cast<CPNEvent*>(m_selected_elements.GetNext(pos));
		if(pEvent)
		{
			if(part==RLZ_DIFF_CASE)
			{	// new_case=(actual_case\preset_of_step)
				pEvent->Select(false);
				pEvent->SetRealizing();
				m_actual_case.Difference(pEvent->GetPreSet());
				// prepnout tokeny z presetu na poloprazdne
				pEvent->GetPreSet().InitIteration();
				pCondition=pEvent->GetPreSet().NextIteration();
				while(pCondition)
				{	// 
					pCondition->SetHalfFullToken();
					pCondition=pEvent->GetPreSet().NextIteration();
				}
			}
			if(part==RLZ_SWITCH_CONDITON)
			{	// vratit zobrazeni tokenu z presetu na normal
				pEvent->GetPreSet().InitIteration();
				pCondition=pEvent->GetPreSet().NextIteration();
				while(pCondition)
				{	// 
					pCondition->SetHalfFullToken(false);
					pCondition=pEvent->GetPreSet().NextIteration();
				}
				// a prepnout tokeny z postsetu na poloprazdne
				pEvent->GetPostSet().InitIteration();
				pCondition=pEvent->GetPostSet().NextIteration();
				while(pCondition)
				{	// 
					pCondition->SetHalfFullToken();
					pCondition=pEvent->GetPostSet().NextIteration();
				}
			}
			if(part==RLZ_UNION_CASE)
			{	// new_case=new_case + postset_of_step
				pEvent->SetRealizing(false);
				pLabel=pEvent->GetLabel();
				if(pLabel)
				{
					if(!first_event)step_str+=",";
					first_event=false;
					step_str+=" ";
					step_str+=pLabel->GetText();
				}
				m_actual_case.Union(pEvent->GetPostSet());
				// vratit zobrazeni tokenu z postsetu na normal
				pEvent->GetPostSet().InitIteration();
				pCondition=pEvent->GetPostSet().NextIteration();
				while(pCondition)
				{	// 
					pCondition->SetHalfFullToken(false);
					pCondition=pEvent->GetPostSet().NextIteration();
				}
			}
		}
	}
	UpdateEvents();
	ReflectActCase();
	if(part==RLZ_UNION_CASE)
	{
		if(!first_event)step_str+=" ";
		step_str+="}";
		CString out_str;
		out_str="Executed step ";
		out_str+=step_str;
		out_str+=", new case is ";
		out_str+=m_actual_case.Format();
		_AddOutputListString(OUTPUT_SIMULATION,out_str);
		if(m_can_show_occurrence_net)
		{
			m_occurrence_net.AddStep(m_selected_elements,m_actual_case);
			SetModifiedFlag();
		}
	}
}

bool CCESimDoc::AutoSelectStep(bool random/*=true*/)
{
	CSetEvents step_set=m_case_graph.GetStep(m_actual_case,random);
	m_selected_elements.RemoveAll();
	CPNEvent* pEvent;
	step_set.InitIteration();
	pEvent=step_set.NextIteration();
	while(pEvent)
	{	// elementy v selected elements neselektuje
		m_selected_elements.AddHead(pEvent);
		pEvent=step_set.NextIteration();
	}
	return !m_selected_elements.IsEmpty();
}

void CCESimDoc::PrepareTokenAnimation(int side)
{
	CPNEdge* pEdge;
	CPNEvent* pEvent;
	CPNElement* pElement;
	CPNCondition* pCondition;
	m_animate_edge_list.RemoveAll();
	POSITION pos_sel=m_selected_elements.GetHeadPosition();
	while(pos_sel!=NULL)
	{	// projdou se vsechny provedene udalosti
		pElement=m_selected_elements.GetNext(pos_sel);
		pEvent=dynamic_cast<CPNEvent*>(pElement);
		if(pEvent)
		{	
			if(side==PRE_SET)
			{
				pEvent->GetPreSet().InitIteration();
				pCondition=pEvent->GetPreSet().NextIteration();
			}
			else
			{
				pEvent->GetPostSet().InitIteration();
				pCondition=pEvent->GetPostSet().NextIteration();
			}
			while(pCondition)
			{	// a jejich vstupni nebo vystupni mnoziny
				POSITION pos=m_net_design.m_element_list.GetHeadPosition();
				while(pos!=NULL)
				{	// nakonec se nalezne hrana mezi nimi
					pElement=m_net_design.m_element_list.GetNext(pos);
					pEdge=dynamic_cast<CPNEdge*>(pElement);
					if(pEdge)
					{
						if(side==PRE_SET)
						{
							if(pEdge->IsCorresponding(pCondition,pEvent))m_animate_edge_list.AddHead(pEdge);
						}
						else
						{
							if(pEdge->IsCorresponding(pEvent,pCondition))m_animate_edge_list.AddHead(pEdge);
						}
					}
				}
				if(side==PRE_SET)
					pCondition=pEvent->GetPreSet().NextIteration();
				else
					pCondition=pEvent->GetPostSet().NextIteration();
			}
		}
	}
	m_token_index=-1; // 
	m_token_is_animating=true;
}

bool CCESimDoc::StepTokenAnimation()
{
	m_token_index++;
	m_token_is_animating=(m_token_index<CPNEdge::TOKEN_PATH_POINTS);
	return m_token_is_animating;
}

void CCESimDoc::LeaveSimulation()
{
//	if(!m_occurrence_net_placed)m_can_show_occurrence_net=FALSE;
	m_case_graph.HighLightCase(CSetConditions(),false);
	m_view_grid=m_old_view_grid;
	m_actual_case=m_initial_case;
	ReflectActCase();
	m_net_design.ClearNet();
	m_simulation_mode=false;
	m_token_is_animating=false;
	DeselectAllElements();
	ASSERT((CMainFrame*)AfxGetApp()->m_pMainWnd);
	((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_HIDE);
	UpdateAllViews(NULL);
}

bool CCESimDoc::CanDragPoint(const CPoint& point)
{	// test whether point is on some edge or polygon drag point
	CPNEdge* pEdge;
	CPNPolygon* pPolygon;
	CPNElement* pElement;
	POSITION pos=m_selected_elements.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_selected_elements.GetNext(pos);
		pEdge=dynamic_cast<CPNEdge*>(pElement);
		if(pEdge)
		{
			if(pEdge->IsDragging(point))return true;
		}
		pPolygon=dynamic_cast<CPNPolygon*>(pElement);
		if(pPolygon)
		{
			if(pPolygon->IsDragging(point))return true;
		}
	}
	return false;
}

void CCESimDoc::OnAnalysisWriteoutcaseclass() 
{
	m_case_graph.Writeoutcaseclass();
}

void CCESimDoc::OnUpdateAnalysisWriteoutcaseclass(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_simulation_mode);
}

void CCESimDoc::OnAnalysisComputeallreachablecases() 
{
	m_case_graph.Computeallreachablecases();
}

void CCESimDoc::OnUpdateAnalysisComputeallreachablecases(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_simulation_mode);
}

int CCESimDoc::NetDesign_DoNetComplement(CDC* pDC) 
{	// 
	LeaveSimulation(); // kvuli znaceni novych podminek a kvuli case graph
	_AddOutputListString(OUTPUT_ANALYSIS,"Complementing net...");
	int nComplements=m_net_design.DoNetComplement(pDC);
	CString out_str;
	out_str.Format("Added %d complement(s)",nComplements);
	_AddOutputListString(OUTPUT_ANALYSIS,out_str);
	UpdateAllViews(NULL);
	return nComplements;
}

void CCESimDoc::OnSimulationSetbreakpoints() 
{
	if(m_dlg_breakpoints.IsCaseClassInvalid())
	{
		CPNCase* pCase;
		m_dlg_breakpoints.m_nOrigCases=m_case_graph.m_nCases;
		m_dlg_breakpoints.m_case_class.SetSize(m_dlg_breakpoints.m_nOrigCases,0);
		for(int index=0;index<m_dlg_breakpoints.m_nOrigCases;index++)
		{
			pCase=m_case_graph.m_case_graph_cases.GetAt(index);
			m_dlg_breakpoints.m_case_class.SetAt(index,pCase->GetCase());
		}
		m_dlg_breakpoints.m_invalid_case_class=false;
		m_dlg_breakpoints.Reset();
	}
	m_dlg_breakpoints.DoModal();	
}

void CCESimDoc::OnUpdateSimulationSetbreakpoints(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_simulation_mode);
}

bool CCESimDoc::TestBreakpoint()
{
	bool bBreak=m_dlg_breakpoints.TestBreakpoint(m_actual_case);
	if(bBreak)_AddOutputListString(OUTPUT_SIMULATION,"Breakpoint reached");
	return bBreak;
}

void CCESimDoc::OnAnalysisCaseclassverification() 
{
	CDlgCaseClassAnalysis dlg;
	CPNCase* pCase;
//	m_case_graph.ComputeReach(m_initial_case);
	dlg.m_nCases=m_case_graph.m_nCases;
	dlg.m_case_class.SetSize(dlg.m_nCases,0);
	dlg.m_case_reach.SetSize(dlg.m_nCases,0);
	for(int index=0;index<dlg.m_nCases;index++)
	{
		pCase=m_case_graph.m_case_graph_cases.GetAt(index);
		dlg.m_case_class.SetAt(index,pCase->GetCase());
		dlg.m_case_reach.SetAt(index,(pCase->IsReachAble())? 1 : 0);
	}
	int conditions=0;
	CPNElement* pElement;
	CPNCondition* pCondition;
	POSITION pos=m_net_design.m_element_list.GetHeadPosition();
	while(pos!=NULL)
	{	
		pElement=m_net_design.m_element_list.GetNext(pos);
		pCondition=dynamic_cast<CPNCondition*>(pElement);
		if(pCondition)
		{
			dlg.m_conditions.Add(pCondition);
			conditions++;
		}
	}
	dlg.m_nConditions=conditions;
	dlg.DoModal();
}

void CCESimDoc::OnUpdateAnalysisCaseclassverification(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_simulation_mode);
}

bool CCESimDoc::CaseGraph_HighlightActCase()
{
	if(m_simulation_mode)m_case_graph.HighLightCase(m_actual_case);
	return m_simulation_mode;
}

void CCESimDoc::SetActualCase(CSetConditions& case_set)
{
	m_actual_case=case_set;
	m_occurrence_net.DeleteContents();
	if(m_can_show_case_graph)m_occurrence_net.AddInitialCase(m_actual_case);
	CString out_str;
	out_str="System set to case ";
	out_str+=m_actual_case.Format();
	_AddOutputListString(OUTPUT_SIMULATION,out_str);
}

void CCESimDoc::UpdateNet()
{
	ReflectActCase();
	UpdateEvents();
}

void CCESimDoc::CaseGraph_SetInitialized()
{
	m_case_graph_initialized=TRUE;
	SetModifiedFlag();
}

void CCESimDoc::OnCasegraphExportcaseclass()
{
	char szFilter[]="XML file (*.xml)|*.xml|All files (*.*)|*.*||";
	CFileDialog filedlg(FALSE,"","CaseClass",OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST,szFilter,NULL);
	if(filedlg.DoModal()==IDOK)
	{
		m_case_graph.ExportCaseClass(filedlg.GetPathName());
	}
}

void CCESimDoc::OnUpdateCasegraphExportcaseclass(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_simulation_mode && m_can_show_case_graph);
}

void CCESimDoc::OnNetdesignExporttoxml() 
{
	char szFilter[]="XML file (*.xml)|*.xml|All files (*.*)|*.*||";
	CFileDialog filedlg(FALSE,"",GetTitle(),OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST,szFilter,NULL);
	if(filedlg.DoModal()==IDOK)
	{
		m_net_design.ExportToXml(filedlg.GetPathName());
	}
}

void CCESimDoc::OnUpdateNetdesignExporttoxml(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!m_simulation_mode);
}

void CCESimDoc::OnCasegraphExporttoxml()
{
	char szFilter[]="XML file (*.xml)|*.xml|All files (*.*)|*.*||";
	CFileDialog filedlg(FALSE,"","CaseGraph",OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST,szFilter,NULL);
	if(filedlg.DoModal()==IDOK)
	{
		m_case_graph.ExportToXml(filedlg.GetPathName());
	}
}

void CCESimDoc::OnUpdateCasegraphExporttoxml(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_can_show_case_graph);
}

void CCESimDoc::OnOccurrenceNetExporttoxml()
{
	char szFilter[]="XML file (*.xml)|*.xml|All files (*.*)|*.*||";
	CFileDialog filedlg(FALSE,"","OccurrenceNet",OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST,szFilter,NULL);
	if(filedlg.DoModal()==IDOK)
	{
		m_occurrence_net.ExportToXml(filedlg.GetPathName());
	}
}

void CCESimDoc::OnUpdateOccurrenceNetExporttoxml(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_can_show_occurrence_net);
}

/*
CSize CCESimDoc::OccurrenceNet_PlaceNetElements(CDC* pDC)
{
//	m_occurrence_net_placed=true;
	return m_occurrence_net.PlaceElements(pDC);
}
*/
