// CESimDoc.h : interface of the CCESimDoc class
//
/////////////////////////////////////////////////////////////////////////////
#if !defined(AFX_CESIMDOC_H__A0A5E257_23B6_4908_87F3_3A369E9770A5__INCLUDED_)
#define AFX_CESIMDOC_H__A0A5E257_23B6_4908_87F3_3A369E9770A5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "CEPNobj.h"
#include "NetDesign.h"
#include "CaseGraph.h"
#include "OccurrenceNet.h"
#include "DlgBreakPoints.h"

class CCESimDoc : public CDocument
{
protected: // create from serialization only
	CCESimDoc();

	DECLARE_DYNCREATE(CCESimDoc)


private:
	enum { VERSION=1 };
	enum { TKN_RDS=4 }; // radius for token circle
	enum { TKN_CLR=RGB(0,0,255) }; // color for drawing tokens

	int				m_version;
	BOOL			m_view_grid;
	BOOL			m_view_ruler;
	BOOL			m_old_view_grid;
	int				m_grid_span;
	bool			m_loaded_from_file;
	BOOL			m_net_modified;
	BOOL			m_case_graph_initialized; // case graph has been initialized
	BOOL			m_can_show_case_graph; // net is prepared
	BOOL			m_can_show_occurrence_net; // net is complemented
	CPNElementList	m_selected_elements; // list of selected elements
	CString			m_mask_condition; // masks for labels
	CString			m_mask_event;
	CString			m_mask_text;
	int				m_cnt_condition; // counters for labels
	int				m_cnt_event;
	int				m_cnt_text;
	int				m_cnt_text_case_graph; // counter for labels
	bool			m_simulation_mode;
	bool			m_token_is_animating;
	int				m_token_animation_delay;
	int				m_token_index;
	CPen			m_tkn_pen; // pen for drawing animating token
	CBrush			m_tkn_brush; // brush for drawing animating token
	CPen*			m_old_pen;
	CBrush*			m_old_brush;
	bool			m_old_occurrence_net; // old net is available
	bool			m_case_graph_loaded; // 
//	bool			m_occurrence_net_placed; // vyskytova sit byla po vytvoreni i zobrazena

	CDlgBreakPoints	m_dlg_breakpoints;
	CCaseGraph		m_case_graph;
	CNetDesign		m_net_design;
	COccurrenceNet	m_occurrence_net;

	CSetConditions	m_actual_case;
	CSetConditions	m_initial_case;
	CTypedPtrList<CObList,CPNEdge*> m_animate_edge_list;

private:
	void ReflectActCase()	{ m_net_design.ReflectCase(m_actual_case); }
	void UpdateEvents()		{ m_net_design.UpdateEvents(m_actual_case); }

public:
	enum { LABEL_CONDITION, LABEL_EVENT, LABEL_TEXT_NET_DESIGN, LABEL_TEXT_CASE_GRAPH };
	enum { PLACE_BACK, PLACE_FRONT };
	enum { PRE_SET, POST_SET };
	enum { RLZ_DIFF_CASE, RLZ_SWITCH_CONDITON, RLZ_UNION_CASE };

public:
	int	 GetGridSpan()	{ return m_grid_span; }
	bool IsGridVisible() { return m_view_grid!=0; }
	bool IsRulerVisible() { return m_view_ruler!=0; }

	void SetGridVisible(bool visible=true)	{ m_view_grid=visible; }
	void SetRulerVisible(bool visible=true)	{ m_view_ruler=visible; }

	bool EnterSimulation();
	void LeaveSimulation();
	void ResetSystem();
	void RealizeStep(int part=RLZ_DIFF_CASE);
	bool TestRealizeStep(bool output=true);
	bool AutoSelectStep(bool random=true);
	void PrepareTokenAnimation(int side);
	bool StepTokenAnimation();
	int	 GetTokenAnimationDelay()			{ return m_token_animation_delay; }
	bool IsSimulationMode()					{ return m_simulation_mode; }
	bool TestBreakpoint();
	void SetTokenAnimationDelay(int delay)	{ m_token_animation_delay=delay; }
	void SetNetModified();
	void SetActualCase(CSetConditions& case_set);
	void UpdateNet();

	CString		GetAutomaticLabelText(int element_type);
	bool		IsElementSelected(CPNElement* pElement=NULL);
	bool		IsMultiselect();
	CRect		DeselectAllElements();
	CRect		SelectElement(CPNElement* pElement,bool multiselect=false);
	CRect		MoveSelectedElementsByVector(CSize move);
	CRect		DeselectElement(CPNElement* pElement);
	bool		CanDragPoint(const CPoint& point);
	CPNElement* GetFirstSelectedElement();

	void		NetDesign_Draw(CDC* pDC);
	bool		NetDesign_AddElement(CPNElement* pelement);
	CRect		NetDesign_RecalculateEdges(const CPNElement* pDragged_element=NULL)	{ return m_net_design.RecalculateEdges(pDragged_element); }
	CSize		NetDesign_GetWindowSize()					{ return m_net_design.GetWindowSize(); }
	CPNElement* NetDesign_ElementAt(const CPoint& point,bool events=false,bool conditions=false)	{ return m_net_design.ElementAt(point,events,conditions); }
	CPNElement* SelectedDraggedEdgeAt(const CPoint& point);
	CRect		NetDesign_SelectElements(CRect& rect);
	CRect		NetDesign_PlaceSelectedElements(int position);
	CRect		NetDesign_RemoveSelectedElements();
	bool		NetDesign_CanRemoveElements();
	int			NetDesign_DoNetComplement(CDC* pDC);
	void		NetDesign_SetWindowSize(CSize size)			{ m_net_design.SetWindowSize(size); }

	bool		CaseGraph_HighlightActCase();
	CRect		CaseGraph_SelectElements(CRect& rect);
	void		CaseGraph_AddElement(CPNElement* pElement);
	CRect		CaseGraph_RemoveSelectedElements();
	bool		CaseGraph_CanRemoveElements();
	void		CaseGraph_SetInitialized();
	CRect		CaseGraph_PlaceSelectedElements(int position);
	CRect		CaseGraph_RecalculateSteps(const CPNElement* pDragged_element=NULL,bool first=false)	{ return m_case_graph.RecalculateSteps(pDragged_element,first); }
	bool		CaseGraph_Smooth(CSize& window_size)		{ return m_case_graph.Smooth(window_size); }
	bool		CaseGraph_IsInitialized()					{ return m_case_graph_initialized!=0; }
	bool		CaseGraph_CanShow()							{ return m_can_show_case_graph!=0; }
	CSize		CaseGraph_GetWindowSize()					{ return m_case_graph.GetWindowSize(); }
	bool		CaseGraph_IsLoaded()						{ return m_case_graph_loaded; }
	int			CaseGraph_GetCasesCount()					{ return m_case_graph.m_nCases; }
	int			CaseGraph_GetGridSize()						{ return m_case_graph.m_grid_size; }
	CPNCase*	CaseGraph_GetNextCase()						{ return m_case_graph.GetNextCase(); }
	CPNElement* CaseGraph_ElementAt(const CPoint& point)	{ return m_case_graph.ElementAt(point); }
	void		CaseGraph_SetLoaded(bool loaded=true)		{ m_case_graph_loaded=loaded; }
	void		CaseGraph_Draw(CDC* pDC)					{ m_case_graph.Draw(pDC); }
	void		CaseGraph_PrintLegend(CDC* pDC,int textheight)	{ m_case_graph.PrintLegend(pDC,textheight); }
	void		CaseGraph_WriteOutLegend()					{ m_case_graph.WriteOutLegend(); }
	void		CaseGraph_LabelElements(CDC* pDC)			{ m_case_graph.LabelElements(pDC); }
	void		CaseGraph_SetMinGridSize(int grid_size)		{ m_case_graph.SetMinGridSize(grid_size); }
	void		CaseGraph_InitCaseBrowse()					{ m_case_graph.InitCaseBrowse(); }
	void		CaseGraph_SetWindowSize(CSize size)			{ m_case_graph.SetWindowSize(size); }
	void		CaseGraph_Place()							{ m_case_graph.Place(); }
	void		CaseGraph_HighlightReachableCases(bool highlight)	{ m_case_graph.HighlightReachableCases(highlight); }

	CRect		OccurrenceNet_SelectElements(CRect& rect);
	void		OccurrenceNet_AddElement(CPNElement* pElement);
	CRect		OccurrenceNet_RemoveSelectedElements();
	bool		OccurrenceNet_CanRemoveElements();
	CRect		OccurrenceNet_PlaceSelectedElements(int position);
	CRect		OccurrenceNet_RecalculateEdges(const CPNElement* pDragged_element=NULL)	{ return m_occurrence_net.RecalculateEdges(pDragged_element); }
	bool		OccurrenceNet_CanShow()							{ return m_can_show_occurrence_net!=0; }
	CSize		OccurrenceNet_GetWindowSize()					{ return m_occurrence_net.GetWindowSize(); }
//	CSize		OccurrenceNet_PlaceNetElements(CDC* pDC);
	CSize		OccurrenceNet_PlaceNetElements(CDC* pDC)		{ return m_occurrence_net.PlaceElements(pDC); }
	CPNElement* OccurrenceNet_ElementAt(const CPoint& point)	{ return m_occurrence_net.ElementAt(point); }
	void		OccurrenceNet_Draw(CDC* pDC)					{ m_occurrence_net.Draw(pDC); }
	void		OccurrenceNet_PrintLegend(CDC* pDC,int textheight)	{ m_occurrence_net.PrintLegend(pDC,textheight,m_net_design.m_element_list); }
	void		OccurrenceNet_WriteOutLegend()					{ m_occurrence_net.WriteOutLegend(m_net_design.m_element_list); }
	void		OccurrenceNet_SetWindowSize(CSize size)			{ m_occurrence_net.SetWindowSize(size); }

public:
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCESimDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual void DeleteContents();
	//}}AFX_VIRTUAL

public:
	virtual ~CCESimDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
// Generated message map functions
	//{{AFX_MSG(CCESimDoc)
	afx_msg void OnAnalysisWriteoutcaseclass();
	afx_msg void OnUpdateAnalysisWriteoutcaseclass(CCmdUI* pCmdUI);
	afx_msg void OnSimulationEntersimulationmode();
	afx_msg void OnUpdateSimulationEntersimulationmode(CCmdUI* pCmdUI);
	afx_msg void OnSimulationLeavesimulationmode();
	afx_msg void OnUpdateSimulationLeavesimulationmode(CCmdUI* pCmdUI);
	afx_msg void OnSimulationSetbreakpoints();
	afx_msg void OnUpdateSimulationSetbreakpoints(CCmdUI* pCmdUI);
	afx_msg void OnAnalysisCaseclassverification();
	afx_msg void OnUpdateAnalysisCaseclassverification(CCmdUI* pCmdUI);
	afx_msg void OnCasegraphExportcaseclass();
	afx_msg void OnUpdateCasegraphExportcaseclass(CCmdUI* pCmdUI);
	afx_msg void OnNetdesignExporttoxml();
	afx_msg void OnCasegraphExporttoxml();
	afx_msg void OnUpdateCasegraphExporttoxml(CCmdUI* pCmdUI);
	afx_msg void OnOccurrenceNetExporttoxml();
	afx_msg void OnUpdateOccurrenceNetExporttoxml(CCmdUI* pCmdUI);
	afx_msg void OnUpdateNetdesignExporttoxml(CCmdUI* pCmdUI);
	afx_msg void OnAnalysisComputeallreachablecases();
	afx_msg void OnUpdateAnalysisComputeallreachablecases(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CESIMDOC_H__A0A5E257_23B6_4908_87F3_3A369E9770A5__INCLUDED_)
