// CESimNetDesignView.h : interface of the CCESimNetDesignView class
//
/////////////////////////////////////////////////////////////////////////////
#if !defined(AFX_CESIMNETDESIGNVIEW_H__24E16892_FE65_4394_9A78_0CB02A19917E__INCLUDED_)
#define AFX_CESIMNETDESINGVIEW_H__24E16892_FE65_4394_9A78_0CB02A19917E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CCESimNetDesignView : public CScrollView
{
public: // create from serialization only
	CCESimNetDesignView();
	DECLARE_DYNCREATE(CCESimNetDesignView)

private:
	enum { RULER_THICK=13, RULER_CLR=RGB(236,233,216), RULER_SPAN=80, RULER_ARROW_HEIGHT=5, RULER_ARROW_WIDTH=5 };
	enum { SLEEP_DELAY=5 };
	enum { TOOL_SELECT=32771, TOOL_CONDITION, TOOL_EVENT, TOOL_EDGE, TOOL_POLYGON, TOOL_LABEL, TOOL_TOKEN };
	enum {	CT_NONE,					// capture type NONE
			CT_DRAWING_EDGE,			// drawing new edge
			CT_DRAGGING_EDGE,			// dragging edge
			CT_DRAGGING_COND,			// dragging condition
			CT_DRAGGING_EVNT,			// dragging event
			CT_DRAGGING_LBL,			// dragging label
			CT_DRAGGING_POLYGON,		// dragging entire polygon
			CT_DRAGGING_POLYGON_POINT,	// dragging one polygon point
			CT_DRAGGING_MULTI_SELECT,	// 
			CT_DRAWING_SELECT_RECT,		// 
			};

private:
	bool		m_erase_background;
	int			m_tool_selected;
	bool		m_mouse_capture;
	bool		m_mouse_moved;
	CPoint		m_last_mouse_pt;
	CPoint		m_last_drag_pt;
	CPoint		m_first_mouse_pt; // for select rect
	int			m_capture_type;
	CPNElement*	m_hit_element; // dragging element
	CPNElement*	m_context_element; // 
	bool		m_ignore_move; // ignore mouse move when activating view
	CPoint		m_edge_from; // start point for drawing edge
	CPoint		m_edge_to; // end point for drawing edge
//	CPoint		m_guidepoint;
	bool		m_simulation_mode;
	bool		m_automatic_simulation;
	bool		m_animating_token; // probiha animace tokenu
	bool		m_export;
	CString		m_export_path;

	LOGFONT		m_ruler_logfont;
	CFont		m_ruler_font;
	CPoint		m_ruler_last_mouse_pt;
	bool		m_ruler_last_pt;

private:
	CPoint	SnapOnGrid(CPoint point);
	void	InvertLine(CDC* pDC,const CPoint& from,const CPoint& to);
	void	InvertRect(CDC* pDC,const CPoint& from,const CPoint& to);
	void	InvalidateRect(CRect rect,CDC* pDC=NULL);
	int		AnimateStep();
	bool	SimulationRealizeStep();
	void	AutomaticSimulation();
	void	DrawRulerPos(CDC* pDC,CPoint& point,bool bClearOnly=false);

public:
	CCESimDoc*	GetDocument();
	void		SwitchedTo();

public:
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCESimNetDesignView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL OnScroll(UINT nScrollCode, UINT nPos, BOOL bDoScroll = TRUE);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	virtual void OnUpdate(CView* pSender,LPARAM lHint,CObject* pHint);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

public:
	virtual ~CCESimNetDesignView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
// Generated message map functions
	//{{AFX_MSG(CCESimNetDesignView)
	afx_msg void OnViewGrid();
	afx_msg void OnUpdateViewGrid(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDown(UINT nFlags,CPoint point);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnEditPlacetofront();
	afx_msg void OnUpdateEditPlacetofront(CCmdUI* pCmdUI);
	afx_msg void OnEditPlacetoback();
	afx_msg void OnUpdateEditPlacetoback(CCmdUI* pCmdUI);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnEditDelete();
	afx_msg void OnUpdateEditDelete(CCmdUI* pCmdUI);
	afx_msg void OnEdgeDeletepoint();
	afx_msg void OnUpdateEdgeDeletepoint(CCmdUI* pCmdUI);
	afx_msg void OnEdgeDeleteallpoints();
	afx_msg void OnUpdateEdgeDeleteallpoints(CCmdUI* pCmdUI);
	afx_msg void OnPolygonDeletepoint();
	afx_msg void OnUpdatePolygonDeletepoint(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnSimulationRealizeStep();
	afx_msg void OnUpdateSimulationRealizeStep(CCmdUI* pCmdUI);
	afx_msg void OnSimulationResetsystem();
	afx_msg void OnUpdateSimulationResetsystem(CCmdUI* pCmdUI);
	afx_msg void OnBtnSimStart();
	afx_msg void OnBtnSimReset();
	afx_msg void OnBtnSimStep();
	afx_msg void OnBtnSimStop();
	afx_msg void OnAnalysisDonetcomplement();
	afx_msg void OnUpdateAnalysisDonetcomplement(CCmdUI* pCmdUI);
	afx_msg void OnViewPropertiesNetdesign();
	afx_msg void OnUpdateViewPropertiesNetdesign(CCmdUI* pCmdUI);
	afx_msg void OnNetdesignExporttoemf();
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnViewRuler();
	afx_msg void OnUpdateViewRuler(CCmdUI* pCmdUI);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	//}}AFX_MSG
	afx_msg void OnNcPaint();
	afx_msg void OnToolChange(UINT nID);
	afx_msg void OnUpdateToolsChange(CCmdUI* pCmdUI);
	afx_msg LRESULT OnSimulationSpeed(WPARAM wparam,LPARAM lparam);
	afx_msg LRESULT OnUpdateView(WPARAM wparam,LPARAM lparam);
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in CESimNetDesignView.cpp
inline CCESimDoc* CCESimNetDesignView::GetDocument()
   { return (CCESimDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CESIMNETDESIGNVIEW_H__24E16892_FE65_4394_9A78_0CB02A19917E__INCLUDED_)
