// DlgBreakPoints.cpp : implementation file
//

#include "stdafx.h"
#include "cesim.h"
#include "DlgBreakPoints.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgBreakPoints dialog
CDlgBreakPoints::CDlgBreakPoints(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgBreakPoints::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgBreakPoints)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_invalid_case_class=true;
	m_nBreakpoints=m_nCases=m_nOrigCases=0;
}

void CDlgBreakPoints::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgBreakPoints)
	DDX_Control(pDX, IDC_BTN_CLEAR, m_btn_clear);
	DDX_Control(pDX, IDC_BTN_DEL, m_btn_del);
	DDX_Control(pDX, IDC_BTN_ADD, m_btn_add);
	DDX_Control(pDX, IDC_LIST_BREAKPOINTS, m_list_breakpoints);
	DDX_Control(pDX, IDC_LIST_CASES, m_list_cases);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDlgBreakPoints, CDialog)
	//{{AFX_MSG_MAP(CDlgBreakPoints)
	ON_BN_CLICKED(IDC_BTN_ADD, OnBtnAdd)
	ON_BN_CLICKED(IDC_BTN_DEL, OnBtnDel)
	ON_BN_CLICKED(IDC_BTN_CLEAR, OnBtnClear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgBreakPoints message handlers
BOOL CDlgBreakPoints::OnInitDialog() 
{
	CDialog::OnInitDialog();

	ShowSets();	

	int i,ext;
	int max_ext=0;
	CString str;
	CClientDC dc(&m_list_cases);
	for(i=0;i<m_nCases;i++)
	{
		m_list_cases.GetText(i,str);
		ext=dc.GetTextExtent(str).cx;
		if(ext>max_ext)max_ext=ext;
	}
	m_list_cases.SetHorizontalExtent(max_ext);
	m_list_breakpoints.SetHorizontalExtent(max_ext);

	return TRUE;
}

void CDlgBreakPoints::OnBtnAdd() 
{
	int sel=m_list_cases.GetCurSel();
	CString text;
	m_list_cases.GetText(sel,text);
	DWORD data=m_list_cases.GetItemData(sel);
	m_list_cases.DeleteString(sel);
	m_list_cases.SetCurSel(0);
	sel=m_list_breakpoints.AddString(text);
	m_list_breakpoints.SetItemData(sel,data);
	m_list_breakpoints.SetCurSel(sel);
	m_btn_add.EnableWindow(m_list_cases.GetCount()!=0);
	m_btn_del.EnableWindow(TRUE);
	m_btn_clear.EnableWindow(TRUE);
}

void CDlgBreakPoints::OnBtnDel() 
{
	int sel=m_list_breakpoints.GetCurSel();
	CString text;
	m_list_breakpoints.GetText(sel,text);
	DWORD data=m_list_breakpoints.GetItemData(sel);
	m_list_breakpoints.DeleteString(sel);
	m_list_breakpoints.SetCurSel(0);
	sel=m_list_cases.AddString(text);
	m_list_cases.SetItemData(sel,data);
	m_list_cases.SetCurSel(sel);
	m_btn_add.EnableWindow(TRUE);
	m_btn_del.EnableWindow(m_list_breakpoints.GetCount()!=0);
	m_btn_clear.EnableWindow(m_list_breakpoints.GetCount()!=0);
}

void CDlgBreakPoints::OnBtnClear() 
{
	Reset();
	ShowSets();
}

void CDlgBreakPoints::OnOK() 
{
	int pos,index;
	m_breakpoints.RemoveAll();
	m_nBreakpoints=m_list_breakpoints.GetCount();
	m_breakpoints.SetSize(m_nBreakpoints);
	for(index=0;index<m_nBreakpoints;index++)
	{
		pos=m_list_breakpoints.GetItemData(index);
		m_breakpoints.SetAt(index,pos);
	}
	m_cases.RemoveAll();
	m_nCases=m_list_cases.GetCount();
	m_cases.SetSize(m_nCases);
	for(index=0;index<m_nCases;index++)
	{
		pos=m_list_cases.GetItemData(index);
		m_cases.SetAt(index,pos);
	}
	
	CDialog::OnOK();
}

void CDlgBreakPoints::Reset()
{
	m_nBreakpoints=0;
	m_breakpoints.RemoveAll();
	m_nCases=m_nOrigCases;
	m_cases.SetSize(m_nOrigCases);
	for(int index=0;index<m_nOrigCases;index++)
	{
		m_cases.SetAt(index,index);
	}
}

void CDlgBreakPoints::ShowSets()
{
	m_list_cases.ResetContent();
	m_list_breakpoints.ResetContent();
	int pos;
	int i,index;
	for(i=0;i<m_nCases;i++)
	{
		pos=m_cases.GetAt(i);
		index=m_list_cases.AddString(m_case_class.GetAt(pos).Format());
		m_list_cases.SetItemData(index,pos);
	}
	for(i=0;i<m_nBreakpoints;i++)
	{
		pos=m_breakpoints.GetAt(i);
		index=m_list_breakpoints.AddString(m_case_class.GetAt(pos).Format());
		m_list_breakpoints.SetItemData(index,pos);
	}
	m_list_cases.SetCurSel(0);
	m_list_breakpoints.SetCurSel(0);
	m_btn_add.EnableWindow(m_list_cases.GetCount()!=0);
	m_btn_del.EnableWindow(m_list_breakpoints.GetCount()!=0);
	m_btn_clear.EnableWindow(m_list_breakpoints.GetCount()!=0);
}

bool CDlgBreakPoints::TestBreakpoint(CSetConditions& case_set)
{
	int pos;
	for(int index=0;index<m_nBreakpoints;index++)
	{
		pos=m_breakpoints.GetAt(index);
		if(m_case_class.GetAt(pos)==case_set)return true;
	}
	return false;
}
