// DlgOutputBar.cpp : implementation file
//

#include "stdafx.h"
#include "cesim.h"
#include "DlgOutputBar.h"

#include <afxpriv.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgOutputBar
CDlgOutputBar::CDlgOutputBar()
{
	CDlgPropertiesBar();
	//{{AFX_DATA_INIT(CDlgOutputBar)
	//}}AFX_DATA_INIT

	m_width=1;
	m_height=200;
	m_statusbar_height=0;
	m_mouse_capture=false;
}

void CDlgOutputBar::DoDataExchange(CDataExchange* pDX)
{
	CDlgPropertiesBar::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgOutputBar)
	DDX_Control(pDX, IDC_OUTPUT_TAB, m_tab_ctrl);
	DDX_Control(pDX, IDC_OUTPUT_LIST_STANDARD, m_list_box[0]);
	DDX_Control(pDX, IDC_OUTPUT_LIST_SIMULATION, m_list_box[1]);
	DDX_Control(pDX, IDC_OUTPUT_LIST_ANALYSIS, m_list_box[2]);
	DDX_Control(pDX, IDC_OUTPUT_LIST_CASEGRAPH, m_list_box[3]);
	DDX_Control(pDX, IDC_OUTPUT_LIST_OCCURRENCENET, m_list_box[4]);
	//}}AFX_DATA_MAP
}

CDlgOutputBar::~CDlgOutputBar()
{
}

BOOL CDlgOutputBar::Create(CWnd* pParentWnd,LPCTSTR lpszTemplateName,UINT nStyle,UINT nID)
{
	return CDlgPropertiesBar::Create(pParentWnd,lpszTemplateName,nStyle,nID);
}

BOOL CDlgOutputBar::Create(CWnd* pParentWnd,UINT nIDTemplate,UINT nStyle,UINT nID)
{
	return CDlgPropertiesBar::Create(pParentWnd,nIDTemplate,nStyle,nID);
}

IMPLEMENT_DYNAMIC(CDlgOutputBar, CDlgPropertiesBar)

BEGIN_MESSAGE_MAP(CDlgOutputBar, CDlgPropertiesBar)
	//{{AFX_MSG_MAP(CDlgOutputBar)
	ON_WM_PAINT()
	ON_WM_CONTEXTMENU()
	ON_NOTIFY(TCN_SELCHANGE, IDC_OUTPUT_TAB, OnSelchangeOutputTab)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_WM_SETCURSOR()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_INITDIALOG,OnInitDialog)
	ON_MESSAGE(APP_MSG_SELECT_OUTPUT_LIST,OnSelectOutputListBox)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CRollDlgBar message handlers
LONG CDlgOutputBar::OnInitDialog(UINT wParam,LONG lParam)
{
	BOOL bRet=HandleInitDialog(wParam,lParam);
	UpdateData(FALSE);

	m_tab_ctrl.InsertItem(0,"Standard");
	m_tab_ctrl.InsertItem(1,"Simulation");
	m_tab_ctrl.InsertItem(2,"Analysis");
	m_tab_ctrl.InsertItem(3,"CaseGraph Legend");
	m_tab_ctrl.InsertItem(4,"OccurrenceNet Legend");

	m_akt_tab_sel=0;
	return bRet;
}

CSize CDlgOutputBar::UpdateSize()
{
	m_pDockBar->GetWindowRect(&m_bar_rect);
	m_bar_rect.right+=1;
	CRect tab_rect;
	m_tab_ctrl.GetWindowRect(&tab_rect);
	m_tab_ctrl.MoveWindow(0,BAR_HEIGHT,m_bar_rect.Width(),tab_rect.Height());
	m_list_box[0].MoveWindow(0,BAR_HEIGHT+tab_rect.Height(),m_bar_rect.Width(),m_bar_rect.Height()-(BAR_HEIGHT+1)-tab_rect.Height());
	m_list_box[1].MoveWindow(0,BAR_HEIGHT+tab_rect.Height(),m_bar_rect.Width(),m_bar_rect.Height()-(BAR_HEIGHT+1)-tab_rect.Height());
	m_list_box[2].MoveWindow(0,BAR_HEIGHT+tab_rect.Height(),m_bar_rect.Width(),m_bar_rect.Height()-(BAR_HEIGHT+1)-tab_rect.Height());
	m_list_box[3].MoveWindow(0,BAR_HEIGHT+tab_rect.Height(),m_bar_rect.Width(),m_bar_rect.Height()-(BAR_HEIGHT+1)-tab_rect.Height());
	m_list_box[4].MoveWindow(0,BAR_HEIGHT+tab_rect.Height(),m_bar_rect.Width(),m_bar_rect.Height()-(BAR_HEIGHT+1)-tab_rect.Height());

	return CSize(m_bar_rect.Width(),m_bar_rect.Height());
}

void CDlgOutputBar::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	CRect win_rect;
	m_pDockBar->GetWindowRect(&win_rect);
	CRect draw_rect;
	draw_rect.SetRect(3,2,win_rect.Width()-4,BAR_HEIGHT-3);
	dc.SetTextColor(::GetSysColor(COLOR_CAPTIONTEXT));
//	dc.SetTextColor(::GetSysColor(COLOR_INACTIVECAPTIONTEXT));
	dc.FillSolidRect(&draw_rect,::GetSysColor(COLOR_ACTIVECAPTION));
//	dc.FillSolidRect(&draw_rect,::GetSysColor(COLOR_INACTIVECAPTION));
	CFont font;
	font.CreateFont(-11,0,0,0,700,0,0,0,0,0,0,0,0,"Tahoma");
	CFont* old=dc.SelectObject(&font);
	dc.SetBkMode(TRANSPARENT);
	dc.TextOut(7,3,"Output");
//	dc.TextOut(7,3,"Output window");
	dc.SelectObject(old);
}

CSize CDlgOutputBar::CalcFixedLayout(BOOL /*bStretch*/, BOOL /*bHorz*/)
{
	return CSize(m_width,m_height);
}

void CDlgOutputBar::OnContextMenu(CWnd* /*pWnd*/, CPoint point) 
{
	CMenu menu;
	VERIFY(menu.LoadMenu(IDR_CONTEXTMENU));

	CMenu* pContextMenu=menu.GetSubMenu(5);
	ASSERT(pContextMenu!=NULL);
	pContextMenu->TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON|TPM_RIGHTBUTTON,point.x,point.y,AfxGetMainWnd());
}

void CDlgOutputBar::Resetcontent(int list)
{
	ASSERT((list>=0) && (list<LIST_BOX_COUNT));
	m_list_box[list].ResetContent();
}

void CDlgOutputBar::OnOutputwindowResetcontent(bool clear_all/*=true*/) 
{
	if(clear_all)
	{
		m_list_box[0].ResetContent();
		m_list_box[1].ResetContent();
		m_list_box[2].ResetContent();
//		m_list_box[3].ResetContent(); // case graph legend
//		m_list_box[4].ResetContent(); // occurrence net legend
	}
	else
		m_list_box[m_akt_tab_sel].ResetContent();
}

void CDlgOutputBar::OnUpdateOutputwindowResetcontent(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_list_box[m_akt_tab_sel].GetCount());
}

void CDlgOutputBar::OnSelchangeOutputTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int index=TabCtrl_GetCurSel(pNMHDR->hwndFrom);
	m_list_box[index].ShowWindow(SW_SHOW);
	m_list_box[m_akt_tab_sel].ShowWindow(SW_HIDE);
	m_akt_tab_sel=index;
	*pResult = 0;
}

LRESULT CDlgOutputBar::OnSelectOutputListBox(WPARAM wparam,LPARAM /*lparam*/)
{
	ASSERT(wparam<LIST_BOX_COUNT);

	if(m_akt_tab_sel!=int(wparam))
	{
		m_tab_ctrl.SetCurSel(wparam);
		m_list_box[wparam].ShowWindow(SW_SHOW);
		m_list_box[m_akt_tab_sel].ShowWindow(SW_HIDE);
		m_akt_tab_sel=wparam;
	}
	return 0;
}

void CDlgOutputBar::ShowOutputListBox(int list/*=0*/)
{
	OnSelectOutputListBox(list,list);
}

CListBox* CDlgOutputBar::GetOutputList(int list)
{
	ASSERT(list<LIST_BOX_COUNT);

	return &m_list_box[list];
}

void CDlgOutputBar::OnLButtonDown(UINT /*nFlags*/, CPoint /*point*/) 
{
	SetCapture();
	::SetCursor(::LoadCursor(NULL,IDC_SIZEALL));
	m_mouse_capture=true;
	m_odd=true;
	m_width=UpdateSize().cx; // disable flicker
	CMiniDockFrameWnd* pDockFrame=(CMiniDockFrameWnd*)m_pDockBar->GetParent();
	pDockFrame->GetWindowRect(&m_win_rect);
}

void CDlgOutputBar::OnMouseMove(UINT /*nFlag*/,CPoint /*point*/)
{
	if(m_mouse_capture && m_odd)
	{
		CMiniDockFrameWnd* pDockFrame=(CMiniDockFrameWnd*)m_pDockBar->GetParent();
		POINT cursor;
		::GetCursorPos(&cursor);
		m_height=m_win_rect.bottom-cursor.y-m_statusbar_height;
		if(m_height<MINIMUM_BAR_HEIGHT)m_height=MINIMUM_BAR_HEIGHT;
//		pDockFrame->RecalcLayout(TRUE);
		pDockFrame->ShowControlBar(this,TRUE,FALSE);
		CSize size=UpdateSize();
		MoveWindow(0,0,size.cx,size.cy);
	}
	m_odd=!m_odd; // disable flicker
}

void CDlgOutputBar::OnLButtonUp(UINT /*nFlags*/,CPoint /*point*/)
{
	if(m_mouse_capture)
	{
		::ReleaseCapture();
		m_mouse_capture=false;
		m_width=1; // disable flicker
	}
}

void CDlgOutputBar::OnLButtonDblClk(UINT /*nFlags*/,CPoint /*point*/)
{	// disable bar floating
}

BOOL CDlgOutputBar::OnSetCursor(CWnd* /*pWnd*/, UINT /*nHitTest*/, UINT /*message*/) 
{
	char* cursor_name=IDC_ARROW;
	POINT cursor_pt;
	::GetCursorPos(&cursor_pt);
	int handle=cursor_pt.y-m_bar_rect.top;
	if((handle>0) && (handle<BAR_HEIGHT-3))cursor_name=IDC_SIZENS;
	::SetCursor(AfxGetApp()->LoadStandardCursor(cursor_name));
	return TRUE;
}
