#if !defined(AFX_OUTBAR_H__56861FFE_54C2_47B9_892B_8161BCD54AD1__INCLUDED_)
#define AFX_OUTBAR_H__56861FFE_54C2_47B9_892B_8161BCD54AD1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DlgOutputBar.h : header file
//

#include "DlgPropertiesBar.h"

/////////////////////////////////////////////////////////////////////////////
// CDlgOutputBar window
class CDlgOutputBar : public CDlgPropertiesBar
{
DECLARE_DYNAMIC(CDlgOutputBar)

private:
	enum { BAR_HEIGHT=21 };
	enum { MINIMUM_BAR_HEIGHT=100 };

	int		m_akt_tab_sel;
	int		m_statusbar_height;
	int		m_height;
	int		m_width;
	bool	m_odd; // for stop blinking
	bool	m_mouse_capture;
	CRect	m_bar_rect;
	CRect	m_win_rect;

public:
	enum { LIST_BOX_COUNT=5 };

	CSize	UpdateSize();
	void	SetStatusBarHeight(int height)	{ m_statusbar_height=height; }
	void	ShowOutputListBox(int list=0);
	void	Resetcontent(int list);
	void	OnOutputwindowResetcontent(bool clear_all=true);
	void	OnUpdateOutputwindowResetcontent(CCmdUI* pCmdUI);
	CListBox* GetOutputList(int list);
	CTabCtrl* GetOutputTab() { return &m_tab_ctrl; }

public:
	CDlgOutputBar();
	BOOL Create(CWnd* pParentWnd, UINT nIDTemplate, UINT nStyle, UINT nID);
	BOOL Create(CWnd* pParentWnd, LPCTSTR lpszTemplateName, UINT nStyle, UINT nID);

// Dialog Data
	//{{AFX_DATA(CDlgOutputBar)
	CTabCtrl	m_tab_ctrl;
	//}}AFX_DATA
	CListBox	m_list_box[LIST_BOX_COUNT];

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDlgOutputBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL
	virtual CSize CalcFixedLayout(BOOL bStretch, BOOL bHorz );

public:
// Implementation
	virtual ~CDlgOutputBar();

protected:
	// Generated message map functions
	//{{AFX_MSG(CDlgOutputBar)
	afx_msg void OnPaint();
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnSelchangeOutputTab(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags,CPoint point);
	afx_msg void OnMouseMove(UINT,CPoint);
	afx_msg void OnLButtonUp(UINT,CPoint);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	//}}AFX_MSG
	afx_msg LONG OnInitDialog(UINT,LONG);
	afx_msg LRESULT OnSelectOutputListBox(WPARAM wparam,LPARAM lparam);

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_OUTBARL_H__56861FFE_54C2_47B9_892B_8161BCD54AD1__INCLUDED_)

