// DlgPropertiesEventBar.cpp : implementation file
//

#include "stdafx.h"
#include "cesim.h"
#include "DlgPropertiesEventBar.h"
#include "DialogSetText.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgPropertiesEventBar
CDlgPropertiesEventBar::CDlgPropertiesEventBar()
{
	CDlgPropertiesBar();
	//{{AFX_DATA_INIT(CDlgPropertiesEventBar)
	m_name = _T("");
	//}}AFX_DATA_INIT
}

void CDlgPropertiesEventBar::DoDataExchange(CDataExchange* pDX)
{
	CDlgPropertiesBar::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgPropertiesEventBar)
	DDX_Control(pDX, IDC_COMBO_SHOW_NAME, m_combo_show_name);
	//}}AFX_DATA_MAP
}

CDlgPropertiesEventBar::~CDlgPropertiesEventBar()
{
}

BOOL CDlgPropertiesEventBar::Create(CWnd* pParentWnd,LPCTSTR lpszTemplateName,UINT nStyle,UINT nID)
{
	return CDlgPropertiesBar::Create(pParentWnd,lpszTemplateName,nStyle,nID);
}

BOOL CDlgPropertiesEventBar::Create(CWnd* pParentWnd,UINT nIDTemplate,UINT nStyle,UINT nID)
{
	return CDlgPropertiesBar::Create(pParentWnd,nIDTemplate,nStyle,nID);
}

IMPLEMENT_DYNAMIC(CDlgPropertiesEventBar, CDlgPropertiesBar)

BEGIN_MESSAGE_MAP(CDlgPropertiesEventBar, CDlgPropertiesBar)
	//{{AFX_MSG_MAP(CDlgPropertiesEventBar)
	ON_BN_CLICKED(IDC_BTN_TEXT, OnBtnText)
	ON_EN_CHANGE(IDC_EDIT_NAME, OnChangeEditName)
	ON_CBN_SELENDOK(IDC_COMBO_SHOW_NAME, OnSelendokComboShowName)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_INITDIALOG,OnInitDialog)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRollDlgBar message handlers
LONG CDlgPropertiesEventBar::OnInitDialog(UINT wParam,LONG lParam)
{
	BOOL bRet=HandleInitDialog(wParam,lParam);
	UpdateData(FALSE);

	m_pEvent=NULL;
	m_pLabel=NULL;
	m_ignore_change_text=false;

	return bRet;
}

void CDlgPropertiesEventBar::SetNetElement(CPNElement* pElement)
{
	CDlgPropertiesBar::SetNetElement(pElement);

	m_pEvent=NULL;
	m_pLabel=NULL;
	m_pEvent=dynamic_cast<CPNEvent*>(pElement);
	if(m_pEvent)m_pLabel=m_pEvent->GetLabel();
	if(m_pLabel)
	{
		m_name=m_pLabel->GetText();
		CString text;
		text=m_name;
		text.Replace(10,' ');
		text.Remove(13);
		m_ignore_change_text=true;
		SetDlgItemText(IDC_EDIT_NAME,text);
		m_combo_show_name.SetCurSel(m_pLabel->IsVisible()? 0 : 1);
	}
}

void CDlgPropertiesEventBar::OnChangeEditName() 
{
	if(m_ignore_change_text)
	{
		m_ignore_change_text=false;
		return;
	}
	if(m_pLabel)
	{
		GetDlgItemText(IDC_EDIT_NAME,m_name);
		m_pLabel->SetText(m_name);
		UpdateLabel();
	}
}

void CDlgPropertiesEventBar::OnBtnText() 
{
	CDialogSetText dlg;
	dlg.SetText(m_name);
	if(dlg.DoModal()==IDOK)
	{
		m_name=dlg.GetText();
		CString text;
		text=m_name;
		text.Replace(10,' ');
		text.Remove(13);
		m_ignore_change_text=true;
		SetDlgItemText(IDC_EDIT_NAME,text);
		if(m_pLabel)
		{
			m_pLabel->SetText(m_name);
			UpdateLabel();
		}
	}
	((CButton*)GetDlgItem(IDC_BTN_TEXT))->SetButtonStyle(0);
}

void CDlgPropertiesEventBar::OnSelendokComboShowName() 
{
	if(m_pLabel)
	{
		m_pLabel->SetVisible(m_combo_show_name.GetCurSel()==0);
		UpdateLabel();
	}
}

void CDlgPropertiesEventBar::UpdateElement()
{
	::PostMessage(AfxGetMainWnd()->GetSafeHwnd(),APP_MSG_UPDATE_VIEW,UPDATE_VIEW_ELEMENT,0);
}

void CDlgPropertiesEventBar::UpdateLabel()
{
	::PostMessage(AfxGetMainWnd()->GetSafeHwnd(),APP_MSG_UPDATE_VIEW,UPDATE_VIEW_LABEL_EVNT,0);
}
