// DlgSmoothCaseGraph.cpp : implementation file
//

#include "stdafx.h"
#include "cesim.h"
#include "DlgSmoothCaseGraph.h"
#include "DlgGASettings.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgSmoothCaseGraph dialog
CDlgSmoothCaseGraph::CDlgSmoothCaseGraph(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgSmoothCaseGraph::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgSmoothCaseGraph)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_started=false;
	m_best_exist=false;
	m_population_prepared=false;
	m_intersections=0;
	m_generations=0;
	m_fitness=0;
}

void CDlgSmoothCaseGraph::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgSmoothCaseGraph)
	DDX_Control(pDX, IDC_BTN_RESET, m_btn_reset);
	DDX_Control(pDX, IDCANCEL, m_btn_cancel);
	DDX_Control(pDX, IDOK, m_btn_ok);
	DDX_Control(pDX, IDC_BTN_STOP, m_btn_stop);
	DDX_Control(pDX, IDC_BTN_START, m_btn_start);
	DDX_Control(pDX, IDC_BTN_SETTINGS, m_btn_settings);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDlgSmoothCaseGraph, CDialog)
	//{{AFX_MSG_MAP(CDlgSmoothCaseGraph)
	ON_BN_CLICKED(IDC_BTN_START, OnBtnStart)
	ON_BN_CLICKED(IDC_BTN_SETTINGS, OnBtnSettings)
	ON_BN_CLICKED(IDC_BTN_STOP, OnBtnStop)
	ON_BN_CLICKED(IDC_BTN_RESET, OnBtnReset)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgSmoothCaseGraph message handlers
BOOL CDlgSmoothCaseGraph::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_running=false;

	SetDlgItemInt(IDC_EDIT_FITNESS,m_fitness,FALSE);
	SetDlgItemInt(IDC_EDIT_GENERATIONS,m_generations,TRUE);
	SetDlgItemInt(IDC_EDIT_INTERSECTIONS,m_intersections,TRUE);
	m_btn_reset.EnableWindow(m_started? TRUE : FALSE);
	
	return TRUE;
}

void CDlgSmoothCaseGraph::OnBtnStart() 
{
	m_started=true;
	m_best_exist=true;
	if(!m_running)
	{
		m_btn_cancel.EnableWindow(FALSE);
		m_btn_ok.EnableWindow(FALSE);
		m_btn_stop.EnableWindow(TRUE);
		m_btn_start.EnableWindow(FALSE);
		m_btn_reset.EnableWindow(FALSE);
		m_btn_settings.EnableWindow(FALSE);

		m_running=true;
		if(!m_population_prepared)
		{
			m_population_prepared=true;
			m_gen_alg.PreparePopulation();
		}
		while(m_running)
		{
			m_generations=m_gen_alg.StepGeneration();
			m_intersections=m_gen_alg.GetBestIntersections();
			m_fitness=m_gen_alg.GetBestFitness();
			SetDlgItemInt(IDC_EDIT_GENERATIONS,m_generations,TRUE);
			SetDlgItemInt(IDC_EDIT_INTERSECTIONS,m_intersections,TRUE);
			SetDlgItemInt(IDC_EDIT_FITNESS,m_fitness,FALSE);
			MSG msg;
			while(PeekMessage(&msg,NULL,0,0,PM_REMOVE))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
	}
}

void CDlgSmoothCaseGraph::Init(CTypedPtrArray<CObArray,CPNStep*>& steps,int nSteps,CTypedPtrArray<CObArray,CPNCase*>& cases,int nCases)
{
	m_intersections=0;
	m_generations=0;
	m_fitness=0;
	m_started=false;
	m_best_exist=false;
	m_population_prepared=false;
	m_gen_alg.Init(steps,nSteps,cases,nCases);
	m_nCases=nCases;
	m_nSteps=nSteps;
	m_pCase_graph_cases=&cases;
	m_pCase_graph_steps=&steps;
}

void CDlgSmoothCaseGraph::OnBtnSettings() 
{
	CDlgGASettings dlg;
	dlg.m_prob_cross=m_gen_alg.m_prob_cross;
	dlg.m_grid_size=m_gen_alg.m_nGrid_size;
	dlg.m_chr_len=m_gen_alg.m_nChromozome_len;
	dlg.m_prob_mut_move=m_gen_alg.m_prob_mutate_move;
	dlg.m_prob_mut_sm_move=m_gen_alg.m_prob_mutate_smallmove;
	dlg.m_prob_mut_swap=m_gen_alg.m_prob_mutate_swap;
	dlg.m_population=m_gen_alg.m_nPopulation;
	dlg.m_started=m_started;
	dlg.m_weight_intersections=m_gen_alg.m_weight_intersections;
	dlg.m_weight_edgelength=m_gen_alg.m_weight_edgelength;
	dlg.m_weight_objdistance_min=m_gen_alg.m_weight_objdistance_min;
	dlg.m_weight_objdistance_max=m_gen_alg.m_weight_objdistance_max;
	if(dlg.DoModal()==IDOK)
	{
		m_gen_alg.m_prob_cross=dlg.m_prob_cross;
		m_gen_alg.m_nGrid_size=dlg.m_grid_size;
		if(m_gen_alg.m_nGrid_size<m_min_grid_size)m_gen_alg.m_nGrid_size=m_min_grid_size;
		m_gen_alg.m_prob_mutate_move=dlg.m_prob_mut_move;
		m_gen_alg.m_prob_mutate_smallmove=dlg.m_prob_mut_sm_move;
		m_gen_alg.m_prob_mutate_swap=dlg.m_prob_mut_swap;
		m_gen_alg.m_nPopulation=dlg.m_population;
		if(m_gen_alg.m_nPopulation<3)m_gen_alg.m_nPopulation=3;
		if((m_gen_alg.m_nPopulation%2)!=1)m_gen_alg.m_nPopulation++; // uprava na lichy pocet
		m_gen_alg.m_weight_intersections=dlg.m_weight_intersections;
		m_gen_alg.m_weight_edgelength=dlg.m_weight_edgelength;
		m_gen_alg.m_weight_objdistance_min=dlg.m_weight_objdistance_min;
		m_gen_alg.m_weight_objdistance_max=dlg.m_weight_objdistance_max;
		if((m_gen_alg.m_weight_intersections==0) && (m_gen_alg.m_weight_edgelength==0) && (m_gen_alg.m_weight_objdistance_min==0) && (m_gen_alg.m_weight_objdistance_max==0))m_gen_alg.m_weight_intersections=1;
	}
}

void CDlgSmoothCaseGraph::OnBtnStop() 
{
	m_running=false;	
	m_btn_cancel.EnableWindow(TRUE);
	m_btn_ok.EnableWindow(TRUE);
	m_btn_stop.EnableWindow(FALSE);
	m_btn_start.EnableWindow(TRUE);
	m_btn_reset.EnableWindow(TRUE);
	m_btn_settings.EnableWindow(TRUE);
}

void CDlgSmoothCaseGraph::SetInfo(int grid_size,int min_grid_size)
{
	m_min_grid_size=min_grid_size;
	m_gen_alg.SetInfo(grid_size);
}

void CDlgSmoothCaseGraph::OnBtnReset() 
{
	m_intersections=0;
	m_generations=0;
	m_fitness=0;
	SetDlgItemInt(IDC_EDIT_FITNESS,m_fitness,FALSE);
	SetDlgItemInt(IDC_EDIT_GENERATIONS,m_generations,TRUE);
	SetDlgItemInt(IDC_EDIT_INTERSECTIONS,m_intersections,TRUE);
	m_started=false;
	m_best_exist=false;
	m_population_prepared=false;
	m_gen_alg.Init(*m_pCase_graph_steps,m_nSteps,*m_pCase_graph_cases,m_nCases);
}

void CDlgSmoothCaseGraph::DeleteContents()
{
	m_intersections=0;
	m_generations=0;
	m_fitness=0;
	m_started=false;
	m_best_exist=false;
	m_population_prepared=false;
	m_gen_alg.DeleteContents();
}
